/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalRogueStellarObjectEPEC;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.shared.WormholeManager;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class GateHaulerLocation {
    public static Color ABYSS_AMBIENT_LIGHT_COLOR = new Color(100, 100, 100, 255);

    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Deep Space");
        system.setName("Deep Space");
        system.setType(StarSystemGenerator.StarSystemType.DEEP_SPACE);
        system.addTag("theme_hidden");
        system.addTag("theme_special");
        LocationAPI hyper = Global.getSector().getHyperspace();
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        Random random = StarSystemGenerator.random;
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        float angle = 180.0f + random.nextFloat() * 90.0f;
        float systemDist = 4000.0f + random.nextFloat() * 2000.0f;
        Vector2f systemLoc = Misc.getUnitVectorAtDegreeAngle(angle);
        systemLoc.scale(systemDist);
        systemLoc.x -= 1000.0f;
        system.getLocation().set(-w / 2.0f + systemLoc.x, -h / 2.0f + systemLoc.y);
        SectorEntityToken center = system.initNonStarCenter();
        system.setLightColor(ABYSS_AMBIENT_LIGHT_COLOR);
        center.addTag("ambient_ls");
        String name = Misc.genEntityCatalogId(3125, 6, 11, Misc.CatalogEntryType.GIANT);
        PlanetAPI giant = system.addPlanet("nameless_ice_giant", null, name, "ice_giant", 0.0f, 450.0f, 0.0f, 0.0f);
        giant.getMemoryWithoutUpdate().set("$gateHaulerIceGiant", true);
        giant.getMarket().addCondition("dense_atmosphere");
        giant.getMarket().addCondition("cold");
        giant.getMarket().addCondition("dark");
        giant.getMarket().addCondition("volatiles_trace");
        giant.getMarket().addCondition("high_gravity");
        giant.setOrbit(null);
        giant.setLocation(0.0f, 0.0f);
        BaseThemeGenerator.EntityLocation loc = new BaseThemeGenerator.EntityLocation();
        float orbitRadius = 7000.0f;
        float orbitDays = orbitRadius / (20.0f + 5.0f * StarSystemGenerator.random.nextFloat());
        loc.orbit = Global.getFactory().createCircularOrbit(giant, StarSystemGenerator.random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(system, loc, "stable_location", "neutral");
        Iterator<SectorEntityToken> iterator = system.getEntitiesWithTag("stable_location").iterator();
        if (iterator.hasNext()) {
            SectorEntityToken curr = iterator.next();
            SpecialItemData item = WormholeManager.createWormholeAnchor("charlie", "Charlie");
            JumpPointAPI wormhole = WormholeManager.get().addWormhole(item, curr, null);
            wormhole.getMemoryWithoutUpdate().unset("$unstable");
        }
        orbitRadius = giant.getRadius() + 250.0f;
        orbitDays = orbitRadius / (20.0f + random.nextFloat() * 5.0f);
        float spin = 3.0f;
        loc = new BaseThemeGenerator.EntityLocation();
        loc.orbit = Global.getFactory().createCircularOrbitWithSpin(giant, random.nextFloat() * 360.0f, orbitRadius, orbitDays, spin);
        added = BaseThemeGenerator.addEntity(null, (LocationAPI)system, loc, "derelict_gatehauler", "neutral");
        added.entity.getMemoryWithoutUpdate().set("$gateHauler", true);
        system.autogenerateHyperspaceJumpPoints(true, false);
        AbyssalRogueStellarObjectEPEC.setAbyssalDetectedRanges(system);
    }
}

