/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.codex;

import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.impl.codex.CodexDialogAPI;
import com.fs.starfarer.api.impl.codex.CodexEntryPlugin;
import com.fs.starfarer.api.impl.codex.CodexEntryV2;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.PositionAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class CodexCustomEntryExample
extends CodexEntryV2
implements CustomUIPanelPlugin {
    protected CustomPanelAPI panel;
    protected UIPanelAPI relatedEntries;
    protected UIPanelAPI box;
    protected CodexDialogAPI codex;

    public CodexCustomEntryExample(String id, String title, String icon) {
        super(id, title, icon);
    }

    @Override
    public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
        super.createTitleForList(info, width, mode);
    }

    @Override
    public boolean hasCustomDetailPanel() {
        return true;
    }

    @Override
    public CustomUIPanelPlugin getCustomPanelPlugin() {
        return this;
    }

    @Override
    public void destroyCustomDetail() {
        this.panel = null;
        this.relatedEntries = null;
        this.box = null;
        this.codex = null;
    }

    @Override
    public void createCustomDetail(CustomPanelAPI panel, UIPanelAPI relatedEntries, CodexDialogAPI codex) {
        this.panel = panel;
        this.relatedEntries = relatedEntries;
        this.codex = codex;
        Color color = Misc.getBasePlayerColor();
        Color dark = Misc.getDarkPlayerColor();
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float opad = 10.0f;
        float pad = 3.0f;
        float small = 5.0f;
        float width = panel.getPosition().getWidth();
        float initPad = 0.0f;
        float horzBoxPad = 30.0f;
        float tw = width - 290.0f - opad - horzBoxPad + 10.0f;
        TooltipMakerAPI text = panel.createUIElement(tw, 0.0f, false);
        text.setParaSmallInsignia();
        String design = "Cicero";
        if (design != null && !design.toLowerCase().equals("common")) {
            text.setParaFontDefault();
            Misc.addDesignTypePara(text, design, initPad);
            text.setParaSmallInsignia();
            initPad = opad;
        }
        text.addPara("Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.", initPad);
        int i = 0;
        while (i < 10) {
            text.addPara("Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.", opad);
            ++i;
        }
        panel.updateUIElementSizeAndMakeItProcessInput(text);
        this.box = panel.wrapTooltipWithBox(text);
        panel.addComponent(this.box).inTL(0.0f, 0.0f);
        if (relatedEntries != null) {
            panel.addComponent(relatedEntries).inTR(0.0f, 0.0f);
        }
        float height = this.box.getPosition().getHeight();
        if (relatedEntries != null) {
            height = Math.max(height, relatedEntries.getPosition().getHeight());
        }
        panel.getPosition().setSize(width, height);
    }

    @Override
    public void positionChanged(PositionAPI position) {
    }

    @Override
    public void renderBelow(float alphaMult) {
        PositionAPI p = this.relatedEntries.getPosition();
        float x = p.getX();
        float y = p.getY();
        float w = p.getWidth();
        float h = p.getHeight();
        Color color = Misc.getDarkPlayerColor();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Misc.renderQuad(x, y - 110.0f, w, 100.0f, color, alphaMult);
    }

    @Override
    public void render(float alphaMult) {
    }

    @Override
    public void advance(float amount) {
    }

    @Override
    public void processInput(List<InputEventAPI> events) {
    }

    @Override
    public void buttonPressed(Object buttonId) {
    }
}

