/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.codex;

import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.campaign.CustomUIPanelPlugin;
import com.fs.starfarer.api.impl.codex.CodexDataV2;
import com.fs.starfarer.api.impl.codex.CodexDialogAPI;
import com.fs.starfarer.api.impl.codex.CodexEntryPlugin;
import com.fs.starfarer.api.loading.WithSourceMod;
import com.fs.starfarer.api.ui.CustomPanelAPI;
import com.fs.starfarer.api.ui.TagDisplayAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CodexEntryV2
implements CodexEntryPlugin {
    protected String id;
    protected String title;
    protected String icon;
    protected CodexEntryPlugin parent;
    protected Object param;
    protected Object param2;
    protected List<CodexEntryPlugin> children = new ArrayList<CodexEntryPlugin>();
    protected Set<String> related = new LinkedHashSet<String>();
    protected boolean retainOrderOfChildren = false;
    protected boolean retainOrderOfRelatedEntries = false;
    protected float categorySortTierForRelatedEntries = 1000.0f;
    protected Set<String> tags = new LinkedHashSet<String>();
    protected boolean checking = false;

    public CodexEntryV2(String id, String title, String icon) {
        this.id = id;
        this.title = title;
        this.icon = icon;
    }

    public CodexEntryV2(String id, String title, String icon, Object param) {
        this.id = id;
        this.title = title;
        this.icon = icon;
        this.param = param;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getSortTitle() {
        return this.getTitle();
    }

    @Override
    public String getSearchString() {
        return this.getTitle();
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public CodexEntryPlugin getParent() {
        return this.parent;
    }

    @Override
    public void setParent(CodexEntryPlugin parent) {
        this.parent = parent;
    }

    @Override
    public Object getParam() {
        return this.param;
    }

    public void setParam(Object param) {
        this.param = param;
    }

    @Override
    public List<CodexEntryPlugin> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(CodexEntryPlugin entry) {
        if (entry == null) {
            return;
        }
        entry.setParent(this);
        this.children.add(entry);
    }

    @Override
    public boolean isRetainOrderOfChildren() {
        return this.retainOrderOfChildren;
    }

    @Override
    public void setRetainOrderOfChildren(boolean retainOrderOfChildren) {
        this.retainOrderOfChildren = retainOrderOfChildren;
    }

    @Override
    public boolean isCategory() {
        return !this.getChildren().isEmpty() || this.getParam() == null;
    }

    @Override
    public void createTitleForList(TooltipMakerAPI info, float width, CodexEntryPlugin.ListMode mode) {
        if (this.isCategory()) {
            info.setParaSmallInsignia();
        }
        info.addPara(this.getTitle(), Misc.getBasePlayerColor(), 0.0f);
    }

    @Override
    public boolean hasDetail() {
        return !this.isCategory();
    }

    @Override
    public boolean matchesTags(Set<String> tags) {
        return true;
    }

    @Override
    public boolean hasTagDisplay() {
        return false;
    }

    @Override
    public void configureTagDisplay(TagDisplayAPI tags) {
    }

    @Override
    public Set<String> getRelatedEntryIds() {
        return this.related;
    }

    @Override
    public Set<CodexEntryPlugin> getRelatedEntries() {
        LinkedHashSet<CodexEntryPlugin> result = new LinkedHashSet<CodexEntryPlugin>();
        for (String id : this.related) {
            CodexEntryPlugin entry = CodexDataV2.getEntry(id);
            if (entry == null || entry == this) continue;
            result.add(entry);
        }
        return result;
    }

    @Override
    public void addRelatedEntry(CodexEntryPlugin entry) {
        if (entry == null || entry.getId().equals(this.getId())) {
            return;
        }
        this.related.add(entry.getId());
    }

    @Override
    public void addRelatedEntry(String id) {
        if (id == null) {
            return;
        }
        this.related.add(id);
    }

    @Override
    public void removeRelatedEntry(CodexEntryPlugin entry) {
        if (entry == null) {
            return;
        }
        this.related.remove(entry.getId());
    }

    @Override
    public void removeRelatedEntry(String id) {
        this.related.remove(id);
    }

    @Override
    public boolean isRetainOrderOfRelatedEntries() {
        return this.retainOrderOfRelatedEntries;
    }

    @Override
    public void setRetainOrderOfRelatedEntries(boolean retainOrderOfRelatedEntries) {
        this.retainOrderOfRelatedEntries = retainOrderOfRelatedEntries;
    }

    @Override
    public float getCategorySortTierForRelatedEntries() {
        return this.categorySortTierForRelatedEntries;
    }

    @Override
    public void setCategorySortTierForRelatedEntries(float categorySortTierForRelatedEntries) {
        this.categorySortTierForRelatedEntries = categorySortTierForRelatedEntries;
    }

    @Override
    public List<CodexEntryPlugin> getChildrenRecursive(boolean includeCategories) {
        ArrayList<CodexEntryPlugin> result = new ArrayList<CodexEntryPlugin>();
        this.findChildren(this, result, includeCategories);
        return result;
    }

    public void findChildren(CodexEntryPlugin curr, List<CodexEntryPlugin> result, boolean includeCategories) {
        if (includeCategories || !curr.isCategory()) {
            result.add(curr);
        }
        for (CodexEntryPlugin child : curr.getChildren()) {
            this.findChildren(child, result, includeCategories);
        }
    }

    @Override
    public boolean hasCustomDetailPanel() {
        return false;
    }

    @Override
    public CustomUIPanelPlugin getCustomPanelPlugin() {
        return null;
    }

    @Override
    public void createCustomDetail(CustomPanelAPI panel, UIPanelAPI relatedEntries, CodexDialogAPI codex) {
    }

    @Override
    public void destroyCustomDetail() {
    }

    @Override
    public boolean isVignetteIcon() {
        return false;
    }

    public boolean areAnyRelatedEntriesVisible() {
        if (this.checking) {
            return false;
        }
        this.checking = true;
        boolean found = false;
        for (CodexEntryPlugin rel : this.getRelatedEntries()) {
            if (!rel.isVisible()) continue;
            found = true;
            break;
        }
        this.checking = false;
        return found;
    }

    public boolean areAnyRelatedEntriesUnlocked() {
        if (this.checking) {
            return this.isUnlockedIfRequiresUnlock();
        }
        this.checking = true;
        boolean found = false;
        for (CodexEntryPlugin rel : this.getRelatedEntries()) {
            if (rel.isLocked()) continue;
            found = true;
            break;
        }
        this.checking = false;
        return found;
    }

    @Override
    public boolean isVisible() {
        return this.isVisibleStandard(this.getUnlockRelatedTags(), this.isUnlockedIfRequiresUnlock());
    }

    @Override
    public boolean isLocked() {
        return this.isLockedStandard(this.getUnlockRelatedTags(), this.isUnlockedIfRequiresUnlock());
    }

    @Override
    public boolean checkTagsWhenLocked() {
        return false;
    }

    public Set<String> getUnlockRelatedTags() {
        return null;
    }

    public boolean isUnlockedIfRequiresUnlock() {
        return true;
    }

    public boolean isVisibleStandard(Set<String> tags, boolean thingUnlocked) {
        if (tags == null) {
            return true;
        }
        if (tags.contains("invisible_in_codex")) {
            return false;
        }
        if (tags.contains("codex_unlockable")) {
            return true;
        }
        if (tags.contains("codex_require_related")) {
            return this.areAnyRelatedEntriesVisible();
        }
        return true;
    }

    public boolean isLockedStandard(Set<String> tags, boolean thingUnlocked) {
        if (tags == null) {
            return false;
        }
        if (CodexDataV2.codexFullyUnlocked()) {
            return false;
        }
        if (tags.contains("codex_unlockable") && !thingUnlocked) {
            return true;
        }
        if (tags.contains("codex_require_related")) {
            return !this.areAnyRelatedEntriesUnlocked();
        }
        return false;
    }

    @Override
    public Object getParam2() {
        return this.param2;
    }

    public void setParam2(Object param2) {
        this.param2 = param2;
    }

    @Override
    public boolean skipForTags() {
        return false;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public void addTag(String tag) {
        this.tags.add(tag);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public ModSpecAPI getSourceMod() {
        if (this.getParam() instanceof WithSourceMod) {
            return ((WithSourceMod)this.getParam()).getSourceMod();
        }
        return null;
    }
}

