/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.codex;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.PlayerMarketTransaction;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemSpecAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.campaign.listeners.CargoScreenListener;
import com.fs.starfarer.api.campaign.listeners.CodexEventListener;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.SharedUnlockData;
import com.fs.starfarer.api.impl.codex.CodexDataV2;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashSet;
import java.util.List;

public class CodexUnlocker
implements FleetEventListener,
CodexEventListener,
CargoScreenListener {
    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI nullHere, CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (battle == null || !battle.isPlayerInvolved()) {
            return;
        }
        LinkedHashSet<String> hulls = new LinkedHashSet<String>();
        for (CampaignFleetAPI fleet : battle.getNonPlayerSideSnapshot()) {
            List<FleetMemberAPI> members = Misc.getSnapshotMembersLost(fleet);
            for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
                if (members.contains(member)) continue;
                members.add(member);
            }
            for (FleetMemberAPI member : members) {
                if (!member.getHullSpec().hasTag("codex_unlockable")) continue;
                String hullId = CodexDataV2.getFleetMemberBaseHullId(member);
                if (SharedUnlockData.get().isPlayerAwareOfShip(hullId)) continue;
                hulls.add(hullId);
            }
        }
        if (!hulls.isEmpty()) {
            for (String hullId : hulls) {
                SharedUnlockData.get().reportPlayerAwareOfShip(hullId, false);
            }
            SharedUnlockData.get().saveIfNeeded();
        }
    }

    @Override
    public void reportCargoScreenOpened() {
        this.unlockStuff();
    }

    @Override
    public void reportAboutToOpenCodex() {
        this.unlockStuff();
    }

    public void unlockStuff() {
        if (Global.getCurrentState() != GameState.CAMPAIGN) {
            return;
        }
        CampaignFleetAPI fleet = Global.getSector().getPlayerFleet();
        if (fleet == null || fleet.getFleetData() == null) {
            return;
        }
        CargoAPI cargo = fleet.getCargo();
        if (cargo == null) {
            return;
        }
        boolean save = false;
        for (CargoStackAPI stack : cargo.getStacksCopy()) {
            CommoditySpecAPI commodity;
            SpecialItemSpecAPI item;
            HullModSpecAPI hullmod;
            Object weapon;
            FighterWingSpecAPI wing = stack.getFighterWingSpecIfWing();
            if (wing != null && wing.hasTag("codex_unlockable")) {
                save |= SharedUnlockData.get().reportPlayerAwareOfFighter(wing.getId(), false);
            }
            if ((weapon = stack.getWeaponSpecIfWeapon()) != null && weapon.hasTag("codex_unlockable")) {
                save |= SharedUnlockData.get().reportPlayerAwareOfWeapon(weapon.getWeaponId(), false);
            }
            if ((hullmod = stack.getHullModSpecIfHullMod()) != null && hullmod.hasTag("codex_unlockable")) {
                save |= SharedUnlockData.get().reportPlayerAwareOfHullmod(hullmod.getId(), false);
            }
            if ((item = stack.getSpecialItemSpecIfSpecial()) != null && item.hasTag("codex_unlockable")) {
                save |= SharedUnlockData.get().reportPlayerAwareOfSpecialItem(item.getId(), false);
            }
            if ((commodity = stack.getResourceIfResource()) == null || !commodity.hasTag("codex_unlockable")) continue;
            save |= SharedUnlockData.get().reportPlayerAwareOfCommodity(commodity.getId(), false);
        }
        for (MarketAPI market : Misc.getPlayerMarkets(true)) {
            for (Industry ind : market.getIndustries()) {
                if (!ind.getSpec().hasTag("codex_unlockable")) continue;
                save |= SharedUnlockData.get().reportPlayerAwareOfIndustry(ind.getSpec().getId(), false);
            }
        }
        MutableCharacterStatsAPI stats = Global.getSector().getPlayerStats();
        if (stats != null) {
            for (MutableCharacterStatsAPI.SkillLevelAPI sl : stats.getSkillsCopy()) {
                if (!(sl.getLevel() > 0.0f) || !sl.getSkill().hasTag("codex_unlockable")) continue;
                save |= SharedUnlockData.get().reportPlayerAwareOfSkill(sl.getSkill().getId(), false);
            }
        }
        for (AbilityPlugin ability : fleet.getAbilities().values()) {
            if (!ability.getSpec().hasTag("codex_unlockable")) continue;
            save |= SharedUnlockData.get().reportPlayerAwareOfAbility(ability.getSpec().getId(), false);
        }
        for (FleetMemberAPI member : fleet.getFleetData().getMembersListCopy()) {
            if (!member.getHullSpec().hasTag("codex_unlockable")) continue;
            String hullId = CodexDataV2.getFleetMemberBaseHullId(member);
            save |= SharedUnlockData.get().reportPlayerAwareOfShip(hullId, true);
        }
        if (save) {
            SharedUnlockData.get().saveIfNeeded();
        }
    }

    @Override
    public void reportClosedCodex() {
    }

    public static void makeAwareOfConditionsOn(MarketAPI market) {
        if (market == null) {
            return;
        }
        boolean save = false;
        for (MarketConditionAPI mc : market.getConditions()) {
            if (!mc.getSpec().hasTag("codex_unlockable")) continue;
            save |= SharedUnlockData.get().reportPlayerAwareOfCondition(mc.getSpec().getId(), false);
        }
        if (save) {
            SharedUnlockData.get().saveIfNeeded();
        }
    }

    @Override
    public void reportPlayerLeftCargoPods(SectorEntityToken entity) {
    }

    @Override
    public void reportPlayerNonMarketTransaction(PlayerMarketTransaction transaction, InteractionDialogAPI dialog) {
    }

    @Override
    public void reportSubmarketOpened(SubmarketAPI submarket) {
    }
}

