/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.codex;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.impl.campaign.intel.misc.FleetLogIntel;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;

public class CodexUpdateIntel
extends FleetLogIntel {
    protected LinkedHashSet<String> unlockedEntries;

    public CodexUpdateIntel(LinkedHashSet<String> unlockedEntries) {
        this.unlockedEntries = unlockedEntries;
        Global.getSector().getIntelManager().addIntel(this);
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        this.bullet(info);
        if (!this.unlockedEntries.isEmpty()) {
            String entries = this.unlockedEntries.size() == 1 ? "entry" : "entries";
            info.addPara("%s new Codex " + entries, initPad, tc, h, "" + this.unlockedEntries.size());
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        if (!this.unlockedEntries.isEmpty()) {
            info.addPara("New Codex entries available.", opad);
            info.addCodexEntries("New entries", this.unlockedEntries, true, opad);
            float ew = info.getPrev().getPosition().getWidth();
            float xOff = (int)((width - ew) / 2.0f);
            info.getPrev().getPosition().setXAlignOffset(xOff);
            info.addSpacer(0.0f).getPosition().setXAlignOffset(-xOff);
        }
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public String getIcon() {
        return Global.getSettings().getSpriteName("intel", "codex_update");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        return tags;
    }

    @Override
    public String getName() {
        return "Codex Update";
    }
}

