/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.combat.CombatReadinessPlugin;
import com.fs.starfarer.api.combat.FighterLaunchBayAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.combat.LowCRShipDamageSequence;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CRPluginImpl
implements CombatReadinessPlugin {
    public static float NO_SYSTEM_THRESHOLD = 0.0f;
    public static float IMPROVE_START = 0.7f;
    public static float DEGRADE_START = 0.5f;
    public static float SHIELD_MALFUNCTION_START = 0.1f;
    public static float CRITICAL_MALFUNCTION_START = 0.2f;
    public static float MALFUNCTION_START = 0.4f;
    public static float MISSILE_AMMO_REDUCTION_START = 0.4f;
    public static float MAX_MOVEMENT_CHANGE = 10.0f;
    public static float MAX_DAMAGE_TAKEN_CHANGE = 10.0f;
    public static float MAX_DAMAGE_CHANGE = 10.0f;
    public static float MAX_REFIT_CHANGE = 10.0f;
    public static float MAX_SHIELD_MALFUNCTION_CHANCE = 5.0f;
    public static float MAX_CRITICAL_MALFUNCTION_CHANCE = 25.0f;
    public static float MAX_ENGINE_MALFUNCTION_CHANCE = 7.5f;
    public static float MAX_WEAPON_MALFUNCTION_CHANCE = 10.0f;
    protected static Object[] statusKeys = new Object[]{new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object(), new Object()};

    @Override
    public void applyMaxCRCrewModifiers(FleetMemberAPI member) {
        if (member == null || member.getStats() == null) {
            return;
        }
        float maxCRBasedOnLevel = 0.7f;
        member.getStats().getMaxCombatReadiness().modifyFlat("crew skill bonus", maxCRBasedOnLevel, "Basic maintenance");
        float cf = member.getCrewFraction();
        if (cf < 1.0f) {
            float penalty = 0.5f * (1.0f - cf);
            member.getStats().getMaxCombatReadiness().modifyFlat("crew understrength", -penalty, "Crew understrength");
        } else {
            member.getStats().getMaxCombatReadiness().unmodifyFlat("crew understrength");
        }
    }

    @Override
    public List<CombatReadinessPlugin.CRStatusItemData> getCRStatusDataForShip(ShipAPI ship) {
        CombatReadinessPlugin.CRStatusItemData itemData;
        CombatReadinessPlugin.CRStatusItemData itemData2;
        float startingCR = ship.getCRAtDeployment();
        float cr = ship.getCurrentCR();
        ArrayList<CombatReadinessPlugin.CRStatusItemData> list = new ArrayList<CombatReadinessPlugin.CRStatusItemData>();
        String icon = null;
        icon = cr > this.getImproveThreshold(ship.getMutableStats()) ? Global.getSettings().getSpriteName("ui", "icon_tactical_cr_bonus") : (cr < this.getDegradeThreshold(ship.getMutableStats()) ? Global.getSettings().getSpriteName("ui", "icon_tactical_cr_penalty") : Global.getSettings().getSpriteName("ui", "icon_tactical_cr_neutral"));
        String title = "Combat Readiness " + Math.round(cr * 100.0f) + "%";
        String malfStr = this.getMalfunctionString(ship.getMutableStats(), cr);
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getShield() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[9], icon, title, "Shields offline", true);
            list.add(itemData2);
        }
        if (cr <= NO_SYSTEM_THRESHOLD) {
            boolean hasWings = false;
            for (FighterLaunchBayAPI bay : ship.getLaunchBaysCopy()) {
                if (bay.getWing() == null) continue;
                hasWings = true;
                break;
            }
            if (hasWings) {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[10], icon, title, "Fighter bays offline", true);
                list.add(itemData);
            }
        }
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getPhaseCloak() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[8], icon, title, String.valueOf(ship.getPhaseCloak().getDisplayName()) + " offline", true);
            list.add(itemData2);
        }
        if (cr <= NO_SYSTEM_THRESHOLD && ship.getSystem() != null) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[7], icon, title, String.valueOf(ship.getSystem().getDisplayName()) + " offline", true);
            list.add(itemData2);
        }
        if (cr < this.getMalfunctionThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[0], icon, title, "malfunction risk: " + malfStr, true);
            list.add(itemData2);
        }
        if (startingCR < this.getMissileAmmoReductionThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[2], icon, title, "missiles not fully loaded", true);
            list.add(itemData2);
        }
        if (cr < this.getDegradeThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[3], icon, title, "degraded performance", true);
            list.add(itemData2);
        } else if (cr > this.getImproveThreshold(ship.getMutableStats())) {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[4], icon, title, "improved performance", false);
            list.add(itemData2);
        } else {
            itemData2 = new CombatReadinessPlugin.CRStatusItemData(statusKeys[8], icon, title, "standard performance", false);
            list.add(itemData2);
        }
        if (ship.losesCRDuringCombat() && cr > 0.0f) {
            float noLossTime = ship.getMutableStats().getPeakCRDuration().computeEffective(ship.getHullSpec().getNoCRLossTime());
            if (noLossTime > ship.getTimeDeployedForCRReduction()) {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[5], icon, "peak active performance", "remaining time: " + (int)(noLossTime - ship.getTimeDeployedForCRReduction()) + " sec", false);
                list.add(itemData);
            } else {
                itemData = new CombatReadinessPlugin.CRStatusItemData(statusKeys[6], icon, "combat stresses", "degrading readiness", true);
                list.add(itemData);
            }
        }
        return list;
    }

    private float getWeaponMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_WEAPON_MALFUNCTION_CHANCE * (this.getMalfunctionThreshold(stats) - cr) / this.getMalfunctionThreshold(stats);
    }

    private float getEngineMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_ENGINE_MALFUNCTION_CHANCE * (this.getMalfunctionThreshold(stats) - cr) / this.getMalfunctionThreshold(stats);
    }

    private float getCriticalMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_CRITICAL_MALFUNCTION_CHANCE * (this.getCriticalMalfunctionThreshold(stats) - cr) / this.getCriticalMalfunctionThreshold(stats);
    }

    private float getShieldMalfuctionPercent(MutableShipStatsAPI stats, float cr) {
        return MAX_SHIELD_MALFUNCTION_CHANCE * (this.getShieldMalfunctionThreshold(stats) - cr) / this.getShieldMalfunctionThreshold(stats);
    }

    private float getMovementChangePercent(MutableShipStatsAPI stats, float cr) {
        float movementChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            movementChange = -1.0f * f * MAX_MOVEMENT_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            movementChange = 1.0f * f * MAX_MOVEMENT_CHANGE;
        }
        return movementChange;
    }

    private float getDamageTakenChangePercent(MutableShipStatsAPI stats, float cr) {
        float damageTakenChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            damageTakenChange = 1.0f * f * MAX_DAMAGE_TAKEN_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            damageTakenChange = -1.0f * f * MAX_DAMAGE_TAKEN_CHANGE;
        }
        return damageTakenChange;
    }

    private float getRefitTimeChangePercent(MutableShipStatsAPI stats, float cr) {
        float refitTimeChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            refitTimeChange = 1.0f * f * MAX_REFIT_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            refitTimeChange = -1.0f * f * MAX_REFIT_CHANGE;
        }
        return refitTimeChange;
    }

    private float getDamageChangePercent(MutableShipStatsAPI stats, float cr) {
        float damageChange = 0.0f;
        float d = this.getDegradeThreshold(stats);
        float i = this.getImproveThreshold(stats);
        if (cr < d) {
            float f = (d - cr) / d;
            damageChange = -1.0f * f * MAX_DAMAGE_CHANGE;
        } else if (cr > i) {
            float f = (cr - i) / (1.0f - i);
            damageChange = 1.0f * f * MAX_DAMAGE_CHANGE;
        }
        return damageChange;
    }

    private float getAimAccuracy(float cr) {
        return cr * 1.5f - 0.5f;
    }

    @Override
    public void applyCRToStats(float cr, MutableShipStatsAPI stats, ShipAPI.HullSize hullSize) {
        boolean fighter;
        String id = "cr_effect";
        boolean bl = fighter = hullSize == ShipAPI.HullSize.FIGHTER;
        if (!fighter) {
            if (cr < this.getMalfunctionThreshold(stats)) {
                stats.getWeaponMalfunctionChance().modifyFlat(id, 0.01f * this.getWeaponMalfuctionPercent(stats, cr));
                stats.getEngineMalfunctionChance().modifyFlat(id, 0.01f * this.getEngineMalfuctionPercent(stats, cr));
            } else {
                stats.getWeaponMalfunctionChance().unmodify(id);
                stats.getEngineMalfunctionChance().unmodify(id);
            }
        }
        if (!fighter) {
            if (cr < this.getCriticalMalfunctionThreshold(stats)) {
                stats.getCriticalMalfunctionChance().modifyFlat(id, 0.01f * this.getCriticalMalfuctionPercent(stats, cr));
            } else {
                stats.getCriticalMalfunctionChance().unmodify(id);
            }
        }
        if (!fighter) {
            if (cr < this.getShieldMalfunctionThreshold(stats)) {
                stats.getShieldMalfunctionChance().modifyFlat(id, 0.01f * this.getShieldMalfuctionPercent(stats, cr));
                stats.getShieldMalfunctionFluxLevel().modifyFlat(id, 0.75f);
            } else {
                stats.getShieldMalfunctionChance().unmodify(id);
                stats.getShieldMalfunctionFluxLevel().unmodify(id);
            }
        }
        if (!fighter && stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            if (cr <= NO_SYSTEM_THRESHOLD) {
                ship.setShipSystemDisabled(true);
                ship.setDefenseDisabled(true);
            } else {
                ship.setShipSystemDisabled(false);
                ship.setDefenseDisabled(false);
            }
        }
        float movementChange = this.getMovementChangePercent(stats, cr);
        float damageTakenChange = this.getDamageTakenChangePercent(stats, cr);
        float damageChange = this.getDamageChangePercent(stats, cr);
        float refitTimeChange = this.getRefitTimeChangePercent(stats, cr);
        if (refitTimeChange != 0.0f) {
            stats.getFighterRefitTimeMult().modifyPercent(id, refitTimeChange);
        } else {
            stats.getFighterRefitTimeMult().unmodify(id);
        }
        if (movementChange != 0.0f) {
            stats.getMaxSpeed().modifyPercent(id, movementChange);
            stats.getAcceleration().modifyPercent(id, movementChange);
            stats.getDeceleration().modifyPercent(id, movementChange);
            stats.getTurnAcceleration().modifyPercent(id, movementChange);
            stats.getMaxTurnRate().modifyPercent(id, movementChange);
        } else {
            stats.getMaxSpeed().unmodify(id);
            stats.getAcceleration().unmodify(id);
            stats.getDeceleration().unmodify(id);
            stats.getTurnAcceleration().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        }
        if (damageTakenChange != 0.0f) {
            stats.getArmorDamageTakenMult().modifyPercent(id, damageTakenChange);
            stats.getHullDamageTakenMult().modifyPercent(id, damageTakenChange);
            stats.getShieldDamageTakenMult().modifyPercent(id, damageTakenChange);
        } else {
            stats.getArmorDamageTakenMult().unmodify(id);
            stats.getHullDamageTakenMult().unmodify(id);
            stats.getShieldDamageTakenMult().unmodify(id);
        }
        if (damageChange != 0.0f) {
            stats.getBallisticWeaponDamageMult().modifyPercent(id, damageChange);
            stats.getEnergyWeaponDamageMult().modifyPercent(id, damageChange);
            stats.getMissileWeaponDamageMult().modifyPercent(id, damageChange);
        } else {
            stats.getBallisticWeaponDamageMult().unmodify(id);
            stats.getEnergyWeaponDamageMult().unmodify(id);
            stats.getMissileWeaponDamageMult().unmodify(id);
        }
        float aimAccuracy = this.getAimAccuracy(cr);
        stats.getAutofireAimAccuracy().modifyFlat(id, aimAccuracy);
    }

    @Override
    public void applyCRToShip(float cr, ShipAPI ship) {
        if (!ship.isFighter() && cr < this.getMissileAmmoReductionThreshold(ship.getMutableStats())) {
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.getType() != WeaponAPI.WeaponType.MISSILE) continue;
                float ammo = (float)weapon.getMaxAmmo() * this.getMissileLoadedFraction(ship.getMutableStats(), cr);
                if (ammo < 0.0f) {
                    ammo = 0.0f;
                }
                weapon.setAmmo(Math.round(ammo));
            }
        }
        ship.setCRAtDeployment(cr);
        float c = this.getCriticalMalfunctionThreshold(ship.getMutableStats());
        if (cr < c && !ship.controlsLocked() && !ship.isFighter()) {
            float severity = (c - cr) / c;
            if (Global.getCombatEngine() != null) {
                float criticalMult = 1.0f;
                for (MutableStat.StatMod mod : ship.getMutableStats().getCriticalMalfunctionChance().getMultMods().values()) {
                    criticalMult *= mod.getValue();
                }
                Global.getCombatEngine().addPlugin(new LowCRShipDamageSequence(ship, severity *= criticalMult));
            }
        }
    }

    @Override
    public float getMissileLoadedFraction(MutableShipStatsAPI stats, float cr) {
        return 1.0f;
    }

    @Override
    public float getMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return MALFUNCTION_START * mult - 0.001f;
    }

    @Override
    public float getCriticalMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return CRITICAL_MALFUNCTION_START * mult - 0.001f;
    }

    public float getShieldMalfunctionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return SHIELD_MALFUNCTION_START * mult;
    }

    public float getMissileAmmoReductionThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return MISSILE_AMMO_REDUCTION_START * mult - 0.001f;
    }

    public float getDegradeThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        if (stats != null) {
            mult *= stats.getDynamic().getStat("cr_malfunction_range_mult").getModifiedValue();
        }
        return DEGRADE_START * mult;
    }

    public float getImproveThreshold(MutableShipStatsAPI stats) {
        float mult = 1.0f;
        return IMPROVE_START * mult;
    }

    @Override
    public CombatReadinessPlugin.CREffectDescriptionForTooltip getCREffectDescription(float cr, String shipOrWing, FleetMemberAPI member) {
        CombatReadinessPlugin.CREffectDescriptionForTooltip result = new CombatReadinessPlugin.CREffectDescriptionForTooltip();
        List<CombatReadinessPlugin.CREffectDetail> details = this.getCREffectDetails(cr, member);
        boolean hasPositive = false;
        boolean hasNegative = false;
        for (CombatReadinessPlugin.CREffectDetail detail : details) {
            if (detail.getType() == CombatReadinessPlugin.CREffectDetailType.BONUS) {
                hasPositive = true;
            }
            if (detail.getType() != CombatReadinessPlugin.CREffectDetailType.PENALTY) continue;
            hasNegative = true;
        }
        float noDeploy = Global.getSettings().getFloat("noDeployCRPercent") * 0.01f;
        String crStr = String.valueOf((int)(cr * 100.0f)) + "%";
        String str = cr < noDeploy ? String.format("The %s is not ready for combat and can not be deployed in battle.", shipOrWing) : (cr < this.getCriticalMalfunctionThreshold(member.getStats()) ? String.format("The %s suffers from degraded performance and runs the risk of permanent and damaging malfunctions if deployed.", shipOrWing) : (cr < this.getMalfunctionThreshold(member.getStats()) ? String.format("The %s suffers from degraded performance and runs the risk of weapon and engine malfunctions during combat.", shipOrWing) : (cr < this.getDegradeThreshold(member.getStats()) && hasNegative ? String.format("The %s suffers from degraded performance during combat.", shipOrWing) : (cr < this.getImproveThreshold(member.getStats()) || !hasPositive ? String.format("The %s has standard combat performance.", shipOrWing) : String.format("The %s benefits from improved combat performance.", shipOrWing)))));
        if (member.isFighterWing()) {
            boolean canReplaceFighters = false;
            FleetDataAPI data = member.getFleetData();
            if (data != null) {
                for (FleetMemberAPI curr : data.getMembersListCopy()) {
                    if (curr.isMothballed() || curr.getNumFlightDecks() <= 0) continue;
                    canReplaceFighters = true;
                    break;
                }
            }
            if (canReplaceFighters) {
                details.add(new CombatReadinessPlugin.CREffectDetail("", "", CombatReadinessPlugin.CREffectDetailType.NEUTRAL));
                float costPer = member.getStats().getCRPerDeploymentPercent().computeEffective(member.getVariant().getHullSpec().getCRToDeploy()) / 100.0f;
                String numStr = "" + (int)Math.ceil((float)((int)(cr * 100.0f)) / (costPer * 100.0f));
                str = String.valueOf(str) + " " + numStr + " fighter chassis are ready to replace combat losses.";
                result.getHighlights().add(numStr);
            } else {
                details.add(new CombatReadinessPlugin.CREffectDetail("Replacement chassis", "None", CombatReadinessPlugin.CREffectDetailType.PENALTY));
                str = String.valueOf(str) + " Fighter losses can not be replaced due to the lack of a ship with proper facilities (i.e. a flight deck).";
            }
        }
        result.setString(str);
        return result;
    }

    private String getMalfunctionString(MutableShipStatsAPI stats, float cr) {
        String malfStr = "None";
        if (cr < this.getCriticalMalfunctionThreshold(stats)) {
            malfStr = "Critical";
        } else if (cr < 0.3f) {
            malfStr = "Serious";
        } else if (cr < this.getMalfunctionThreshold(stats)) {
            malfStr = "Low";
        }
        return malfStr;
    }

    @Override
    public List<CombatReadinessPlugin.CREffectDetail> getCREffectDetails(float cr, FleetMemberAPI member) {
        CombatReadinessPlugin.CREffectDetailType accType;
        String accString;
        ArrayList<CombatReadinessPlugin.CREffectDetail> result = new ArrayList<CombatReadinessPlugin.CREffectDetail>();
        int engine = (int)this.getEngineMalfuctionPercent(member.getStats(), cr);
        int weapon = (int)this.getWeaponMalfuctionPercent(member.getStats(), cr);
        int speed = Math.round(this.getMovementChangePercent(member.getStats(), cr));
        int damage = Math.round(this.getDamageTakenChangePercent(member.getStats(), cr));
        int damageDealt = Math.round(this.getDamageChangePercent(member.getStats(), cr));
        int refit = Math.round(this.getRefitTimeChangePercent(member.getStats(), cr));
        float acc = this.getAimAccuracy(cr);
        String malfStr = this.getMalfunctionString(member.getStats(), cr);
        if (acc < 0.0f) {
            accString = "Very poor";
            accType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        } else if (acc < 0.25f) {
            accString = "Poor";
            accType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        } else if ((double)acc < 0.67) {
            accString = "Standard";
            accType = CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        } else {
            accString = "Excellent";
            accType = CombatReadinessPlugin.CREffectDetailType.BONUS;
        }
        String speedStr = String.valueOf(speed) + "%";
        if (speed >= 0) {
            speedStr = "+" + speedStr;
        }
        String damageStr = String.valueOf(damage) + "%";
        if (damage >= 0) {
            damageStr = "+" + damageStr;
        }
        String rofStr = String.valueOf(damageDealt) + "%";
        if (damageDealt >= 0) {
            rofStr = "+" + rofStr;
        }
        String refitStr = String.valueOf(refit) + "%";
        if (refit >= 0) {
            refitStr = "+" + refitStr;
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("Speed & maneuverability", speedStr, this.getTypeFor(speed, false)));
        result.add(new CombatReadinessPlugin.CREffectDetail("Damage taken", damageStr, this.getTypeFor(damage, true)));
        result.add(new CombatReadinessPlugin.CREffectDetail("Damage dealt", rofStr, this.getTypeFor(damageDealt, false)));
        if (member.getNumFlightDecks() > 0) {
            result.add(new CombatReadinessPlugin.CREffectDetail("Fighter refit time", refitStr, this.getTypeFor(refit, true)));
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("Autofire accuracy", accString, accType));
        CombatReadinessPlugin.CREffectDetailType malfType = CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        if (this.getWeaponMalfuctionPercent(member.getStats(), cr) > 0.0f) {
            malfType = CombatReadinessPlugin.CREffectDetailType.PENALTY;
        }
        result.add(new CombatReadinessPlugin.CREffectDetail("Malfunction risk", malfStr, malfType));
        Collection<String> slots = member.getVariant().getFittedWeaponSlots();
        boolean hasMissiles = false;
        for (String slotId : slots) {
            WeaponSpecAPI w = member.getVariant().getWeaponSpec(slotId);
            if (w.getType() != WeaponAPI.WeaponType.MISSILE) continue;
            hasMissiles = true;
            break;
        }
        if (hasMissiles) {
            float missileFraction = this.getMissileLoadedFraction(member.getStats(), cr);
            if (missileFraction < 0.0f) {
                missileFraction = 0.0f;
            }
            String missileStr = String.valueOf((int)(missileFraction * 100.0f)) + "%";
            if (missileFraction < 1.0f) {
                result.add(new CombatReadinessPlugin.CREffectDetail("Missile magazines", missileStr, missileFraction < 1.0f ? CombatReadinessPlugin.CREffectDetailType.PENALTY : CombatReadinessPlugin.CREffectDetailType.NEUTRAL));
            }
        }
        return result;
    }

    private CombatReadinessPlugin.CREffectDetailType getTypeFor(int val, boolean invert) {
        if (invert) {
            if (val < 0) {
                return CombatReadinessPlugin.CREffectDetailType.BONUS;
            }
            if (val > 0) {
                return CombatReadinessPlugin.CREffectDetailType.PENALTY;
            }
            return CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
        }
        if (val > 0) {
            return CombatReadinessPlugin.CREffectDetailType.BONUS;
        }
        if (val < 0) {
            return CombatReadinessPlugin.CREffectDetailType.PENALTY;
        }
        return CombatReadinessPlugin.CREffectDetailType.NEUTRAL;
    }

    @Override
    public boolean isOkToPermanentlyDisable(ShipAPI ship, Object module) {
        return CRPluginImpl.isOkToPermanentlyDisableStatic(ship, module);
    }

    public static boolean isOkToPermanentlyDisableStatic(ShipAPI ship, Object module) {
        if (module instanceof ShipEngineControllerAPI.ShipEngineAPI) {
            float fractionIfDisabled = ((ShipEngineControllerAPI.ShipEngineAPI)module).getContribution() + ship.getEngineFractionPermanentlyDisabled();
            return !(fractionIfDisabled > 0.66f);
        }
        if (module instanceof WeaponAPI) {
            WeaponAPI.WeaponType type = ((WeaponAPI)module).getType();
            if (type == WeaponAPI.WeaponType.DECORATIVE || type == WeaponAPI.WeaponType.LAUNCH_BAY || type == WeaponAPI.WeaponType.SYSTEM) {
                return false;
            }
            if (ship.getCurrentCR() <= 0.0f) {
                return true;
            }
            ArrayList<WeaponAPI> usableWeapons = new ArrayList<WeaponAPI>();
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.isPermanentlyDisabled() || weapon.isDecorative() || weapon.getSlot().isSystemSlot() || weapon.getSlot().isDecorative() || weapon.getSlot().isStationModule() || weapon.getAmmo() <= 0 || weapon.getMaxAmmo() <= 20 && !(weapon.getSpec().getAmmoPerSecond() > 0.0f)) continue;
                usableWeapons.add(weapon);
            }
            usableWeapons.remove(module);
            return usableWeapons.size() >= 1;
        }
        return false;
    }
}

