/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CombatEntityPluginWithParticles
extends BaseCombatLayeredRenderingPlugin {
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected List<ParticleData> darkParticles = new ArrayList<ParticleData>();
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_AND_MISSILES_LAYER);
    protected CombatEngineLayers normalLayer;
    protected CombatEngineLayers darkLayer;
    protected ParticleData prev;
    protected String spriteSheetKey;
    protected String darkSpriteSheetKey;
    protected Float baseFacing = null;

    public CombatEntityPluginWithParticles() {
        this(CombatEngineLayers.ABOVE_PARTICLES_LOWER, CombatEngineLayers.ABOVE_PARTICLES);
    }

    public CombatEntityPluginWithParticles(CombatEngineLayers normalLayer, CombatEngineLayers darkLayer) {
        this.normalLayer = normalLayer;
        this.darkLayer = darkLayer;
        this.layers = EnumSet.of(normalLayer, darkLayer);
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public String getSpriteSheetKey() {
        return this.spriteSheetKey;
    }

    public void setSpriteSheetKey(String spriteSheetKey) {
        this.spriteSheetKey = spriteSheetKey;
    }

    public String getDarkSpriteSheetKey() {
        return this.darkSpriteSheetKey;
    }

    public void setDarkSpriteSheetKey(String darkSpriteSheetKey) {
        this.darkSpriteSheetKey = darkSpriteSheetKey;
    }

    public ParticleData addParticle(float baseSize, float durIn, float durOut, float endSizeMult, float maxDriftVel, float maxAngVel, Color color) {
        ParticleData p = new ParticleData(baseSize, durIn, durOut, endSizeMult, maxDriftVel, maxAngVel, color, this.spriteSheetKey);
        this.particles.add(p);
        this.prev = p;
        return p;
    }

    public ParticleData addDarkParticle(float baseSize, float durIn, float durOut, float endSizeMult, float maxDriftVel, float maxAngVel, Color color) {
        ParticleData p = new ParticleData(baseSize, durIn, durOut, endSizeMult, maxDriftVel, maxAngVel, color, this.darkSpriteSheetKey);
        this.darkParticles.add(p);
        this.prev = p;
        return p;
    }

    public void randomizePrevParticleLocation(float maxOffset) {
        Vector2f loc = Misc.getPointWithinRadius(this.prev.offset, maxOffset);
        this.prev.offset.set((ReadableVector2f)loc);
    }

    @Override
    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        ArrayList<ParticleData> remove = new ArrayList<ParticleData>();
        for (ParticleData p : this.particles) {
            p.advance(amount);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.particles.removeAll(remove);
        remove = new ArrayList();
        for (ParticleData p : this.darkParticles) {
            p.advance(amount);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.darkParticles.removeAll(remove);
    }

    @Override
    public boolean isExpired() {
        return this.particles.isEmpty() && this.darkParticles.isEmpty();
    }

    protected float getGlobalAlphaMult() {
        return 1.0f;
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        this.render(layer, viewport, null);
    }

    public void render(CombatEngineLayers layer, ViewportAPI viewport, DamagingProjectileAPI proj) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float b = viewport.getAlphaMult();
        if (proj != null && this.baseFacing == null) {
            this.baseFacing = Float.valueOf(proj.getFacing());
        }
        if (layer == this.normalLayer) {
            for (ParticleData p : this.particles) {
                float size = p.baseSize * p.scale;
                Vector2f offset = p.offset;
                float diff = 0.0f;
                if (this.baseFacing != null && proj != null && Math.abs(diff = Misc.getAngleDiff(this.baseFacing.floatValue(), proj.getFacing())) > 0.1f) {
                    offset = Misc.rotateAroundOrigin(offset, diff);
                }
                Vector2f loc = new Vector2f(x + offset.x, y + offset.y);
                float alphaMult = this.getGlobalAlphaMult();
                p.sprite.setAngle(p.angle);
                p.sprite.setSize(size, size);
                p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
                p.sprite.setColor(p.color);
                p.sprite.renderAtCenter(loc.x, loc.y);
            }
        } else if (layer == this.darkLayer) {
            GL14.glBlendEquation((int)32779);
            for (ParticleData p : this.darkParticles) {
                float size = p.baseSize * p.scale;
                Vector2f offset = p.offset;
                float diff = 0.0f;
                if (this.baseFacing != null && proj != null && Math.abs(diff = Misc.getAngleDiff(this.baseFacing.floatValue(), proj.getFacing())) > 0.1f) {
                    offset = Misc.rotateAroundOrigin(offset, diff);
                }
                Vector2f loc = new Vector2f(x + offset.x, y + offset.y);
                float alphaMult = this.getGlobalAlphaMult();
                p.sprite.setAngle(p.angle);
                p.sprite.setSize(size, size);
                p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
                p.sprite.setColor(p.color);
                p.sprite.renderAtCenter(loc.x, loc.y);
            }
            GL14.glBlendEquation((int)32774);
        }
    }

    public static class ParticleData {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float scaleIncreaseRate = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float maxDur;
        public FaderUtil fader;
        public float elapsed = 0.0f;
        public float baseSize;
        protected Color color;

        public ParticleData(float baseSize, float durIn, float durOut, float endSizeMult, float maxDriftVel, float maxAngVel, Color color, String spriteSheetKey) {
            this.color = color;
            if (spriteSheetKey == null) {
                spriteSheetKey = "nebula_particles";
            }
            this.sprite = Global.getSettings().getSprite("misc", spriteSheetKey);
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setAdditiveBlend();
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = durIn + durOut;
            this.scaleIncreaseRate = endSizeMult / this.maxDur;
            if (endSizeMult < 1.0f) {
                this.scaleIncreaseRate = -1.0f * endSizeMult;
            }
            this.scale = 1.0f;
            this.baseSize = baseSize;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * maxAngVel * (float)Math.random();
            float driftDir = (float)Math.random() * 360.0f;
            this.vel = Misc.getUnitVectorAtDegreeAngle(driftDir);
            this.vel.scale(maxDriftVel * (0.5f + (float)Math.random() * 0.5f));
            this.fader = new FaderUtil(0.0f, durIn, durOut);
            this.fader.setBounceDown(true);
            this.fader.forceOut();
            this.fader.fadeIn();
        }

        public void advance(float amount) {
            this.scale += this.scaleIncreaseRate * amount;
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            this.angle += this.turnDir * amount;
            this.elapsed += amount;
            this.fader.advance(amount);
        }
    }
}

