/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DisintegratorEffect
extends BaseCombatLayeredRenderingPlugin
implements OnHitEffectPlugin {
    public static int NUM_TICKS = 11;
    public static float TOTAL_DAMAGE = 1000.0f;
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected DamagingProjectileAPI proj;
    protected ShipAPI target;
    protected Vector2f offset;
    protected int ticks = 0;
    protected IntervalUtil interval;
    protected FaderUtil fader = new FaderUtil(1.0f, 0.5f, 0.5f);
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.BELOW_INDICATORS_LAYER);

    public DisintegratorEffect() {
    }

    protected float getTotalDamage() {
        return TOTAL_DAMAGE;
    }

    protected int getNumTicks() {
        return NUM_TICKS;
    }

    protected boolean canDamageHull() {
        return false;
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        if (shieldHit) {
            return;
        }
        if (projectile.isFading()) {
            return;
        }
        if (!(target instanceof ShipAPI)) {
            return;
        }
        Vector2f offset = Vector2f.sub((Vector2f)point, (Vector2f)target.getLocation(), (Vector2f)new Vector2f());
        offset = Misc.rotateAroundOrigin(offset, -target.getFacing());
        DisintegratorEffect effect = new DisintegratorEffect(projectile, (ShipAPI)target, offset);
        CombatEntityAPI e = engine.addLayeredRenderingPlugin(effect);
        e.getLocation().set((ReadableVector2f)projectile.getLocation());
    }

    public DisintegratorEffect(DamagingProjectileAPI proj, ShipAPI target, Vector2f offset) {
        this.proj = proj;
        this.target = target;
        this.offset = offset;
        this.interval = new IntervalUtil(0.8f, 1.0f);
        this.interval.forceIntervalElapsed();
    }

    @Override
    public float getRenderRadius() {
        return 500.0f;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        Vector2f loc = new Vector2f((ReadableVector2f)this.offset);
        loc = Misc.rotateAroundOrigin(loc, this.target.getFacing());
        Vector2f.add((Vector2f)this.target.getLocation(), (Vector2f)loc, (Vector2f)loc);
        this.entity.getLocation().set((ReadableVector2f)loc);
        ArrayList<ParticleData> remove = new ArrayList<ParticleData>();
        for (ParticleData p : this.particles) {
            p.advance(amount);
            if (!(p.elapsed >= p.maxDur)) continue;
            remove.add(p);
        }
        this.particles.removeAll(remove);
        float volume = 1.0f;
        if (this.ticks >= this.getNumTicks() || !this.target.isAlive() || !Global.getCombatEngine().isEntityInPlay(this.target)) {
            this.fader.fadeOut();
            this.fader.advance(amount);
            volume = this.fader.getBrightness();
        }
        Global.getSoundPlayer().playLoop(this.getSoundLoopId(), this.target, 1.0f, volume, loc, this.target.getVelocity());
        this.interval.advance(amount);
        if (this.interval.intervalElapsed() && this.ticks < this.getNumTicks()) {
            this.dealDamage();
            ++this.ticks;
        }
    }

    protected String getSoundLoopId() {
        return "disintegrator_loop";
    }

    protected int getNumParticlesPerTick() {
        return 3;
    }

    protected void addParticle() {
        ParticleData p = new ParticleData(30.0f, 3.0f + (float)Math.random() * 2.0f, 2.0f);
        this.particles.add(p);
        p.offset = Misc.getPointWithinRadius(p.offset, 20.0f);
    }

    protected void damageDealt(Vector2f loc, float hullDamage, float armorDamage) {
    }

    protected void dealDamage() {
        float showHullDamage;
        CombatEngineAPI engine = Global.getCombatEngine();
        int num = this.getNumParticlesPerTick();
        int i = 0;
        while (i < num) {
            this.addParticle();
            ++i;
        }
        Vector2f point = new Vector2f((ReadableVector2f)this.entity.getLocation());
        ArmorGridAPI grid = this.target.getArmorGrid();
        int[] cell = grid.getCellAtLocation(point);
        if (cell == null) {
            return;
        }
        int gridWidth = grid.getGrid().length;
        int gridHeight = grid.getGrid()[0].length;
        float damageTypeMult = DisintegratorEffect.getDamageTypeMult(this.proj.getSource(), this.target);
        float damagePerTick = this.getTotalDamage() / (float)this.getNumTicks();
        float damageDealt = 0.0f;
        float hullDamage = 0.0f;
        int i2 = -2;
        while (i2 <= 2) {
            int j = -2;
            while (j <= 2) {
                if (i2 != 2 && i2 != -2 || j != 2 && j != -2) {
                    int cx = cell[0] + i2;
                    int cy = cell[1] + j;
                    if (cx >= 0 && cx < gridWidth && cy >= 0 && cy < gridHeight) {
                        float armorInCell;
                        float damMult = 0.033333335f;
                        damMult = i2 == 0 && j == 0 ? 0.06666667f : (i2 <= 1 && i2 >= -1 && j <= 1 && j >= -1 ? 0.06666667f : 0.033333335f);
                        float damage = damagePerTick * damMult * damageTypeMult;
                        if (damage > (armorInCell = grid.getArmorValue(cx, cy)) && this.canDamageHull()) {
                            hullDamage += damage - armorInCell;
                        }
                        if (!((damage = Math.min(damage, armorInCell)) <= 0.0f)) {
                            this.target.getArmorGrid().setArmorValue(cx, cy, Math.max(0.0f, armorInCell - damage));
                            damageDealt += damage;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (damageDealt > 0.0f) {
            if (Misc.shouldShowDamageFloaty(this.proj.getSource(), this.target)) {
                engine.addFloatingDamageText(point, damageDealt, 0.0f, Misc.FLOATY_ARMOR_DAMAGE_COLOR, this.target, this.proj.getSource());
            }
            this.target.syncWithArmorGridState();
        }
        if (hullDamage > 1.0f && (showHullDamage = Math.min(hullDamage, this.target.getHitpoints())) >= 0.0f) {
            this.target.setHitpoints(this.target.getHitpoints() - hullDamage);
            if (this.target.getHitpoints() <= 0.0f && !this.target.isHulk()) {
                this.target.setSpawnDebris(false);
                engine.applyDamage(this.target, point, 100.0f, DamageType.ENERGY, 0.0f, true, false, this.proj.getSource(), false);
            }
            if (Misc.shouldShowDamageFloaty(this.proj.getSource(), this.target)) {
                Vector2f p2 = new Vector2f((ReadableVector2f)point);
                p2.y += 20.0f;
                engine.addFloatingDamageText(p2, hullDamage, 0.0f, Misc.FLOATY_HULL_DAMAGE_COLOR, this.target, this.proj.getSource());
            }
        }
        this.damageDealt(point, hullDamage, damageDealt);
    }

    @Override
    public boolean isExpired() {
        return this.particles.isEmpty() && (this.ticks >= this.getNumTicks() || !this.target.isAlive() || !Global.getCombatEngine().isEntityInPlay(this.target));
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        float b = viewport.getAlphaMult();
        GL14.glBlendEquation((int)32779);
        for (ParticleData p : this.particles) {
            float size = p.baseSize * p.scale;
            Vector2f loc = new Vector2f(x + p.offset.x, y + p.offset.y);
            float alphaMult = 1.0f;
            p.sprite.setAngle(p.angle);
            p.sprite.setSize(size, size);
            p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
            p.sprite.setColor(p.color);
            p.sprite.renderAtCenter(loc.x, loc.y);
        }
        GL14.glBlendEquation((int)32774);
    }

    public static float getDamageTypeMult(ShipAPI source, ShipAPI target) {
        if (source == null || target == null) {
            return 1.0f;
        }
        float damageTypeMult = target.getMutableStats().getArmorDamageTakenMult().getModifiedValue();
        switch (target.getHullSize()) {
            case CAPITAL_SHIP: {
                damageTypeMult *= source.getMutableStats().getDamageToCapital().getModifiedValue();
                break;
            }
            case CRUISER: {
                damageTypeMult *= source.getMutableStats().getDamageToCruisers().getModifiedValue();
                break;
            }
            case DESTROYER: {
                damageTypeMult *= source.getMutableStats().getDamageToDestroyers().getModifiedValue();
                break;
            }
            case FRIGATE: {
                damageTypeMult *= source.getMutableStats().getDamageToFrigates().getModifiedValue();
                break;
            }
            case FIGHTER: {
                damageTypeMult *= source.getMutableStats().getDamageToFighters().getModifiedValue();
            }
        }
        return damageTypeMult;
    }

    public Vector2f getOffset() {
        return this.offset;
    }

    public void setOffset(Vector2f offset) {
        this.offset = offset;
    }

    public static class ParticleData {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public float scaleIncreaseRate = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float maxDur;
        public FaderUtil fader;
        public float elapsed = 0.0f;
        public float baseSize;
        public Color color = new Color(100, 150, 255, 35);

        public ParticleData(float baseSize, float maxDur, float endSizeMult) {
            this.sprite = Global.getSettings().getSprite("misc", "nebula_particles");
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setAdditiveBlend();
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = maxDur;
            this.scaleIncreaseRate = endSizeMult / maxDur;
            if (endSizeMult < 1.0f) {
                this.scaleIncreaseRate = -1.0f * endSizeMult;
            }
            this.scale = 1.0f;
            this.baseSize = baseSize;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * 20.0f * (float)Math.random();
            float driftDir = (float)Math.random() * 360.0f;
            this.vel = Misc.getUnitVectorAtDegreeAngle(driftDir);
            this.vel.scale(0.25f * baseSize / maxDur * (1.0f + (float)Math.random() * 1.0f));
            this.fader = new FaderUtil(0.0f, 0.5f, 0.5f);
            this.fader.forceOut();
            this.fader.fadeIn();
        }

        public void advance(float amount) {
            this.scale += this.scaleIncreaseRate * amount;
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            this.angle += this.turnDir * amount;
            this.elapsed += amount;
            if (this.maxDur - this.elapsed <= this.fader.getDurationOut() + 0.1f) {
                this.fader.fadeOut();
            }
            this.fader.advance(amount);
        }
    }
}

