/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.util.List;

public class EscapeRevealPlugin
extends BaseEveryFrameCombatPlugin {
    private CombatEngineAPI engine;
    private BattleCreationContext context;
    private float elapsed = 0.0f;

    public EscapeRevealPlugin(BattleCreationContext context) {
        this.context = context;
    }

    @Override
    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (this.elapsed > 10.0f) {
            return;
        }
        if (!this.engine.isPaused()) {
            this.elapsed += amount;
        }
        float width = this.engine.getMapWidth();
        float height = this.engine.getMapHeight();
        float minX = -width / 2.0f;
        float minY = -height / 2.0f;
        this.engine.getFogOfWar(0).revealAroundPoint(this, minX + width / 2.0f, minY, this.context.getInitialEscapeRange() + 1000.0f);
        this.engine.getFogOfWar(1).revealAroundPoint(this, minX + width / 2.0f, minY, this.context.getInitialEscapeRange() + 1000.0f);
    }
}

