/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class GravityPullEffect
extends BaseEveryFrameCombatPlugin {
    protected float maxForce;
    protected float duration = 0.05f;
    protected float elapsed = 0.0f;
    protected CombatEntityAPI source;
    protected float range;

    public GravityPullEffect(CombatEntityAPI source, float range, float maxForce) {
        this.source = source;
        this.range = range;
        this.maxForce = maxForce;
        this.duration = 0.05f;
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.elapsed += amount;
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(this.source.getLocation(), this.range * 2.0f, this.range * 2.0f);
        while (iter.hasNext()) {
            CombatEntityAPI other;
            Object o = iter.next();
            if (o == this.source || !(o instanceof CombatEntityAPI) || !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getMass() <= 0.0f) continue;
            this.applyForce(other, amount);
        }
        if (this.elapsed > this.duration) {
            Global.getCombatEngine().removePlugin(this);
        }
    }

    protected void applyForce(CombatEntityAPI other, float amount) {
        float dist = Misc.getDistance(this.source.getLocation(), other.getLocation());
        if ((dist -= other.getCollisionRadius()) > this.range) {
            return;
        }
        float fTime = 0.0f + 1.0f * Math.min(1.0f, this.elapsed / this.duration);
        float fDist = 0.25f + 0.75f * Math.min(1.0f, 1.0f - dist / this.range);
        float fConstant = 20.0f;
        float acceleration = this.maxForce / other.getMass() * fTime * fDist * fConstant;
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(other.getLocation(), this.source.getLocation()));
        dir.scale(acceleration);
        other.getVelocity().x += dir.x * amount;
        other.getVelocity().y += dir.y * amount;
    }
}

