/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionGridAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.impl.combat.MoteControlScript;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MoteAIScript
implements MissileAIPlugin {
    public static float MAX_FLOCK_RANGE = 500.0f;
    public static float MAX_HARD_AVOID_RANGE = 200.0f;
    public static float AVOID_RANGE = 50.0f;
    public static float COHESION_RANGE = 100.0f;
    public static float ATTRACTOR_LOCK_STOP_FLOCKING_ADD = 300.0f;
    protected MissileAPI missile;
    protected IntervalUtil tracker = new IntervalUtil(0.05f, 0.1f);
    protected IntervalUtil updateListTracker = new IntervalUtil(0.05f, 0.1f);
    protected List<MissileAPI> missileList = new ArrayList<MissileAPI>();
    protected List<CombatEntityAPI> hardAvoidList = new ArrayList<CombatEntityAPI>();
    protected float r;
    protected CombatEntityAPI target;
    protected MoteControlScript.SharedMoteAIData data;
    protected IntervalUtil flutterCheck = new IntervalUtil(2.0f, 4.0f);
    protected FaderUtil currFlutter = null;
    protected float flutterRemaining = 0.0f;
    protected float elapsed = 0.0f;

    public MoteAIScript(MissileAPI missile) {
        this.missile = missile;
        this.r = (float)Math.random();
        this.elapsed = -((float)Math.random()) * 0.5f;
        this.data = MoteControlScript.getSharedData(missile.getSource());
        this.updateHardAvoidList();
    }

    public void updateHardAvoidList() {
        Object o;
        this.hardAvoidList.clear();
        CollisionGridAPI grid = Global.getCombatEngine().getAiGridShips();
        Iterator<Object> iter = grid.getCheckIterator(this.missile.getLocation(), MAX_HARD_AVOID_RANGE * 2.0f, MAX_HARD_AVOID_RANGE * 2.0f);
        while (iter.hasNext()) {
            ShipAPI ship;
            o = iter.next();
            if (!(o instanceof ShipAPI) || (ship = (ShipAPI)o).isFighter()) continue;
            this.hardAvoidList.add(ship);
        }
        grid = Global.getCombatEngine().getAiGridAsteroids();
        iter = grid.getCheckIterator(this.missile.getLocation(), MAX_HARD_AVOID_RANGE * 2.0f, MAX_HARD_AVOID_RANGE * 2.0f);
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof CombatEntityAPI)) continue;
            CombatEntityAPI asteroid = (CombatEntityAPI)o;
            this.hardAvoidList.add(asteroid);
        }
    }

    public void doFlocking() {
        float dist;
        if (this.missile.getSource() == null) {
            return;
        }
        ShipAPI source = this.missile.getSource();
        CombatEngineAPI engine = Global.getCombatEngine();
        float avoidRange = AVOID_RANGE;
        float cohesionRange = COHESION_RANGE;
        float sourceRejoin = source.getCollisionRadius() + 200.0f;
        float sourceRepel = source.getCollisionRadius() + 50.0f;
        float sourceCohesion = source.getCollisionRadius() + 600.0f;
        float sin = (float)Math.sin(this.data.elapsed * 1.0f);
        float mult = 1.0f + sin * 0.25f;
        avoidRange *= mult;
        Vector2f total = new Vector2f();
        Vector2f attractor = this.getAttractorLoc();
        if (attractor != null) {
            float dist2 = Misc.getDistance(this.missile.getLocation(), attractor);
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(this.missile.getLocation(), attractor));
            float f = dist2 / 200.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            dir.scale(f * 3.0f);
            Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            avoidRange *= 3.0f;
        }
        boolean hardAvoiding = false;
        for (CombatEntityAPI other : this.hardAvoidList) {
            float hardAvoidRange;
            dist = Misc.getDistance(this.missile.getLocation(), other.getLocation());
            if (!(dist < (hardAvoidRange = other.getCollisionRadius() + avoidRange + 50.0f))) continue;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(other.getLocation(), this.missile.getLocation()));
            float f = 1.0f - dist / hardAvoidRange;
            dir.scale(f * 5.0f);
            Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            boolean bl = hardAvoiding = f > 0.5f;
        }
        for (MissileAPI otherMissile : this.data.motes) {
            float f;
            if (otherMissile == this.missile) continue;
            dist = Misc.getDistance(this.missile.getLocation(), otherMissile.getLocation());
            float w = otherMissile.getMaxHitpoints();
            w = 1.0f;
            float currCohesionRange = cohesionRange;
            if (dist < avoidRange && otherMissile != this.missile && !hardAvoiding) {
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(otherMissile.getLocation(), this.missile.getLocation()));
                f = 1.0f - dist / avoidRange;
                dir.scale(f * w);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (!(dist < currCohesionRange)) continue;
            Vector2f dir = new Vector2f((ReadableVector2f)otherMissile.getVelocity());
            Misc.normalise(dir);
            f = 1.0f - dist / currCohesionRange;
            dir.scale(f * w);
            Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
        }
        if (this.missile.getSource() != null) {
            float f;
            Vector2f dir;
            float dist3 = Misc.getDistance(this.missile.getLocation(), source.getLocation());
            if (dist3 > sourceRejoin) {
                dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(this.missile.getLocation(), source.getLocation()));
                f = dist3 / (sourceRejoin + 400.0f) - 1.0f;
                dir.scale(f * 0.5f);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (dist3 < sourceRepel) {
                dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(source.getLocation(), this.missile.getLocation()));
                f = 1.0f - dist3 / sourceRepel;
                dir.scale(f * 5.0f);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (dist3 < sourceCohesion && source.getVelocity().length() > 20.0f) {
                dir = new Vector2f((ReadableVector2f)source.getVelocity());
                Misc.normalise(dir);
                f = 1.0f - dist3 / sourceCohesion;
                dir.scale(f * 1.0f);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (total.length() <= 0.05f) {
                float offset = this.r > 0.5f ? 90.0f : -90.0f;
                Vector2f dir2 = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(this.missile.getLocation(), source.getLocation()) + offset);
                float f2 = 1.0f;
                dir2.scale(f2 * 1.0f);
                Vector2f.add((Vector2f)total, (Vector2f)dir2, (Vector2f)total);
            }
        }
        if (total.length() > 0.0f) {
            float dir = Misc.getAngleInDegrees(total);
            engine.headInDirectionWithoutTurning(this.missile, dir, 10000.0f);
            if (this.r > 0.5f) {
                this.missile.giveCommand(ShipCommand.TURN_LEFT);
            } else {
                this.missile.giveCommand(ShipCommand.TURN_RIGHT);
            }
            this.missile.getEngineController().forceShowAccelerating();
        }
    }

    @Override
    public void advance(float amount) {
        if (this.missile.isFizzling()) {
            return;
        }
        if (this.missile.getSource() == null) {
            return;
        }
        this.elapsed += amount;
        this.updateListTracker.advance(amount);
        if (this.updateListTracker.intervalElapsed()) {
            this.updateHardAvoidList();
        }
        if (this.flutterRemaining <= 0.0f) {
            this.flutterCheck.advance(amount);
            if (this.flutterCheck.intervalElapsed() && ((float)Math.random() > 0.9f || this.data.attractorLock != null && (float)Math.random() > 0.5f)) {
                this.flutterRemaining = 2.0f + (float)Math.random() * 2.0f;
            }
        }
        if (this.elapsed >= 0.5f) {
            float dist;
            boolean wantToFlock;
            boolean bl = wantToFlock = !this.isTargetValid();
            if (this.data.attractorLock != null && (dist = Misc.getDistance(this.missile.getLocation(), this.data.attractorLock.getLocation())) > this.data.attractorLock.getCollisionRadius() + ATTRACTOR_LOCK_STOP_FLOCKING_ADD) {
                wantToFlock = true;
            }
            if (wantToFlock) {
                this.doFlocking();
            } else {
                CombatEngineAPI engine = Global.getCombatEngine();
                Vector2f targetLoc = engine.getAimPointWithLeadForAutofire(this.missile, 1.5f, this.target, 50.0f);
                engine.headInDirectionWithoutTurning(this.missile, Misc.getAngleInDegrees(this.missile.getLocation(), targetLoc), 10000.0f);
                if (this.r > 0.5f) {
                    this.missile.giveCommand(ShipCommand.TURN_LEFT);
                } else {
                    this.missile.giveCommand(ShipCommand.TURN_RIGHT);
                }
                this.missile.getEngineController().forceShowAccelerating();
            }
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed() && this.elapsed >= 0.5f) {
            this.acquireNewTargetIfNeeded();
        }
    }

    protected boolean isTargetValid() {
        if (this.target == null || this.target instanceof ShipAPI && ((ShipAPI)this.target).isPhased()) {
            return false;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.target != null && this.target instanceof ShipAPI && ((ShipAPI)this.target).isHulk()) {
            return false;
        }
        List<CombatEntityAPI> list = null;
        list = this.target instanceof ShipAPI ? engine.getShips() : engine.getMissiles();
        return this.target != null && list.contains(this.target) && this.target.getOwner() != this.missile.getOwner();
    }

    protected void acquireNewTargetIfNeeded() {
        float distFromSource;
        float distFromAttractor;
        float distToTarget;
        if (this.data.attractorLock != null) {
            this.target = this.data.attractorLock;
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        int owner = this.missile.getOwner();
        int maxMotesPerMissile = 2;
        float maxDistFromSourceShip = MoteControlScript.MAX_DIST_FROM_SOURCE_TO_ENGAGE_AS_PD;
        float maxDistFromAttractor = MoteControlScript.MAX_DIST_FROM_ATTRACTOR_TO_ENGAGE_AS_PD;
        float minDist = Float.MAX_VALUE;
        CombatEntityAPI closest = null;
        for (MissileAPI missileAPI : engine.getMissiles()) {
            if (missileAPI.getOwner() == owner || missileAPI.getOwner() == 100 || (distToTarget = Misc.getDistance(this.missile.getLocation(), missileAPI.getLocation())) > minDist || distToTarget > 3000.0f && !engine.isAwareOf(owner, missileAPI)) continue;
            distFromAttractor = Float.MAX_VALUE;
            if (this.data.attractorTarget != null) {
                distFromAttractor = Misc.getDistance(missileAPI.getLocation(), this.data.attractorTarget);
            }
            if ((distFromSource = Misc.getDistance(missileAPI.getLocation(), this.missile.getSource().getLocation())) > maxDistFromSourceShip && distFromAttractor > maxDistFromAttractor || this.getNumMotesTargeting(missileAPI) >= maxMotesPerMissile || !(distToTarget < minDist)) continue;
            closest = missileAPI;
            minDist = distToTarget;
        }
        for (ShipAPI shipAPI : engine.getShips()) {
            if (shipAPI.getOwner() == owner || shipAPI.getOwner() == 100 || !shipAPI.isFighter() || (distToTarget = Misc.getDistance(this.missile.getLocation(), shipAPI.getLocation())) > minDist || distToTarget > 3000.0f && !engine.isAwareOf(owner, shipAPI)) continue;
            distFromAttractor = Float.MAX_VALUE;
            if (this.data.attractorTarget != null) {
                distFromAttractor = Misc.getDistance(shipAPI.getLocation(), this.data.attractorTarget);
            }
            if ((distFromSource = Misc.getDistance(shipAPI.getLocation(), this.missile.getSource().getLocation())) > maxDistFromSourceShip && distFromAttractor > maxDistFromAttractor || this.getNumMotesTargeting(shipAPI) >= maxMotesPerMissile || !(distToTarget < minDist)) continue;
            closest = shipAPI;
            minDist = distToTarget;
        }
        this.target = closest;
    }

    protected int getNumMotesTargeting(CombatEntityAPI other) {
        int count = 0;
        for (MissileAPI mote : this.data.motes) {
            MoteAIScript ai;
            if (mote == this.missile || !(mote.getUnwrappedMissileAI() instanceof MoteAIScript) || (ai = (MoteAIScript)mote.getUnwrappedMissileAI()).getTarget() != other) continue;
            ++count;
        }
        return count;
    }

    public Vector2f getAttractorLoc() {
        Vector2f attractor = null;
        if (this.data.attractorTarget != null) {
            attractor = this.data.attractorTarget;
            if (this.data.attractorLock != null) {
                attractor = this.data.attractorLock.getLocation();
            }
        }
        return attractor;
    }

    public CombatEntityAPI getTarget() {
        return this.target;
    }

    public void setTarget(CombatEntityAPI target) {
        this.target = target;
    }

    public void render() {
    }
}

