/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPluginWithReset;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NSLanceEffectSavedCopy
implements BeamEffectPluginWithReset {
    public static float MIN_SPAWN_DIST = 200.0f;
    public static float DIST_PER_SPAWN = 150.0f;
    public static float NUM_SPAWNS = 5.0f;
    public static float SPAWN_INTERVAL = 0.1f;
    protected Vector2f arcFrom = null;
    protected Vector2f prevMineLoc = null;
    protected boolean done = false;
    protected float spawned = 0.0f;
    protected int numToSpawn = 0;
    protected float untilNextSpawn = 0.0f;
    protected float spawnDir = 0.0f;
    protected boolean canSpawn = false;

    @Override
    public void reset() {
        this.done = false;
        this.spawned = 0.0f;
        this.untilNextSpawn = 0.0f;
        this.arcFrom = null;
        this.prevMineLoc = null;
        this.numToSpawn = 0;
        this.spawnDir = 0.0f;
    }

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        float perSpawn;
        float length;
        float range;
        if (this.done) {
            return;
        }
        if (this.numToSpawn <= 0 && beam.getDamageTarget() != null) {
            range = beam.getWeapon().getRange();
            length = beam.getLengthPrevFrame();
            perSpawn = DIST_PER_SPAWN;
            this.numToSpawn = (int)((range - length) / perSpawn) + 1;
            this.numToSpawn = 1;
            this.untilNextSpawn = 0.0f;
        }
        this.numToSpawn = 5;
        if (beam.getBrightness() >= 1.0f) {
            this.canSpawn = true;
        }
        this.untilNextSpawn -= amount;
        if (this.untilNextSpawn > 0.0f) {
            return;
        }
        range = beam.getWeapon().getRange();
        length = beam.getLengthPrevFrame();
        perSpawn = (range - MIN_SPAWN_DIST) / Math.max(1.0f, NUM_SPAWNS - 1.0f);
        float rangeToSpawnAt = MIN_SPAWN_DIST + this.spawned * perSpawn;
        if (this.numToSpawn == 1) {
            rangeToSpawnAt = range;
        }
        ShipAPI ship = beam.getSource();
        boolean spawnedMine = false;
        if (length > rangeToSpawnAt - 10.0f) {
            float angle = Misc.getAngleInDegrees(beam.getFrom(), beam.getRayEndPrevFrame());
            Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
            loc.scale(rangeToSpawnAt);
            Vector2f.add((Vector2f)loc, (Vector2f)beam.getFrom(), (Vector2f)loc);
            this.spawnMine(ship, loc);
            spawnedMine = true;
        } else if (beam.getDamageTarget() != null) {
            Vector2f arcTo = this.getNextArcLoc(engine, beam, perSpawn);
            float thickness = beam.getWidth();
            engine.spawnEmpArcVisual(this.arcFrom, null, arcTo, null, thickness, beam.getFringeColor(), Color.white);
            this.spawnMine(ship, arcTo);
            spawnedMine = true;
            this.arcFrom = arcTo;
        }
        this.untilNextSpawn = SPAWN_INTERVAL;
        if (spawnedMine) {
            this.spawned += 1.0f;
            if (this.spawned >= (float)this.numToSpawn) {
                this.done = true;
            }
        }
    }

    public Vector2f getNextArcLoc(CombatEngineAPI engine, BeamAPI beam, float perSpawn) {
        CombatEntityAPI target = beam.getDamageTarget();
        if (this.arcFrom == null) {
            this.arcFrom = new Vector2f((ReadableVector2f)beam.getRayEndPrevFrame());
            float beamAngle = Misc.getAngleInDegrees(beam.getFrom(), beam.getRayEndPrevFrame());
            float beamSourceToTarget = Misc.getAngleInDegrees(beam.getFrom(), target.getLocation());
            this.spawnDir = Misc.getClosestTurnDirection(beamAngle, beamSourceToTarget);
            boolean computeNextLoc = false;
            if (!computeNextLoc) {
                return this.arcFrom;
            }
        }
        Vector2f targetLoc = target.getLocation();
        float targetRadius = target.getCollisionRadius();
        boolean hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getRayEndPrevFrame());
        float prevAngle = Misc.getAngleInDegrees(targetLoc, this.arcFrom);
        float anglePerSegment = 360.0f * perSpawn / (6.28f * targetRadius);
        if (anglePerSegment > 90.0f) {
            anglePerSegment = 90.0f;
        }
        float angle = prevAngle + anglePerSegment * this.spawnDir;
        Vector2f arcTo = Misc.getUnitVectorAtDegreeAngle(angle);
        arcTo.scale(targetRadius);
        Vector2f.add((Vector2f)targetLoc, (Vector2f)arcTo, (Vector2f)arcTo);
        float actualRadius = Global.getSettings().getTargetingRadius(arcTo, target, hitShield);
        actualRadius = !hitShield ? (actualRadius += 30.0f + 50.0f * (float)Math.random()) : (actualRadius += 30.0f + 50.0f * (float)Math.random());
        arcTo = Misc.getUnitVectorAtDegreeAngle(angle);
        arcTo.scale(actualRadius);
        Vector2f.add((Vector2f)targetLoc, (Vector2f)arcTo, (Vector2f)arcTo);
        return arcTo;
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc) {
        CombatEngineAPI engine = Global.getCombatEngine();
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, "nslance_minelayer", mineLoc, (float)Math.random() * 360.0f, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        float fadeInTime = 0.05f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        float liveTime = 0.0f;
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        mine.addDamagedAlready(source);
        this.prevMineLoc = mineLoc;
    }
}

