/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.OrionDeviceStats;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class NovaBurstStats
extends OrionDeviceStats {
    public NovaBurstStats() {
        this.p = new OrionDeviceStats.OrionDeviceParams();
        this.p.bombWeaponId = "nb_bomblauncher";
        this.p.shapedExplosionColor = new Color(100, 165, 255, 155);
        this.p.shapedExplosionColor = new Color(100, 165, 255, 85);
        this.p.shapedExplosionScatter = 0.0f;
        this.p.shapedExplosionNumParticles = 200;
        this.p.shapedExplosionOffset = 20.0f;
        this.p.shapedExplosionEndSizeMin = 1.5f;
        this.p.shapedExplosionEndSizeMax = 2.0f;
        this.p.shapedExplosionMinParticleSize = 50.0f;
        this.p.shapedExplosionMaxParticleSize = 80.0f;
        this.p.shapedExplosionMinParticleVel = 100.0f;
        this.p.shapedExplosionMaxParticleVel = 500.0f;
        this.p.shapedExplosionArc = 270.0f;
        this.p.shapedExplosionArc = 60.0f;
        this.p.jitterColor = new Color(100, 165, 255, 35);
        this.p.maxJitterDur = 1.0f;
        this.p.impactAccel = 10000.0f;
        this.p.impactRateMult = 1.0f;
        this.p.bombFadeInTime = 1.0f;
        this.p.bombLiveTime = 0.0f;
        this.p.bombSpeed = 0.0f;
    }

    @Override
    protected void advanceImpl(float amount, ShipAPI ship, ShipSystemStatsScript.State state, float effectLevel) {
        super.advanceImpl(amount, ship, state, effectLevel);
        if (effectLevel > 0.0f) {
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (!w.isDecorative() || !w.getSpec().hasTag("nova")) continue;
                w.setForceFireOneFrame(true);
                w.forceShowBeamGlow();
            }
        }
    }

    @Override
    protected void notifySpawnedExplosionParticles(Vector2f bombLoc) {
        Color c = new Color(100, 165, 255, 255);
        float expSize = 800.0f;
        float durFringe = 1.0f;
        float durFringe2 = 0.75f;
        float dur = 0.75f;
        Global.getCombatEngine().addHitParticle(bombLoc, new Vector2f(), expSize, 1.0f, durFringe, c);
        Global.getCombatEngine().addHitParticle(bombLoc, new Vector2f(), expSize * 0.67f, 1.0f, durFringe2, c);
        Global.getCombatEngine().addHitParticle(bombLoc, new Vector2f(), expSize * 0.33f, 1.0f, dur, Color.white);
    }
}

