/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.RealityDisruptorChargeGlow;
import org.lwjgl.util.vector.Vector2f;

public class RealityDisruptorEffect
implements OnFireEffectPlugin,
OnHitEffectPlugin,
EveryFrameWeaponEffectPlugin {
    protected CombatEntityAPI chargeGlowEntity;
    protected RealityDisruptorChargeGlow chargeGlowPlugin;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        boolean charging;
        boolean bl = charging = weapon.getChargeLevel() > 0.0f && weapon.getCooldownRemaining() <= 0.0f;
        if (charging && this.chargeGlowEntity == null) {
            this.chargeGlowPlugin = new RealityDisruptorChargeGlow(weapon);
            this.chargeGlowEntity = Global.getCombatEngine().addLayeredRenderingPlugin(this.chargeGlowPlugin);
        } else if (!charging && this.chargeGlowEntity != null) {
            this.chargeGlowEntity = null;
            this.chargeGlowPlugin = null;
        }
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        if (this.chargeGlowPlugin != null) {
            this.chargeGlowPlugin.attachToProjectile(projectile);
            this.chargeGlowPlugin = null;
            this.chargeGlowEntity = null;
            MissileAPI missile = (MissileAPI)projectile;
            missile.setMine(true);
            missile.setNoMineFFConcerns(true);
            missile.setMineExplosionRange((float)RealityDisruptorChargeGlow.MAX_ARC_RANGE + 50.0f);
            missile.setMinePrimed(true);
            missile.setUntilMineExplosion(0.0f);
        }
    }
}

