/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.loading.MissileSpecAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RiftCascadeEffect
implements BeamEffectPlugin {
    public static Color STANDARD_RIFT_COLOR = new Color(100, 60, 255, 255);
    public static Color EXPLOSION_UNDERCOLOR = new Color(100, 0, 25, 100);
    public static Color NEGATIVE_SOURCE_COLOR = new Color(200, 255, 200, 25);
    public static String RIFTCASCADE_MINELAYER = "riftcascade_minelayer";
    public static int MAX_RIFTS = 5;
    public static float UNUSED_RANGE_PER_SPAWN = 200.0f;
    public static float SPAWN_SPACING = 175.0f;
    public static float SPAWN_INTERVAL = 0.1f;
    protected Vector2f arcFrom = null;
    protected Vector2f prevMineLoc = null;
    protected boolean doneSpawningMines = false;
    protected float spawned = 0.0f;
    protected int numToSpawn = 0;
    protected float untilNextSpawn = 0.0f;
    protected float spawnDir = 0.0f;
    protected IntervalUtil tracker = new IntervalUtil(0.1f, 0.2f);

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            this.spawnNegativeParticles(engine, beam);
        }
        if (beam.getBrightness() < 1.0f) {
            return;
        }
        if (this.doneSpawningMines) {
            return;
        }
        if (this.numToSpawn <= 0 && beam.getDamageTarget() != null) {
            float range = beam.getWeapon().getRange();
            float length = beam.getLengthPrevFrame();
            this.numToSpawn = (int)((range - length) / UNUSED_RANGE_PER_SPAWN) + 1;
            if (this.numToSpawn > MAX_RIFTS) {
                this.numToSpawn = MAX_RIFTS;
            }
            this.untilNextSpawn = 0.0f;
        }
        this.untilNextSpawn -= amount;
        if (this.untilNextSpawn > 0.0f) {
            return;
        }
        float perSpawn = SPAWN_SPACING;
        ShipAPI ship = beam.getSource();
        boolean spawnedMine = false;
        if (beam.getLength() > beam.getWeapon().getRange() - 10.0f) {
            float angle = Misc.getAngleInDegrees(beam.getFrom(), beam.getRayEndPrevFrame());
            Vector2f loc = Misc.getUnitVectorAtDegreeAngle(angle);
            loc.scale(beam.getLength());
            Vector2f.add((Vector2f)loc, (Vector2f)beam.getFrom(), (Vector2f)loc);
            this.spawnMine(ship, loc);
            spawnedMine = true;
        } else if (beam.getDamageTarget() != null) {
            Vector2f arcTo = this.getNextArcLoc(engine, beam, perSpawn);
            float thickness = beam.getWidth();
            float dist = Misc.getDistance(this.arcFrom, arcTo);
            if (dist < SPAWN_SPACING * 2.0f) {
                EmpArcEntityAPI arc = engine.spawnEmpArcVisual(this.arcFrom, null, arcTo, null, thickness, beam.getFringeColor(), Color.white);
                arc.setCoreWidthOverride(Math.max(20.0f, thickness * 0.67f));
            }
            this.spawnMine(ship, arcTo);
            spawnedMine = true;
            this.arcFrom = arcTo;
        }
        this.untilNextSpawn = SPAWN_INTERVAL;
        if (spawnedMine) {
            this.spawned += 1.0f;
            if (this.spawned >= (float)this.numToSpawn) {
                this.doneSpawningMines = true;
            }
        }
    }

    public void spawnNegativeParticles(CombatEngineAPI engine, BeamAPI beam) {
        float length = beam.getLengthPrevFrame();
        if (length <= 10.0f) {
            return;
        }
        Vector2f from = beam.getFrom();
        Vector2f to = beam.getRayEndPrevFrame();
        ShipAPI ship = beam.getSource();
        float angle = Misc.getAngleInDegrees(from, to);
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
        Color color = NEGATIVE_SOURCE_COLOR;
        float sizeMult = 1.0f;
        sizeMult = 0.67f;
        int i = 0;
        while (i < 3) {
            float rampUp = 0.25f + 0.25f * (float)Math.random();
            float dur = 1.0f + 1.0f * (float)Math.random();
            float size = 200.0f + 50.0f * (float)Math.random();
            Vector2f loc = Misc.getPointAtRadius(beam.getWeapon().getLocation(), (size *= sizeMult) * 0.33f);
            engine.addNegativeParticle(loc, ship.getVelocity(), size, rampUp / dur, dur, color);
            ++i;
        }
    }

    public Vector2f getNextArcLoc(CombatEngineAPI engine, BeamAPI beam, float perSpawn) {
        ShipAPI ship;
        BoundsAPI bounds;
        boolean hitShield;
        ShipAPI ship2;
        CombatEntityAPI target = beam.getDamageTarget();
        float radiusOverride = -1.0f;
        if (target instanceof ShipAPI && (ship2 = (ShipAPI)target).getParentStation() != null && ship2.getStationSlot() != null) {
            radiusOverride = Misc.getDistance(beam.getRayEndPrevFrame(), ship2.getParentStation().getLocation()) + 0.0f;
            target = ship2.getParentStation();
        }
        if (this.arcFrom == null) {
            float dist;
            this.arcFrom = new Vector2f((ReadableVector2f)beam.getRayEndPrevFrame());
            float beamAngle = Misc.getAngleInDegrees(beam.getFrom(), beam.getRayEndPrevFrame());
            float beamSourceToTarget = Misc.getAngleInDegrees(beam.getFrom(), target.getLocation());
            this.spawnDir = Misc.getClosestTurnDirection(beamAngle, beamSourceToTarget);
            if (this.spawnDir == 0.0f) {
                this.spawnDir = 1.0f;
            }
            boolean computeNextLoc = false;
            if (this.prevMineLoc != null && (dist = Misc.getDistance(this.arcFrom, this.prevMineLoc)) < perSpawn) {
                perSpawn -= dist;
                computeNextLoc = true;
            }
            if (!computeNextLoc) {
                return this.arcFrom;
            }
        }
        Vector2f targetLoc = target.getLocation();
        float targetRadius = target.getCollisionRadius();
        if (radiusOverride >= 0.0f) {
            targetRadius = radiusOverride;
        }
        boolean bl = hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getRayEndPrevFrame());
        if (hitShield) {
            perSpawn *= 0.67f;
        }
        float prevAngle = Misc.getAngleInDegrees(targetLoc, this.arcFrom);
        float anglePerSegment = 360.0f * perSpawn / (6.28f * targetRadius);
        if (anglePerSegment > 90.0f) {
            anglePerSegment = 90.0f;
        }
        float angle = prevAngle + anglePerSegment * this.spawnDir;
        Vector2f arcTo = Misc.getUnitVectorAtDegreeAngle(angle);
        arcTo.scale(targetRadius);
        Vector2f.add((Vector2f)targetLoc, (Vector2f)arcTo, (Vector2f)arcTo);
        float actualRadius = Global.getSettings().getTargetingRadius(arcTo, target, hitShield);
        if (radiusOverride >= 0.0f) {
            actualRadius = radiusOverride;
        }
        actualRadius = !hitShield ? (actualRadius += 30.0f + 50.0f * (float)Math.random()) : (actualRadius += 30.0f + 50.0f * (float)Math.random());
        arcTo = Misc.getUnitVectorAtDegreeAngle(angle);
        arcTo.scale(actualRadius);
        Vector2f.add((Vector2f)targetLoc, (Vector2f)arcTo, (Vector2f)arcTo);
        if (target instanceof ShipAPI && !hitShield && (bounds = (ship = (ShipAPI)target).getExactBounds()) != null) {
            Object o;
            Vector2f best = null;
            float bestDist = Float.MAX_VALUE;
            for (BoundsAPI.SegmentAPI segment : bounds.getSegments()) {
                float test = Misc.getDistance(segment.getP1(), arcTo);
                if (!(test < bestDist)) continue;
                bestDist = test;
                best = segment.getP1();
            }
            if (best != null && (o = Global.getSettings().getWeaponSpec(RIFTCASCADE_MINELAYER).getProjectileSpec()) instanceof MissileSpecAPI) {
                MissileSpecAPI spec = (MissileSpecAPI)o;
                float explosionRadius = (float)spec.getBehaviorJSON().optJSONObject("explosionSpec").optDouble("coreRadius", 100.0);
                float sizeMult = this.getSizeMult();
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(best, arcTo));
                dir.scale((explosionRadius *= sizeMult) * 0.9f);
                Vector2f.add((Vector2f)best, (Vector2f)dir, (Vector2f)dir);
                arcTo = dir;
            }
        }
        return arcTo;
    }

    public float getSizeMult() {
        float sizeMult = 1.0f - this.spawned / (float)Math.max(1, this.numToSpawn - 1);
        sizeMult = 0.75f + (1.0f - sizeMult) * 0.5f;
        return sizeMult;
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc) {
        CombatEngineAPI engine = Global.getCombatEngine();
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, RIFTCASCADE_MINELAYER, mineLoc, (float)Math.random() * 360.0f, null);
        float sizeMult = this.getSizeMult();
        mine.setCustomData(RiftCascadeMineExplosion.SIZE_MULT_KEY, Float.valueOf(sizeMult));
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.ENERGY, false, mine.getDamage());
        }
        mine.getDamage().getModifier().modifyMult("mine_sizeMult", sizeMult);
        float fadeInTime = 0.05f;
        mine.getVelocity().scale(0.0f);
        mine.fadeOutThenIn(fadeInTime);
        float liveTime = 0.0f;
        mine.setFlightTime(mine.getMaxFlightTime() - liveTime);
        mine.addDamagedAlready(source);
        mine.setNoMineFFConcerns(true);
        this.prevMineLoc = mineLoc;
    }
}

