/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ProximityExplosionEffect;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.loading.MissileSpecAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RiftCascadeMineExplosion
implements ProximityExplosionEffect {
    public static String SIZE_MULT_KEY = "core_sizeMultKey";

    @Override
    public void onExplosion(DamagingProjectileAPI explosion, DamagingProjectileAPI originalProjectile) {
        Float sizeMult = null;
        if (originalProjectile.getCustomData() != null) {
            sizeMult = (Float)originalProjectile.getCustomData().get(SIZE_MULT_KEY);
        }
        if (sizeMult == null) {
            sizeMult = Float.valueOf(1.0f);
        }
        NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams("riftcascade_minelayer", 25.0f * sizeMult.floatValue());
        p.fadeOut = 1.0f;
        RiftCascadeMineExplosion.spawnStandardRift(explosion, p);
    }

    public static void spawnStandardRift(DamagingProjectileAPI explosion, NegativeExplosionVisual.NEParams params) {
        CombatEngineAPI engine = Global.getCombatEngine();
        explosion.addDamagedAlready(explosion.getSource());
        CombatEntityAPI prev = null;
        int i = 0;
        while (i < params.numRiftsToSpawn) {
            NegativeExplosionVisual.NEParams p = params.clone();
            p.radius *= 0.75f + 0.5f * (float)Math.random();
            p.withHitGlow = prev == null;
            Vector2f loc = new Vector2f((ReadableVector2f)explosion.getLocation());
            loc = Misc.getPointAtRadius(loc, p.radius * 0.4f);
            CombatEntityAPI e = engine.addLayeredRenderingPlugin(new NegativeExplosionVisual(p));
            e.getLocation().set((ReadableVector2f)loc);
            if (prev != null) {
                float dist = Misc.getDistance(prev.getLocation(), loc);
                Vector2f vel = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(loc, prev.getLocation()));
                vel.scale(dist / (p.fadeIn + p.fadeOut) * 0.7f);
                e.getVelocity().set((ReadableVector2f)vel);
            }
            prev = e;
            ++i;
        }
    }

    public static NegativeExplosionVisual.NEParams createStandardRiftParams(String minelayerId, float baseRadius) {
        Color color = new Color(100, 100, 255, 255);
        Object o = Global.getSettings().getWeaponSpec(minelayerId).getProjectileSpec();
        if (o instanceof MissileSpecAPI) {
            MissileSpecAPI spec = (MissileSpecAPI)o;
            color = spec.getGlowColor();
        }
        NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, baseRadius);
        return p;
    }

    public static NegativeExplosionVisual.NEParams createStandardRiftParams(Color borderColor, float radius) {
        NegativeExplosionVisual.NEParams p = new NegativeExplosionVisual.NEParams();
        p.hitGlowSizeMult = 0.75f;
        p.spawnHitGlowAt = 0.0f;
        p.noiseMag = 1.0f;
        p.fadeIn = 0.1f;
        p.underglow = RiftCascadeEffect.EXPLOSION_UNDERCOLOR;
        p.withHitGlow = true;
        p.radius = radius;
        p.color = borderColor;
        return p;
    }
}

