/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class ShockwaveVisual
extends BaseCombatLayeredRenderingPlugin {
    protected ShockwaveParams p;

    public static void spawnShockwave(ShockwaveParams params) {
        CombatEngineAPI engine = Global.getCombatEngine();
        float baseSize = params.radius * 0.08f;
        float maxParticleSize = baseSize * 2.0f;
        float fullArea = (float)(Math.PI * (double)params.radius * (double)params.radius);
        float particleArea = (float)(Math.PI * (double)baseSize * (double)baseSize);
        int count = Math.round(fullArea / particleArea * 1.0f);
        if ((count *= 2) > 300) {
            count = 300;
        }
        float durMult = 2.0f;
        float maxSpeed = params.radius * 2.0f;
        Color negativeColor = new Color(0, 0, 0, 255);
        int i = 0;
        while (i < count) {
            float size = baseSize * (1.0f + (float)Math.random());
            Color randomColor = new Color(Misc.random.nextInt(256), Misc.random.nextInt(256), Misc.random.nextInt(256), params.color.getAlpha());
            Color adjustedColor = Misc.interpolateColor(params.color, randomColor, 0.2f);
            adjustedColor = params.color;
            float r = (float)Math.random();
            float dist = params.radius * 0.2f * (0.1f + r * 0.9f);
            float dir = (float)Math.random() * 360.0f;
            Vector2f offset = Misc.getUnitVectorAtDegreeAngle(dir);
            offset.scale(dist);
            Vector2f loc = Vector2f.add((Vector2f)params.loc, (Vector2f)offset, (Vector2f)new Vector2f());
            float speed = maxSpeed * (0.25f + 0.75f * (float)Math.random());
            Vector2f vel = Misc.getUnitVectorAtDegreeAngle(dir);
            vel.scale(speed);
            float rampUp = 0.0f;
            float dur = 1.0f;
            float mult = 0.33f;
            mult = 1.0f;
            mult = 0.5f;
            engine.addNebulaParticle(loc, vel, size, 3.0f, rampUp *= mult, 0.0f, dur *= mult, adjustedColor);
            ++i;
        }
    }

    public static class ShockwaveParams
    implements Cloneable {
        public Color color;
        public float radius;
        public Vector2f loc;

        public ShockwaveParams() {
        }

        public ShockwaveParams(Color color, float radius, Vector2f loc) {
            this.color = color;
            this.radius = radius;
            this.loc = loc;
        }

        protected ShockwaveParams clone() {
            try {
                return (ShockwaveParams)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

