/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import org.lwjgl.util.vector.Vector2f;

public class SquallOnFireEffect
implements OnFireEffectPlugin,
DamageDealtModifier {
    public static float DAMAGE = 150.0f;
    protected String weaponId = null;

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        ShipAPI ship = weapon.getShip();
        if (!ship.hasListenerOfClass(SquallOnFireEffect.class)) {
            ship.addListener(this);
            this.weaponId = weapon.getId();
        }
    }

    @Override
    public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        MissileAPI m;
        if (shieldHit && param instanceof MissileAPI && (m = (MissileAPI)param).getWeaponSpec() != null && m.getWeaponSpec().getWeaponId().equals(this.weaponId)) {
            float base = damage.getBaseDamage();
            damage.setDamage(base + DAMAGE);
            return "squall";
        }
        return null;
    }
}

