/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lwjgl.util.vector.Vector2f;

public class TachyonLanceEffect
implements BeamEffectPlugin {
    private IntervalUtil fireInterval = new IntervalUtil(0.2f, 0.3f);
    private boolean wasZero = true;

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        CombatEntityAPI target = beam.getDamageTarget();
        if (target instanceof ShipAPI && beam.getBrightness() >= 1.0f) {
            float dur = beam.getDamage().getDpsDuration();
            if (!this.wasZero) {
                dur = 0.0f;
            }
            this.wasZero = beam.getDamage().getDpsDuration() <= 0.0f;
            this.fireInterval.advance(dur);
            if (this.fireInterval.intervalElapsed()) {
                boolean piercedShield;
                ShipAPI ship = (ShipAPI)target;
                boolean hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getRayEndPrevFrame());
                float pierceChance = ((ShipAPI)target).getHardFluxLevel() - 0.1f;
                boolean bl = piercedShield = hitShield && (float)Math.random() < (pierceChance *= ship.getMutableStats().getDynamic().getValue("shield_pierced_mult"));
                if (!hitShield || piercedShield) {
                    Vector2f point = beam.getRayEndPrevFrame();
                    float emp = beam.getDamage().getFluxComponent() * 0.5f;
                    float dam = beam.getDamage().getDamage() * 0.25f;
                    engine.spawnEmpArcPierceShields(beam.getSource(), point, beam.getDamageTarget(), beam.getDamageTarget(), DamageType.ENERGY, dam, emp, 100000.0f, "tachyon_lance_emp_impact", beam.getWidth() + 5.0f, beam.getFringeColor(), beam.getCoreColor());
                }
            }
        }
    }
}

