/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.CombatEntityPluginWithParticles;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TriadShieldStats
extends BaseShipSystemScript
implements DamageTakenModifier {
    public static Color JITTER_COLOR = new Color(100, 50, 255, 75);
    public static Color JITTER_UNDER_COLOR = new Color(100, 50, 255, 155);
    protected TriadShieldVisuals visuals = null;

    @Override
    public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        return null;
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
        if (this.visuals == null) {
            this.visuals = new TriadShieldVisuals(ship, this);
            Global.getCombatEngine().addLayeredRenderingPlugin(this.visuals);
            ship.addListener(this);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, id);
            return;
        }
        ShipSystemAPI system = ship.getPhaseCloak();
        if (system == null) {
            system = ship.getSystem();
        }
        float jitterLevel = effectLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        float jitterRangeBonus = jitterLevel * 0.0f;
        if (state != ShipSystemStatsScript.State.IN && state != ShipSystemStatsScript.State.ACTIVE) {
        }
        float minJitter = 4.0f;
        JITTER_COLOR = new Color(100, 100, 255, 75);
        JITTER_UNDER_COLOR = new Color(100, 100, 255, 155);
        if (jitterLevel > 0.0f) {
            ship.setCircularJitter(true);
            ship.setJitter(this, JITTER_COLOR, jitterLevel, 1, 0.0f, 7.0f + jitterRangeBonus);
            ship.setJitterUnder(this, JITTER_UNDER_COLOR, jitterLevel, 11, minJitter, minJitter + jitterRangeBonus);
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public static class TriadShieldVisuals
    extends CombatEntityPluginWithParticles {
        public ShipAPI ship;
        public TriadShieldStats script;

        public TriadShieldVisuals(ShipAPI ship, TriadShieldStats script) {
            this.ship = ship;
            this.script = script;
        }

        @Override
        public EnumSet<CombatEngineLayers> getActiveLayers() {
            return EnumSet.of(CombatEngineLayers.ABOVE_PARTICLES_LOWER);
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public float getRenderRadius() {
            return this.ship.getCollisionRadius() + 100.0f;
        }

        @Override
        public void advance(float amount) {
            super.advance(amount);
            this.entity.getLocation().set((ReadableVector2f)this.ship.getLocation());
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
        }

        @Override
        public void render(CombatEngineLayers layer, ViewportAPI viewport) {
            super.render(layer, viewport);
            float alphaMult = viewport.getAlphaMult();
            ShipSystemAPI system = this.ship.getPhaseCloak();
            if (system == null) {
                system = this.ship.getSystem();
            }
            if ((alphaMult *= system.getEffectLevel()) <= 0.0f) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ship.getLocation().x, (float)this.ship.getLocation().y, (float)0.0f);
            GL11.glRotatef((float)this.ship.getFacing(), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }
}

