/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.listeners.DamageTakenModifier;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.FlickerUtilV2;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class TriadShieldStatsBackup
extends BaseShipSystemScript
implements DamageTakenModifier {
    public static float SIDE_LENGTH = 16.0f;
    public static float INSIDE_ALPHA = 0.25f;
    protected TriadShieldVisuals visuals = null;

    @Override
    public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        return null;
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
        if (this.visuals == null) {
            this.visuals = new TriadShieldVisuals(ship, this);
            Global.getCombatEngine().addLayeredRenderingPlugin(this.visuals);
            ship.addListener(this);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, id);
            return;
        }
        ShipSystemAPI system = ship.getPhaseCloak();
        if (system == null) {
            system = ship.getSystem();
        }
        if (state != ShipSystemStatsScript.State.IN && state != ShipSystemStatsScript.State.ACTIVE) {
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public static class ShieldPiece {
        public ShipAPI ship;
        public Vector2f offset = new Vector2f();
        public Vector2f off = new Vector2f();
        public Vector2f vel = new Vector2f();
        public SpriteAPI sprite;
        public boolean upsideDown = false;
        public float side;
        public Vector2f p1;
        public Vector2f p2;
        public Vector2f p3;
        public float baseAlphaMult = 1.0f;
        public float p1Alpha = 1.0f;
        public float p2Alpha = 1.0f;
        public float p3Alpha = 1.0f;
        public FaderUtil fader;
        public FlickerUtilV2 flicker;

        public ShieldPiece(ShipAPI ship, boolean upsideDown, float x, float y, float side) {
            this.ship = ship;
            this.side = side;
            this.offset.set(x, y);
            this.upsideDown = upsideDown;
            this.fader = new FaderUtil(0.0f, 0.25f, 0.25f);
            this.fader.setBrightness((float)Math.random() * 1.0f);
            this.fader.setBounce(true, true);
            this.fader.fadeIn();
            this.flicker = new FlickerUtilV2();
            this.sprite = Global.getSettings().getSprite("graphics/hud/line8x8.png");
            float height = (float)((double)side * Math.sqrt(3.0) / 2.0);
            if (upsideDown) {
                this.p1 = new Vector2f(x + height / 2.0f, y);
                this.p2 = new Vector2f(x - height / 2.0f - 1.0f, y - side / 2.0f);
                this.p3 = new Vector2f(x - height / 2.0f - 1.0f, y + side / 2.0f);
            } else {
                this.p1 = new Vector2f(x - height / 2.0f, y);
                this.p2 = new Vector2f(x + height / 2.0f, y - side / 2.0f);
                this.p3 = new Vector2f(x + height / 2.0f, y + side / 2.0f);
            }
            this.updatePointAlpha();
        }

        public void updatePointAlpha() {
            BoundsAPI bounds = this.ship.getExactBounds();
            bounds.update(new Vector2f(0.0f, 0.0f), 0.0f);
            this.p1Alpha = this.getPointAlpha(this.p1);
            this.p2Alpha = this.getPointAlpha(this.p2);
            this.p3Alpha = this.getPointAlpha(this.p3);
            this.baseAlphaMult = Math.max(this.p1Alpha, this.p2Alpha);
            this.baseAlphaMult = Math.max(this.baseAlphaMult, this.p3Alpha);
        }

        public float getPointAlpha(Vector2f p) {
            BoundsAPI bounds = this.ship.getExactBounds();
            float minDist = Float.MAX_VALUE;
            ArrayList<Vector2f> boundsPoints = new ArrayList<Vector2f>();
            for (BoundsAPI.SegmentAPI segment : bounds.getSegments()) {
                Vector2f n = Misc.closestPointOnSegmentToPoint(segment.getP1(), segment.getP2(), p);
                float dist = Misc.getDistance(n, p);
                if (dist < minDist) {
                    minDist = dist;
                }
                boundsPoints.add(segment.getP1());
            }
            boundsPoints.add(bounds.getSegments().get(bounds.getSegments().size() - 1).getP2());
            float minAlphaAt = SIDE_LENGTH * 1.0f;
            float minAlpha = 0.0f;
            boolean inBounds = Misc.isPointInBounds(p, boundsPoints);
            if (inBounds) {
                minAlphaAt = SIDE_LENGTH * 2.0f;
                minAlphaAt = 0.0f;
            }
            if (minDist > minAlphaAt) {
                return minAlpha;
            }
            return Math.max(minAlpha, 1.0f - Math.min(1.0f, minDist / (minAlphaAt * 2.0f)));
        }

        public Vector2f getAdjustedOffset() {
            return Vector2f.add((Vector2f)this.offset, (Vector2f)this.off, (Vector2f)new Vector2f());
        }

        public Vector2f getCenter() {
            Vector2f result = new Vector2f((ReadableVector2f)this.offset);
            Misc.rotateAroundOrigin(result, this.ship.getFacing());
            Vector2f.add((Vector2f)this.ship.getLocation(), (Vector2f)result, (Vector2f)result);
            return result;
        }

        public void advance(float amount) {
            this.fader.advance(amount * (0.5f + 0.5f * (float)Math.random()));
        }

        public void render(float alphaMult) {
            Color color = new Color(255, 165, 100, 255);
            color = new Color(100, 165, 255, 255);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.off.x, (float)this.off.y, (float)0.0f);
            int i = 0;
            while (i < 2) {
                GL11.glEnable((int)3553);
                this.sprite.bindTexture();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)1);
                float t = 9.0f;
                float a = 0.25f;
                if (i == 1) {
                    t = 4.0f;
                    a = 1.0f;
                }
                if (this.upsideDown) {
                    GL11.glBegin((int)8);
                    Misc.setColor(color, alphaMult * this.p1Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p1.x, (float)this.p1.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p1.x - t), (float)this.p1.y);
                    Misc.setColor(color, alphaMult * this.p2Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p2.x, (float)this.p2.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p2.x + t * 0.5f), (float)(this.p2.y + t));
                    Misc.setColor(color, alphaMult * this.p3Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p3.x, (float)this.p3.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p3.x + t * 0.5f), (float)(this.p3.y - t));
                    Misc.setColor(color, alphaMult * this.p1Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p1.x, (float)this.p1.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p1.x - t), (float)this.p1.y);
                    GL11.glEnd();
                } else {
                    GL11.glBegin((int)8);
                    Misc.setColor(color, alphaMult * this.p1Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p1.x, (float)this.p1.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p1.x + t), (float)this.p1.y);
                    Misc.setColor(color, alphaMult * this.p2Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p2.x, (float)this.p2.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p2.x - t * 0.5f), (float)(this.p2.y + t));
                    Misc.setColor(color, alphaMult * this.p3Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p3.x, (float)this.p3.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p3.x - t * 0.5f), (float)(this.p3.y - t));
                    Misc.setColor(color, alphaMult * this.p1Alpha * a);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)this.p1.x, (float)this.p1.y);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)(this.p1.x + t), (float)this.p1.y);
                    GL11.glEnd();
                }
                ++i;
            }
            GL11.glPopMatrix();
        }
    }

    public static class ShieldPieceConnection {
        public ShieldPiece from;
        public ShieldPiece to;
        public float baseLength = 0.0f;

        public ShieldPieceConnection(ShieldPiece from, ShieldPiece to) {
            this.from = from;
            this.to = to;
            this.baseLength = Misc.getDistance(from.offset, to.offset);
            this.baseLength *= 0.9f + (float)Math.random() * 0.2f;
        }

        public void advance(float amount) {
            Vector2f fLoc = this.from.getAdjustedOffset();
            Vector2f tLoc = this.to.getAdjustedOffset();
            float length = Misc.getDistance(fLoc, tLoc);
            float diff = length - this.baseLength;
            float k = 1.0f;
            float accel = diff * k;
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(fLoc, tLoc));
            dir.scale(accel * amount);
            Vector2f.add((Vector2f)this.from.vel, (Vector2f)dir, (Vector2f)this.from.vel);
            dir.negate();
            Vector2f.add((Vector2f)this.to.vel, (Vector2f)dir, (Vector2f)this.to.vel);
            float maxOff = 20.0f;
            this.from.off.x += this.from.vel.x * amount;
            this.from.off.y += this.from.vel.y * amount;
            if (this.from.off.length() > maxOff) {
                this.from.off.scale(maxOff / this.from.off.length());
            }
            this.to.off.x += this.to.vel.x * amount;
            this.to.off.y += this.to.vel.y * amount;
            if (this.to.off.length() > maxOff) {
                this.to.off.scale(maxOff / this.to.off.length());
            }
        }
    }

    public static class TriadShieldVisuals
    extends BaseCombatLayeredRenderingPlugin {
        public ShipAPI ship;
        public TriadShieldStatsBackup script;
        public List<ShieldPiece> pieces = new ArrayList<ShieldPiece>();
        public List<ShieldPieceConnection> connections = new ArrayList<ShieldPieceConnection>();

        public TriadShieldVisuals(ShipAPI ship, TriadShieldStatsBackup script) {
            this.ship = ship;
            this.script = script;
            this.addShieldPieces();
        }

        public void addShieldPieces() {
            int gridWidth;
            this.pieces.clear();
            float side = SIDE_LENGTH = 20.0f;
            float height = (float)((double)side * Math.sqrt(3.0) / 2.0);
            float centerFromBottom = (float)(Math.sin(Math.toRadians(30.0)) * (double)height);
            int gridHeight = (int)(this.ship.getCollisionRadius() / side) * 2;
            if (gridHeight / 2 != 0) {
                ++gridHeight;
            }
            if (gridHeight < 6) {
                gridHeight = 6;
            }
            if ((gridWidth = (int)(this.ship.getCollisionRadius() / height) * 2) / 2 != 0) {
                ++gridWidth;
            }
            if (gridWidth < 6) {
                gridWidth = 6;
            }
            int i = -gridWidth / 2;
            while (i < gridWidth / 2) {
                int j = -gridHeight / 2;
                while (j < gridHeight / 2) {
                    float lowX = (float)i * height + height / 2.0f;
                    float highX = (float)(i + 1) * height + height / 2.0f;
                    float centerY = (float)j * side + side / 2.0f;
                    ShieldPiece piece = new ShieldPiece(this.ship, true, lowX + centerFromBottom, centerY, side - 2.0f);
                    if (piece.baseAlphaMult > 0.0f) {
                        this.pieces.add(piece);
                    }
                    if (j != gridHeight / 2 - 1) {
                        piece = new ShieldPiece(this.ship, false, highX - centerFromBottom, centerY += side / 2.0f, side - 2.0f);
                        if (piece.baseAlphaMult > 0.0f) {
                            this.pieces.add(piece);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            float maxDist = SIDE_LENGTH * 1.2f;
            int i2 = 0;
            while (i2 < this.pieces.size() - 1) {
                ShieldPiece curr = this.pieces.get(i2);
                int j = i2 + 1;
                while (j < this.pieces.size()) {
                    ShieldPiece other = this.pieces.get(j);
                    if (curr != other && !(Misc.getDistance(curr.offset, other.offset) > maxDist)) {
                        ShieldPieceConnection conn = new ShieldPieceConnection(curr, other);
                        this.connections.add(conn);
                    }
                    ++j;
                }
                ++i2;
            }
        }

        @Override
        public EnumSet<CombatEngineLayers> getActiveLayers() {
            return EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_AND_MISSILES_LAYER);
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public float getRenderRadius() {
            return this.ship.getCollisionRadius() + 100.0f;
        }

        @Override
        public void advance(float amount) {
            this.entity.getLocation().set((ReadableVector2f)this.ship.getLocation());
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            for (ShieldPiece piece : this.pieces) {
                piece.advance(amount);
            }
            for (ShieldPieceConnection conn : this.connections) {
                conn.advance(amount);
            }
        }

        @Override
        public void render(CombatEngineLayers layer, ViewportAPI viewport) {
            float alphaMult = viewport.getAlphaMult();
            ShipSystemAPI system = this.ship.getPhaseCloak();
            if (system == null) {
                system = this.ship.getSystem();
            }
            if ((alphaMult *= system.getEffectLevel()) <= 0.0f) {
                return;
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.ship.getLocation().x, (float)this.ship.getLocation().y, (float)0.0f);
            GL11.glRotatef((float)this.ship.getFacing(), (float)0.0f, (float)0.0f, (float)1.0f);
            for (ShieldPiece piece : this.pieces) {
                piece.render(alphaMult);
            }
            GL11.glPopMatrix();
        }
    }
}

