/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VPDriverEffect
implements OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public static float MIN_COOLDOWN = Global.getSettings().getFloat("minRefireDelay");
    public static int MAX_SHOTS = 4;
    protected List<DamagingProjectileAPI> shots;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (this.shots == null) {
            return;
        }
        Iterator<DamagingProjectileAPI> iter = this.shots.iterator();
        while (iter.hasNext()) {
            DamagingProjectileAPI shot = iter.next();
            if (!shot.isExpired() && !shot.isFading()) continue;
            iter.remove();
        }
        if (weapon.getCooldownRemaining() > MIN_COOLDOWN && this.shots.size() < MAX_SHOTS) {
            weapon.setRemainingCooldownTo(MIN_COOLDOWN);
        }
    }

    public static float getRoFMult(WeaponAPI weapon) {
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return 1.0f;
        }
        float rofMult = 1.0f;
        switch (weapon.getSpec().getType()) {
            case BALLISTIC: {
                rofMult = ship.getMutableStats().getBallisticRoFMult().getModifiedValue();
                break;
            }
            case MISSILE: {
                rofMult = ship.getMutableStats().getMissileRoFMult().getModifiedValue();
                break;
            }
            case ENERGY: {
                rofMult = ship.getMutableStats().getEnergyRoFMult().getModifiedValue();
            }
        }
        return rofMult;
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        if (this.shots == null) {
            this.shots = new ArrayList<DamagingProjectileAPI>();
        }
        this.shots.add(0, projectile);
    }
}

