/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BaseDwellerShipCreator
implements DwellerShipCreator {
    public static float IMPACT_VOLUME_MULT = 0.33f;
    public static float AIM_BONUS = 1.0f;
    public static float MISSILE_GUIDANCE_BONUS = 1.0f;
    public static float CR_BONUS = 30.0f;
    public static float SENSOR_PROFILE_MULT = 0.0f;
    public static float EW_PENALTY_MULT = 0.5f;
    public static float FLAT_RANGE_BONUS = 200.0f;
    public static float FLAT_ARMOR_BONUS = 50.0f;

    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getAutofireAimAccuracy().modifyFlat(id, AIM_BONUS);
        stats.getMissileGuidance().modifyFlat(id, MISSILE_GUIDANCE_BONUS);
        stats.getMaxCombatReadiness().modifyFlat(id, CR_BONUS * 0.01f);
        stats.getSensorProfile().modifyMult(id, SENSOR_PROFILE_MULT);
        stats.getDynamic().getMod("electronic_warfare_penalty_mod").modifyMult(id, EW_PENALTY_MULT);
        stats.getEnergyWeaponRangeBonus().modifyFlat(id, FLAT_RANGE_BONUS);
        stats.getBallisticWeaponRangeBonus().modifyFlat(id, FLAT_RANGE_BONUS);
        stats.getEffectiveArmorBonus().modifyFlat(id, FLAT_ARMOR_BONUS);
    }

    @Override
    public void initAfterShipCreation(ShipAPI ship, String id) {
        ship.setDoNotRenderWeapons(true);
        ship.setNoMuzzleFlash(true);
        ship.setRenderEngines(false);
        ship.setDoNotRenderVentingAnimation(true);
    }

    @Override
    public void initAfterShipAddedToCombatEngine(ShipAPI ship, String id) {
        ship.setDoNotRenderSprite(true);
    }

    @Override
    public void initInCombat(ShipAPI ship) {
        this.initBasicShipProperties(ship);
        DwellerShroud shroud = this.createShroud(ship);
        DwellerCombatPlugin plugin = this.createPlugin(ship);
        this.setOverloadColorAndText(ship, shroud);
    }

    protected DwellerShroud createShroud(ShipAPI ship) {
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (shroud == null) {
            shroud = new DwellerShroud((CombatEntityAPI)ship, this.createShroudParams(ship));
        }
        return shroud;
    }

    protected DwellerShroud.DwellerShroudParams createShroudParams(ShipAPI ship) {
        DwellerShroud.DwellerShroudParams params = DwellerShroud.createBaselineParams(ship);
        this.modifyBaselineShroudParams(ship, params);
        return params;
    }

    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
    }

    protected DwellerCombatPlugin createPlugin(ShipAPI ship) {
        DwellerCombatPlugin plugin = DwellerCombatPlugin.getDwellerPluginFor(ship);
        if (plugin == null) {
            plugin = new DwellerCombatPlugin(ship);
        }
        return plugin;
    }

    protected void initBasicShipProperties(ShipAPI ship) {
        ship.setExplosionScale(0.001f);
        ship.setHulkChanceOverride(0.0f);
        ship.setImpactVolumeMult(IMPACT_VOLUME_MULT);
        ship.getArmorGrid().clearComponentMap();
        ship.setNoDamagedExplosions(true);
        ship.setSpawnDebris(false);
        ship.setShipCollisionSoundOverride("dweller_collision_ships");
        ship.setAsteroidCollisionSoundOverride("dweller_collision_asteroid_ship");
    }

    protected void setOverloadColorAndText(ShipAPI ship, DwellerShroud shroud) {
        Color color = Misc.setAlpha(Misc.setBrightness(shroud.getParams().flashFringeColor, 255), 255);
        ship.getFluxTracker().setOverloadColor(color);
        ship.getFluxTracker().setOverloadText("Stunned!");
    }
}

