/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.ConvulsiveLungeSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.loading.BeamWeaponSpecAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class DarkenedGazeSystemScript
extends BaseShipSystemScript
implements DwellerShroud.ShroudNegativeParticleFilter {
    public static float SHIELD_OPENING = 90.0f;
    public static float TURN_RATE_REDUCTION = 0.85f;
    public static float DAMAGE_TAKEN_MULT = 2.0f;
    public static String DARKENED_GAZE_SYSTEM_TAG = "darkened_gaze_system_tag";
    public static String DARKENED_GAZE_PRIMARY_WEAPON_TAG = "darkened_gaze_system_tag";
    protected List<WeaponAPI> weapons = null;
    protected float elapsedActive = 0.0f;

    protected void findWeapons(ShipAPI ship) {
        if (this.weapons != null) {
            return;
        }
        ship.addTag(DARKENED_GAZE_SYSTEM_TAG);
        this.weapons = new ArrayList<WeaponAPI>();
        int index = 0;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.getSlot().isDecorative()) {
                this.weapons.add(w);
            }
            ++index;
        }
        float min = 1.0E7f;
        WeaponAPI primary = null;
        for (WeaponAPI w : this.weapons) {
            float test = w.getSlot().getLocation().y;
            if (!(test < min)) continue;
            min = test;
            primary = w;
        }
        if (primary != null) {
            primary.setCustom(DARKENED_GAZE_PRIMARY_WEAPON_TAG);
        }
        Collections.sort(this.weapons, (w1, w2) -> (int)Math.signum(Math.abs(w1.getSlot().getLocation().y) - Math.abs(w2.getSlot().getLocation().y)));
        float incr = 0.15f;
        float[] offsets = new float[]{0.0f, incr, -incr, 2.0f * incr, -2.0f * incr, 3.0f * incr, -3.0f * incr, 4.0f * incr, -4.0f * incr};
        int i = 0;
        while (i < this.weapons.size()) {
            WeaponAPI w = this.weapons.get(i);
            w.ensureClonedSpec();
            w.getSpec().getHardpointAngleOffsets().clear();
            w.getSpec().getHardpointAngleOffsets().add(Float.valueOf(offsets[i]));
            w.getSpec().getTurretAngleOffsets().clear();
            w.getSpec().getTurretAngleOffsets().add(Float.valueOf(offsets[i]));
            ((BeamWeaponSpecAPI)w.getSpec()).setCollisionClass(CollisionClass.RAY_FIGHTER);
            ++i;
        }
    }

    public boolean isFFAConcern() {
        if (this.weapons.size() == 0) {
            return false;
        }
        return ((BeamWeaponSpecAPI)this.weapons.get(0).getSpec()).getCollisionClass() == CollisionClass.RAY;
    }

    public float getRange() {
        if (this.weapons == null || this.weapons.isEmpty()) {
            return 0.0f;
        }
        return this.weapons.get(0).getRange();
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        this.findWeapons(ship);
        ShieldAPI shield = ship.getShield();
        if (shield != null) {
            shield.forceFacing(ship.getFacing() + 180.0f);
            if (!ship.getFluxTracker().isOverloadedOrVenting()) {
                shield.toggleOn();
            }
            ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
        }
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (state == ShipSystemStatsScript.State.IN) {
            if (shield != null) {
                currOpening = effectLevel * SHIELD_OPENING;
                shield.setArc(360.0f - currOpening);
            }
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            for (WeaponAPI w : this.weapons) {
                w.setForceFireOneFrame(true);
            }
        } else if (state == ShipSystemStatsScript.State.OUT && shield != null) {
            currOpening = effectLevel * SHIELD_OPENING;
            shield.setArc(360.0f - currOpening);
        }
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE) {
            if (shroud != null) {
                shroud.getShroudParams().negativeParticleClearCenterAreaRadius = 150.0f;
                shroud.getShroudParams().negativeParticleGenRate = 0.5f;
                shroud.getShroudParams().negativeParticleFilter = this;
            }
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(ship.getFacing() + 180.0f);
            float amount = Global.getCombatEngine().getElapsedInLastFrame();
            float accel = ConvulsiveLungeSystemScript.PARTICLE_WINDUP_ACCEL * amount * effectLevel;
            if (shroud != null) {
                for (RoilingSwarmEffect.SwarmMember p : shroud.getMembers()) {
                    float currAngle = Misc.getAngleInDegrees(ship.getLocation(), p.loc);
                    float angleDiff = Misc.getAngleDiff(currAngle, ship.getFacing());
                    float accelMult = 1.0f;
                    if (angleDiff > SHIELD_OPENING * 0.5f) {
                        accelMult = 0.0f;
                    }
                    p.vel.x += dir.x * accel * accelMult;
                    p.vel.y += dir.y * accel * accelMult;
                }
            }
            if (state == ShipSystemStatsScript.State.ACTIVE) {
                this.elapsedActive += amount;
                float f = Math.min(this.elapsedActive, 1.0f) * 1.0f;
                f = 1.0f - f;
            }
            ship.getMutableStats().getMaxTurnRate().modifyMult(id, 1.0f - TURN_RATE_REDUCTION * effectLevel);
            ship.getMutableStats().getHullDamageTakenMult().modifyMult(id, 1.0f + (DAMAGE_TAKEN_MULT - 1.0f) * effectLevel);
        } else {
            if (shroud != null) {
                shroud.getShroudParams().negativeParticleClearCenterAreaRadius = 50.0f;
                shroud.getShroudParams().negativeParticleGenRate = 1.0f;
                shroud.getShroudParams().negativeParticleFilter = null;
            }
            this.elapsedActive = 0.0f;
            ship.getMutableStats().getMaxTurnRate().unmodifyMult(id);
            ship.getMutableStats().getHullDamageTakenMult().unmodifyMult(id);
        }
        ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE, 1.0f, Float.valueOf(this.getRange() - 300.0f));
        if (state == ShipSystemStatsScript.State.IDLE) {
            shield.setArc(360.0f);
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    @Override
    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        return super.getInfoText(system, ship);
    }

    @Override
    public boolean isParticleOk(DwellerShroud shroud, Vector2f loc) {
        if (shroud == null || shroud.getAttachedTo() == null) {
            return true;
        }
        float angle = Misc.getAngleInDegrees(shroud.getAttachedTo().getLocation(), loc);
        return !Misc.isInArc(shroud.getAttachedTo().getFacing(), SHIELD_OPENING, angle);
    }
}

