/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.HullDamageAboutToBeTakenListener;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.combat.ShipExplosionFlareVisual;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.WarpingSpriteRendererUtilV2;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.MutatingValueUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class DwellerCombatPlugin
extends BaseCombatLayeredRenderingPlugin
implements HullDamageAboutToBeTakenListener {
    public static Color STANDARD_PART_GLOW_COLOR = new Color(255, 0, 50, 255);
    public static String WEAPON_ACTIVATED = "weapon_activated";
    public static String SHIELD_ACTIVATED = "shield_activated";
    public static String SYSTEM_ACTIVATED = "system_activated";
    public static String FLUX_ACTIVATED = "flux_activated";
    public static String KEY_SHIP_MAP = "DwellerCombatPlugin_shipMap_key";
    protected CombatEntityAPI attachedTo;
    protected float elapsed = 0.0f;
    protected List<DwellerShipPart> parts = new ArrayList<DwellerShipPart>();
    protected boolean spawnedShipExplosionParticles = false;
    protected DCPPlugin plugin = null;
    public Object custom1;
    public Object custom2;
    public Object custom3;
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.BELOW_INDICATORS_LAYER);
    protected float sinceTest = 10.0f;

    public static DwellerCombatPlugin getDwellerPluginFor(CombatEntityAPI entity) {
        if (entity == null) {
            return null;
        }
        return DwellerCombatPlugin.getShipMap().get(entity);
    }

    public static LinkedHashMap<CombatEntityAPI, DwellerCombatPlugin> getShipMap() {
        LinkedHashMap map = (LinkedHashMap)Global.getCombatEngine().getCustomData().get(KEY_SHIP_MAP);
        if (map == null) {
            map = new LinkedHashMap();
            Global.getCombatEngine().getCustomData().put(KEY_SHIP_MAP, map);
        }
        return map;
    }

    public DwellerCombatPlugin(CombatEntityAPI attachedTo) {
        CombatEntityAPI e = Global.getCombatEngine().addLayeredRenderingPlugin(this);
        e.getLocation().set((ReadableVector2f)attachedTo.getLocation());
        this.attachedTo = attachedTo;
        if (attachedTo instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)attachedTo;
            ship.addListener(this);
        }
        DwellerCombatPlugin.getShipMap().put(attachedTo, this);
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public float getRenderRadius() {
        float extra = 300.0f;
        return this.attachedTo.getCollisionRadius() + extra;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void advance(float amount) {
        ShipAPI ship;
        if (Global.getCombatEngine().isPaused() || this.entity == null || this.isExpired()) {
            return;
        }
        this.entity.getLocation().set((ReadableVector2f)this.attachedTo.getLocation());
        this.elapsed += amount;
        this.isExpired();
        if (this.attachedTo instanceof ShipAPI && (ship = (ShipAPI)this.attachedTo).getShield() != null) {
            ship.setJitterShields(true);
            ship.setCircularJitter(true);
            Color color = new Color(255, 0, 50, 255);
            ship.setJitter(this, color, 1.0f, 3, 0.0f);
        }
        if (this.shouldDespawn()) {
            for (DwellerShipPart part : this.parts) {
                part.fadeOut();
            }
        } else if (this.attachedTo instanceof ShipAPI) {
            ship = (ShipAPI)this.attachedTo;
            this.fadeOut(WEAPON_ACTIVATED, SHIELD_ACTIVATED, FLUX_ACTIVATED, SYSTEM_ACTIVATED);
            boolean activeWeapons = false;
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (w.isDecorative() || !w.isFiring()) continue;
                activeWeapons = true;
                break;
            }
            if (activeWeapons) {
                this.fadeIn(WEAPON_ACTIVATED);
            }
            if (ship.getShield() != null && ship.getShield().isOn()) {
                this.fadeIn(SHIELD_ACTIVATED);
            }
            float systemLevel = 0.0f;
            if (ship.getSystem() != null) {
                systemLevel = ship.getSystem().getEffectLevel();
            }
            if (systemLevel > 0.0f) {
                this.fadeIn(SYSTEM_ACTIVATED);
            }
            this.setBrightness(systemLevel, SYSTEM_ACTIVATED);
            float fluxLevel = ship.getFluxLevel();
            if (fluxLevel > 0.0f) {
                this.fadeIn(FLUX_ACTIVATED);
            }
            this.setBrightness(fluxLevel, FLUX_ACTIVATED);
        }
        for (DwellerShipPart part : this.parts) {
            part.advance(amount);
        }
        if (this.plugin != null) {
            this.plugin.advance(this, amount);
        }
    }

    public boolean shouldDespawn() {
        if (this.attachedTo instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)this.attachedTo;
            return !Global.getCombatEngine().isShipAlive(ship);
        }
        if (this.attachedTo instanceof MissileAPI) {
            MissileAPI missile = (MissileAPI)this.attachedTo;
            return !Global.getCombatEngine().isMissileAlive(missile);
        }
        return this.attachedTo.isExpired() || !Global.getCombatEngine().isEntityInPlay(this.attachedTo);
    }

    @Override
    public boolean isExpired() {
        boolean shouldDespawn = this.shouldDespawn();
        if (shouldDespawn) {
            boolean allFaded = true;
            for (DwellerShipPart part : this.parts) {
                if (part.getFader().isFadedOut() || !(part.getAlphaMult() > 0.0f)) continue;
                allFaded = false;
                break;
            }
            if (allFaded) {
                DwellerCombatPlugin.getShipMap().remove(this.attachedTo);
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        if (alphaMult <= 0.0f) {
            return;
        }
        Vector2f aLoc = new Vector2f((ReadableVector2f)this.attachedTo.getLocation());
        for (DwellerShipPart part : this.parts) {
            part.render(aLoc.x, aLoc.y, alphaMult, this.attachedTo.getFacing() - 90.0f, layer);
        }
    }

    public CombatEntityAPI getAttachedTo() {
        return this.attachedTo;
    }

    public List<DwellerShipPart> getParts() {
        return this.parts;
    }

    public DwellerShipPart getPart(String id) {
        for (DwellerShipPart curr : this.parts) {
            if (!id.equals(curr.getId())) continue;
            return curr;
        }
        return null;
    }

    public void fadeIn(String ... tags) {
        for (DwellerShipPart part : this.getParts(tags)) {
            part.fadeIn();
        }
    }

    public void fadeOut(String ... tags) {
        for (DwellerShipPart part : this.getParts(tags)) {
            part.fadeOut();
        }
    }

    public void setAlphaMult(float alphaMult, String ... tags) {
        for (DwellerShipPart part : this.getParts(tags)) {
            part.setAlphaMult(alphaMult);
        }
    }

    public void setBrightness(float b, String ... tags) {
        String key = "";
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            key = String.valueOf(key) + tag + "_";
            ++n2;
        }
        if (tags.length == 1) {
            key = tags[0];
        }
        for (DwellerShipPart part : this.getParts(tags)) {
            part.getBrightness().shift(key, b, 0.5f, 0.5f, 1.0f);
        }
    }

    public List<DwellerShipPart> getParts(String ... tags) {
        ArrayList<DwellerShipPart> result = new ArrayList<DwellerShipPart>();
        block0: for (DwellerShipPart curr : this.parts) {
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if (curr.hasTag(tag)) {
                    result.add(curr);
                    continue block0;
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public boolean notifyAboutToTakeHullDamage(Object param, ShipAPI ship, Vector2f point, float damageAmount) {
        float hull = ship.getHitpoints();
        if (damageAmount >= hull && !this.spawnedShipExplosionParticles && ship.getExplosionScale() > 0.0f) {
            float dur;
            float s;
            float scatterMult;
            Vector2f loc;
            int numSwirly = 11;
            int numDark = 11;
            float size = ship.getCollisionRadius() * 0.25f;
            if (size < 15.0f) {
                size = 15.0f;
            }
            if (size > 50.0f) {
                size = 50.0f;
            }
            float durMult = 1.0f;
            float flashMult = 1.0f;
            if (ship.isCapital()) {
                size = 100.0f;
                durMult = 2.0f;
                flashMult = 2.0f;
            }
            float baseSize = size;
            CombatEngineAPI engine = Global.getCombatEngine();
            float rampUp = 0.0f;
            Color color = DwellerShroud.SHROUD_COLOR;
            int i = 0;
            while (i < numSwirly) {
                loc = new Vector2f((ReadableVector2f)ship.getLocation());
                scatterMult = 0.5f;
                loc = Misc.getPointWithinRadius(loc, size * 1.0f * scatterMult);
                s = size * 4.0f * (0.5f + (float)Math.random() * 0.5f);
                dur = 0.5f + (float)Math.random() * 0.5f;
                size *= 1.25f;
                engine.addSwirlyNebulaParticle(loc, ship.getVelocity(), s, 3.0f, rampUp, 0.0f, dur *= durMult, color, false);
                ++i;
            }
            size = baseSize;
            i = 0;
            while (i < numDark) {
                loc = new Vector2f((ReadableVector2f)ship.getLocation());
                scatterMult = 0.5f;
                loc = Misc.getPointWithinRadius(loc, size * 1.0f * scatterMult);
                s = size * 4.0f * (0.5f + (float)Math.random() * 0.5f);
                dur = 0.5f + (float)Math.random() * 0.5f;
                size *= 1.25f;
                engine.addNegativeSwirlyNebulaParticle(loc, ship.getVelocity(), s, 3.0f, rampUp, 0.0f, dur *= durMult, color);
                ++i;
            }
            Vector2f expVel = ship.getVelocity();
            Vector2f expLoc = ship.getShieldCenterEvenIfNoShield();
            expLoc = ship.getLocation();
            float explosionScale = 1.0f;
            if (ship.isCapital()) {
                explosionScale *= 1.7f;
            } else if (ship.isCruiser()) {
                explosionScale *= 1.5f;
            } else if (ship.isDestroyer()) {
                explosionScale *= 1.5f;
            }
            Color flashColor = new Color(255, 50, 100, 255);
            float b = 1.0f;
            float glowSize = (float)Math.sqrt(ship.getCollisionRadius()) * 15.0f * 4.0f;
            if (ship.isFighter()) {
                glowSize *= 0.5f;
            }
            glowSize *= explosionScale;
            glowSize *= flashMult;
            ShipExplosionFlareVisual.ShipExplosionFlareParams sp = new ShipExplosionFlareVisual.ShipExplosionFlareParams();
            float er = (float)Math.sqrt(ship.getCollisionRadius()) * 15.0f * 4.0f;
            float mult = 0.47786722f;
            sp.flareWidth = (er *= mult) * 4.0f * explosionScale;
            sp.flareHeight = er * 1.6f * explosionScale;
            sp.color = flashColor;
            sp.fadeIn = 0.1f;
            sp.fadeOut = 2.0f;
            CombatEntityAPI e = engine.addLayeredRenderingPlugin(new ShipExplosionFlareVisual(sp));
            e.getLocation().set((ReadableVector2f)expLoc);
            e.getVelocity().set((ReadableVector2f)expVel);
            engine.addHitParticle(expLoc, expVel, glowSize * 1.0f, b, 1.5f * durMult, flashColor);
            engine.addHitParticle(expLoc, expVel, glowSize * 0.5f, b, 1.5f * durMult, flashColor);
            this.spawnedShipExplosionParticles = true;
        }
        return false;
    }

    public DCPPlugin getPlugin() {
        return this.plugin;
    }

    public void setPlugin(DCPPlugin plugin) {
        this.plugin = plugin;
    }

    public static interface DCPPlugin {
        public void advance(DwellerCombatPlugin var1, float var2);
    }

    public static class WobblyPart
    extends BaseDwellerShipPart {
        public WarpingSpriteRendererUtilV2 renderer;
        public boolean negativeBlend = false;
        public boolean additiveBlend = false;
        public MutatingValueUtil spin;
        public float angle = 0.0f;

        public WobblyPart(String spriteKey, float scale, float warpMult, Vector2f offset, float facingOffset) {
            this(spriteKey, scale, 5, 5, warpMult, offset, facingOffset);
        }

        public WobblyPart(String spriteKey, float scale, int verticesWide, int verticesTall, float warpMult, Vector2f offset, float facingOffset) {
            super(offset, facingOffset);
            SpriteAPI sprite = Global.getSettings().getSprite("dweller", spriteKey);
            float width = sprite.getWidth() * scale;
            float height = sprite.getHeight() * scale;
            float warpAmt = width * 0.04f * warpMult;
            sprite.setSize(width, height);
            sprite.setCenter(width / 2.0f, height / 2.0f);
            this.renderer = new WarpingSpriteRendererUtilV2(sprite, verticesWide, verticesTall, warpAmt, warpAmt * 1.4f, 1.0f);
            this.spin = new MutatingValueUtil(0.0f, 0.0f, 0.0f);
        }

        public float getAngle() {
            return this.angle;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public void setSpin(float min, float max, float rate) {
            this.spin = new MutatingValueUtil(min, max, rate);
        }

        public MutatingValueUtil getSpin() {
            return this.spin;
        }

        @Override
        public void advance(float amount) {
            super.advance(amount);
            this.spin.advance(amount);
            this.angle += this.spin.getValue() * amount;
            this.renderer.advance(amount);
        }

        @Override
        public void renderImpl(float x, float y, float alphaMult, float angle, CombatEngineLayers layer) {
            if (layer == CombatEngineLayers.BELOW_INDICATORS_LAYER) {
                if (this.negativeBlend) {
                    GL14.glBlendEquation((int)32779);
                    this.renderer.getSprite().setBlendFunc(770, 1);
                } else if (this.additiveBlend) {
                    this.renderer.getSprite().setAdditiveBlend();
                } else {
                    this.renderer.getSprite().setNormalBlend();
                }
                this.renderer.getSprite().setAlphaMult(alphaMult);
                this.renderer.getSprite().setColor(this.color);
                this.renderer.getSprite().setAngle(angle + this.facingOffset + this.angle);
                this.renderer.renderAtCenter(x, y);
                if (this.negativeBlend) {
                    GL14.glBlendEquation((int)32774);
                }
            }
        }
    }
}

