/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.RealityDisruptorChargeGlow;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class InimicalEmanationOnFireEffect
implements OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public static float EXTRA_ARC = 30.0f;
    public static float REPAIR_RATE_DEBUFF_DUR = 5.0f;
    protected float extraRangeOnNextFire = 0.0f;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return;
        }
        float emp = projectile.getEmpAmount();
        float dam = projectile.getDamageAmount();
        CombatEntityAPI target = this.findTarget(projectile, weapon, engine);
        Vector2f noTargetDest = null;
        if (target == null) {
            noTargetDest = this.pickNoTargetDest(projectile, weapon, engine);
        }
        Vector2f towards = noTargetDest;
        if (target != null) {
            towards = target.getLocation();
        }
        float thickness = 30.0f;
        Color color = weapon.getSpec().getGlowColor();
        Color coreColor = Color.white;
        coreColor = Misc.zeroColor;
        coreColor = color;
        color = new Color(255, 0, 30, 255);
        coreColor = new Color(255, 10, 255, 255);
        coreColor = color = DwellerShroud.SHROUD_GLOW_COLOR;
        float coreWidthMult = 1.0f;
        Vector2f from = projectile.getLocation();
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (shroud != null) {
            float angle = Misc.getAngleInDegrees(ship.getLocation(), towards);
            from = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f - 180.0f * (float)Math.random());
            from.scale((0.5f + (float)Math.random() * 0.25f) * shroud.getShroudParams().maxOffset);
            Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)from, (Vector2f)from);
        }
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 4.0f;
        params.maxZigZagMult = 0.25f;
        params.zigZagReductionFactor = 1.0f;
        params.flickerRateMult = 0.75f + 0.25f * (float)Math.random();
        params.fadeOutDist = 150.0f;
        params.minFadeOutMult = 5.0f;
        params.glowSizeMult = 0.5f;
        if (target != null) {
            EmpArcEntityAPI arc = engine.spawnEmpArc(ship, from, ship, target, DamageType.ENERGY, dam, emp, 100000.0f, "inimical_emanation_impact", thickness, color, coreColor, params);
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            arc.setSingleFlickerMode();
            arc.setRenderGlowAtStart(false);
            if (shroud != null) {
                arc.setFadedOutAtStart(true);
            }
            arc.setWarping(0.2f);
            if (target instanceof ShipAPI && !arc.isShieldHit()) {
                ShipAPI s = (ShipAPI)target;
                List<RealityDisruptorChargeGlow.RDRepairRateDebuff> listeners = s.getListeners(RealityDisruptorChargeGlow.RDRepairRateDebuff.class);
                if (listeners.isEmpty()) {
                    s.addListener(new RealityDisruptorChargeGlow.RDRepairRateDebuff(s, REPAIR_RATE_DEBUFF_DUR));
                } else {
                    listeners.get(0).resetDur(REPAIR_RATE_DEBUFF_DUR);
                }
            }
            if (arc.getTargetLocation() != null) {
                RealityDisruptorChargeGlow.spawnEMPParticles(RealityDisruptorChargeGlow.EMPArcHitType.INIMICAL_EMANATION, null, arc.getTargetLocation(), target);
            }
        } else {
            Vector2f to = noTargetDest;
            EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, to, ship, thickness, color, coreColor, params);
            arc.setCoreWidthOverride(thickness * coreWidthMult);
            arc.setSingleFlickerMode();
            arc.setRenderGlowAtStart(false);
            if (shroud != null) {
                arc.setFadedOutAtStart(true);
            }
            arc.setWarping(0.2f);
            RealityDisruptorChargeGlow.spawnEMPParticles(RealityDisruptorChargeGlow.EMPArcHitType.INIMICAL_EMANATION, null, to, ship);
        }
    }

    public Vector2f pickNoTargetDest(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float spread = 50.0f;
        float range = Math.min(weapon.getRange() - spread, 300.0f);
        Vector2f from = projectile.getLocation();
        Vector2f dir = Misc.getUnitVectorAtDegreeAngle(weapon.getCurrAngle() + (EXTRA_ARC / 2.0f - EXTRA_ARC * (float)Math.random()));
        dir.scale(range);
        Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)dir);
        dir = Misc.getPointWithinRadius(dir, spread);
        return dir;
    }

    public CombatEntityAPI findTarget(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        float range = weapon.getRange() + 50.0f + this.extraRangeOnNextFire;
        this.extraRangeOnNextFire = 0.0f;
        Vector2f from = projectile.getLocation();
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(from, range * 2.0f, range * 2.0f);
        int owner = weapon.getShip().getOwner();
        CombatEntityAPI best = null;
        float minScore = Float.MAX_VALUE;
        ShipAPI ship = weapon.getShip();
        boolean ignoreFlares = ship != null && ship.getMutableStats().getDynamic().getValue("pd_ignores_flares", 0.0f) >= 1.0f;
        ignoreFlares |= weapon.hasAIHint(WeaponAPI.AIHints.IGNORES_FLARES);
        boolean phaseMode = true;
        while (iter.hasNext()) {
            float score;
            MissileAPI missile;
            CombatEntityAPI other;
            Object o = iter.next();
            if (!(o instanceof MissileAPI) && !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getOwner() == owner) continue;
            boolean phaseHit = false;
            if (other instanceof ShipAPI) {
                ShipAPI otherShip = (ShipAPI)other;
                if (otherShip.isHulk()) continue;
                if (otherShip.isPhased()) {
                    if (!phaseMode) continue;
                    phaseHit = true;
                }
                if (!otherShip.isTargetable()) continue;
            }
            if (!phaseHit && other.getCollisionClass() == CollisionClass.NONE || ignoreFlares && other instanceof MissileAPI && (missile = (MissileAPI)other).isFlare()) continue;
            float radius = Misc.getTargetingRadius(from, other, false);
            float dist = Misc.getDistance(from, other.getLocation()) - radius;
            if (dist > range || !Misc.isInArc(weapon.getCurrAngle(), EXTRA_ARC, from, other.getLocation()) || !((score = dist) < minScore)) continue;
            minScore = score;
            best = other;
        }
        return best;
    }
}

