/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.CryofluxTransducerEffect;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL14;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class PseudoparticleJetEffect
extends CryofluxTransducerEffect {
    public static float PARTICLE_SCALE_MULT = 0.7f;
    protected IntervalUtil interval = new IntervalUtil(0.075f, 0.125f);
    protected List<CryofluxTransducerEffect.ParticleData> negativeParticles = new ArrayList<CryofluxTransducerEffect.ParticleData>();

    public PseudoparticleJetEffect() {
    }

    public PseudoparticleJetEffect(DamagingProjectileAPI projectile, DamagingProjectileAPI prev) {
        super(projectile, prev);
        int num = 2;
        num = 1;
        int i = 0;
        while (i < num) {
            this.negativeParticles.add(new CryofluxTransducerEffect.ParticleData(this.proj, this));
            ++i;
        }
        float size = this.proj.getProjectileSpec().getWidth() * 0.6f;
        for (CryofluxTransducerEffect.ParticleData p : this.negativeParticles) {
            p.sprite = Global.getSettings().getSprite(super.getParticleSpriteCat(), super.getParticleSpriteKey());
            float i2 = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            p.sprite.setTexWidth(0.25f);
            p.sprite.setTexHeight(0.25f);
            p.sprite.setTexX(i2 * 0.25f);
            p.sprite.setTexY(j * 0.25f);
            p.scale = 2.0f + (float)Math.random();
            p.scale *= 1.5f;
            p.scale *= PARTICLE_SCALE_MULT;
            p.scaleIncreaseRate *= 1.0f + (float)Math.random();
            Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
            v.scale(size + size * (float)Math.random() * 0.5f);
            v.scale(0.67f * p.scale);
            p.vel.set((ReadableVector2f)v);
            p.offset = Misc.getPointWithinRadiusUniform(p.offset, size * 0.1f * p.scale, Misc.random);
            float offsetAngle = Misc.getAngleInDegrees(p.vel) + 180.0f;
            p.offset = Misc.getUnitVectorAtDegreeAngle(offsetAngle += 90.0f * ((float)Math.random() - 0.5f));
            p.offset.scale(size * 1.0f * p.scale);
            p.scale *= 0.7f;
            p.scaleIncreaseRate /= this.getParticleScaleIncreaseRateMult();
        }
    }

    @Override
    protected PseudoparticleJetEffect createTrail(DamagingProjectileAPI projectile, DamagingProjectileAPI prev) {
        return new PseudoparticleJetEffect(projectile, prev);
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        for (CryofluxTransducerEffect.ParticleData p : this.negativeParticles) {
            p.advance(amount);
        }
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        super.render(layer, viewport);
        float x = this.entity.getLocation().x;
        float y = this.entity.getLocation().y;
        Color color = RiftLanceEffect.getColorForDarkening(this.proj.getProjectileSpec().getFringeColor());
        color = Misc.setAlpha(color, 100);
        float b = this.proj.getBrightness();
        b *= viewport.getAlphaMult();
        GL14.glBlendEquation((int)32779);
        for (CryofluxTransducerEffect.ParticleData p : this.negativeParticles) {
            float size = this.proj.getProjectileSpec().getWidth() * 0.6f;
            size *= p.scale;
            float alphaMult = 1.0f;
            Vector2f offset = p.offset;
            float diff = Misc.getAngleDiff(this.baseFacing, this.proj.getFacing());
            if (Math.abs(diff) > 0.1f) {
                offset = Misc.rotateAroundOrigin(offset, diff);
            }
            Vector2f loc = new Vector2f(x + offset.x, y + offset.y);
            p.sprite.setBlendFunc(770, 1);
            p.sprite.setAngle(p.angle);
            p.sprite.setSize(size, size);
            p.sprite.setAlphaMult(b * alphaMult * p.fader.getBrightness());
            p.sprite.setColor(color);
            p.sprite.renderAtCenter(loc.x, loc.y);
        }
        GL14.glBlendEquation((int)32774);
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        super.onHit(projectile, target, point, shieldHit, damageResult, engine);
        Color c = RiftLanceEffect.getColorForDarkening(projectile.getProjectileSpec().getFringeColor());
        c = Misc.setAlpha(c, 100);
        float baseDuration = 1.0f;
        float baseSize = projectile.getProjectileSpec().getLength() * 0.5f;
        float size = baseSize * 1.5f;
        float sizeMult = Misc.getHitGlowSize(100.0f, projectile.getDamage().getBaseDamage(), damageResult) / 100.0f;
        size *= sizeMult;
        float extraDur = 0.0f;
        point = Misc.getPointWithinRadiusUniform(point, baseSize * 0.75f, Misc.random);
        float dur = baseDuration + baseDuration * (float)Math.random();
        dur += extraDur;
        float nSize = size *= 1.5f;
        Vector2f pt = point;
        Vector2f vel = new Vector2f();
        if (target instanceof ShipAPI) {
            vel.set((ReadableVector2f)target.getVelocity());
        }
        Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
        v.scale(nSize + nSize * (float)Math.random() * 0.5f);
        v.scale(0.5f);
        Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
        float maxSpeed = nSize * 1.5f * 0.2f;
        float minSpeed = nSize * 1.0f * 0.2f;
        float overMin = v.length() - minSpeed;
        if (overMin > 0.0f) {
            float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
            if (durMult < 0.1f) {
                durMult = 0.1f;
            }
            dur *= 0.5f + 0.5f * durMult;
        }
        engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.25f / dur, 0.0f, dur, c);
    }

    @Override
    protected String getParticleSpriteCat() {
        return "dweller";
    }

    @Override
    protected String getParticleSpriteKey() {
        return "dweller_pieces";
    }

    @Override
    protected float getParticleScale() {
        return 2.5f * PARTICLE_SCALE_MULT;
    }

    @Override
    protected float getParticleScaleIncreaseRateMult() {
        return 1.5f;
    }

    @Override
    protected int getNumParticles() {
        return 2;
    }

    @Override
    public Color getParticleColor() {
        Color color = this.proj.getProjectileSpec().getFringeColor();
        color = Misc.setAlpha(color, 75);
        return color;
    }

    @Override
    protected String getLoopId() {
        return "pseudoparticle_jet_loop";
    }

    @Override
    protected float getThresholdDist() {
        return super.getThresholdDist();
    }

    @Override
    protected void playImpactSound(ApplyDamageResultAPI damageResult, Vector2f point, Vector2f vel) {
        Misc.playSound(damageResult, point, vel, "pseudoparticle_jet_hit_shield_light", "pseudoparticle_jet_hit_shield_solid", "pseudoparticle_jet_hit_shield_heavy", "pseudoparticle_jet_hit_light", "pseudoparticle_jet_hit_solid", "pseudoparticle_jet_hit_heavy");
    }
}

