/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedEjectaAI
implements ShipAIPlugin {
    public static float HULL_FRACTION_LOST_PER_SECOND = 0.0667f;
    protected ShipwideAIFlags flags = new ShipwideAIFlags();
    protected ShipAPI ship;
    protected boolean exploded = false;
    protected float turnDir = 1.0f;
    protected IntervalUtil updateInterval = new IntervalUtil(0.5f, 1.5f);

    public ShroudedEjectaAI(ShipAPI ship) {
        this.ship = ship;
        this.doInitialSetup();
        this.updateInterval.forceIntervalElapsed();
    }

    protected void doInitialSetup() {
        this.turnDir = Math.signum(0.5f - (float)Math.random() * 0.5f);
        if (this.turnDir == 0.0f) {
            this.turnDir = 1.0f;
        }
    }

    @Override
    public void advance(float amount) {
        this.updateInterval.advance(amount);
        this.updateInterval.intervalElapsed();
        CombatEngineAPI engine = Global.getCombatEngine();
        float damage = this.ship.getMaxHitpoints() * HULL_FRACTION_LOST_PER_SECOND * 1.0f * amount;
        this.ship.setHitpoints(this.ship.getHitpoints() - damage);
        if (this.ship.getHitpoints() <= 0.0f) {
            engine.applyDamage(this.ship, this.ship.getLocation(), 10000.0f, DamageType.ENERGY, 0.0f, true, false, this.ship, false);
        }
        this.giveMovementCommands();
    }

    protected void giveMovementCommands() {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship.getVelocity().length() > this.ship.getMaxSpeedWithoutBoost() * 0.1f) {
            this.ship.giveCommand(ShipCommand.DECELERATE, null, 0);
        }
        float heading = Misc.getAngleInDegrees(this.ship.getVelocity());
    }

    @Override
    public ShipwideAIFlags getAIFlags() {
        return this.flags;
    }

    @Override
    public void setDoNotFireDelay(float amount) {
    }

    @Override
    public void forceCircumstanceEvaluation() {
    }

    @Override
    public boolean needsRefit() {
        return false;
    }

    @Override
    public void cancelCurrentManeuver() {
    }

    @Override
    public ShipAIConfig getConfig() {
        return null;
    }

    public static class FlockingData {
        public Vector2f loc;
        public Vector2f vel;
        public float minA;
        public float maxA;
        public float minR;
        public float maxR;
        public float repelAtAngleDist;
        public float minC;
        public float maxC;
        public float attractWeight;
        public float repelWeight;
        public float cohesionWeight;
        public float facing;
    }
}

