/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.NegativeExplosionVisual;
import com.fs.starfarer.api.impl.combat.RiftCascadeMineExplosion;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.HumanShipShroudedHullmod;
import com.fs.starfarer.api.impl.combat.dweller.RiftLightningEffect;
import com.fs.starfarer.api.loading.DamagingExplosionSpec;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Iterator;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedLensHullmod
extends HumanShipShroudedHullmod {
    public static float MAX_RANGE = 400.0f;
    public static float RADIUS = 50.0f;
    public static float MIN_REFIRE_DELAY = 0.9f;
    public static float MAX_REFIRE_DELAY = 1.1f;
    public static float FLUX_PER_DAMAGE = 1.0f;
    public static float DAMAGE = 75.0f;
    public static float MIN_ROF_MULT = 1.0f;
    public static float MAX_ROF_MULT = 4.0f;
    public static String DATA_KEY = "core_ShroudedLensHullmod_data_key";

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("shrouded_lens", null), null);
    }

    public static ShroudedLensHullmodData getData(ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        String key = String.valueOf(DATA_KEY) + "_" + ship.getId();
        ShroudedLensHullmodData data = (ShroudedLensHullmodData)engine.getCustomData().get(key);
        if (data == null) {
            data = new ShroudedLensHullmodData();
            engine.getCustomData().put(key, data);
        }
        return data;
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        if (!ship.isAlive()) {
            return;
        }
        if (amount <= 0.0f) {
            return;
        }
        ShroudedLensHullmodData data = ShroudedLensHullmod.getData(ship);
        data.untilAttack -= amount * ShroudedLensHullmod.getRoF(ship.getHullSize());
        if (data.untilAttack <= 0.0f) {
            CombatEntityAPI target = this.findTarget(ship);
            if (target != null) {
                this.spawnExplosion(ship, target);
            }
            data.untilAttack = MIN_REFIRE_DELAY + (float)Math.random() * (MAX_REFIRE_DELAY - MIN_REFIRE_DELAY);
        }
    }

    public static float getPowerMult(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 1.0f;
            }
            case CRUISER: {
                return 0.6666667f;
            }
            case DESTROYER: {
                return 0.33333334f;
            }
            case FIGHTER: 
            case FRIGATE: {
                return 0.0f;
            }
        }
        return 1.0f;
    }

    public static float getRoF(ShipAPI.HullSize size) {
        float mult = ShroudedLensHullmod.getPowerMult(size);
        return MIN_ROF_MULT + (MAX_ROF_MULT - MIN_ROF_MULT) * mult;
    }

    public static float getFluxCost(ShipAPI.HullSize size) {
        return DAMAGE * FLUX_PER_DAMAGE;
    }

    public static float getDamage(ShipAPI.HullSize size) {
        return DAMAGE;
    }

    public void spawnExplosion(ShipAPI ship, CombatEntityAPI target) {
        float fluxCost;
        CombatEngineAPI engine = Global.getCombatEngine();
        float angle = Misc.getAngleInDegrees(target.getLocation(), ship.getLocation());
        Vector2f from = Misc.getUnitVectorAtDegreeAngle(angle += 45.0f - 90.0f * (float)Math.random());
        from.scale(10000.0f);
        float targetRadius = Misc.getTargetingRadius(from, target, false);
        Vector2f point = Misc.getUnitVector(target.getLocation(), from);
        point.scale(targetRadius * (0.8f + (float)Math.random() * 0.4f));
        Vector2f.add((Vector2f)target.getLocation(), (Vector2f)point, (Vector2f)point);
        float dist = Misc.getDistance(from, point);
        float damage = ShroudedLensHullmod.getDamage(ship.getHullSize());
        if (FLUX_PER_DAMAGE > 0.0f && !this.deductFlux(ship, fluxCost = ShroudedLensHullmod.getFluxCost(ship.getHullSize()))) {
            return;
        }
        DwellerShroud shroud = DwellerShroud.getShroudFor(ship);
        if (shroud != null) {
            angle = Misc.getAngleInDegrees(ship.getLocation(), point);
            from = Misc.getUnitVectorAtDegreeAngle(angle + 90.0f - 180.0f * (float)Math.random());
            from.scale((0.5f + (float)Math.random() * 0.25f) * shroud.getShroudParams().maxOffset * shroud.getShroudParams().overloadArcOffsetMult);
            Vector2f.add((Vector2f)ship.getLocation(), (Vector2f)from, (Vector2f)from);
        }
        Color color = RiftLightningEffect.RIFT_LIGHTNING_COLOR;
        if (shroud != null) {
            DwellerShroud.DwellerShroudParams shroudParams = shroud.getShroudParams();
            EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
            params.segmentLengthMult = 4.0f;
            params.glowSizeMult = 4.0f;
            params.flickerRateMult = 0.5f + (float)Math.random() * 0.5f;
            params.flickerRateMult *= 1.5f;
            Color fringe = color;
            Color core = Color.white;
            float thickness = shroudParams.overloadArcThickness;
            angle = Misc.getAngleInDegrees(from, ship.getLocation());
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle += 90.0f * ((float)Math.random() - 0.5f));
            dist = shroudParams.maxOffset * shroud.getShroudParams().overloadArcOffsetMult;
            dist = dist * 0.5f + dist * 0.5f * (float)Math.random();
            dir.scale(dist *= 0.5f);
            Vector2f to = Vector2f.add((Vector2f)from, (Vector2f)dir, (Vector2f)new Vector2f());
            EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, to, ship, thickness, fringe, core, params);
            arc.setCoreWidthOverride(shroudParams.overloadArcCoreThickness);
            arc.setSingleFlickerMode(false);
        }
        float explosionRadius = RADIUS;
        DamagingExplosionSpec spec = new DamagingExplosionSpec(0.1f, explosionRadius, explosionRadius * 0.5f, damage, damage, CollisionClass.PROJECTILE_NO_FF, CollisionClass.PROJECTILE_FIGHTER, 3.0f, 3.0f, 0.5f, 0, new Color(255, 255, 255, 0), new Color(255, 100, 100, 0));
        spec.setDamageType(DamageType.ENERGY);
        spec.setUseDetailedExplosion(false);
        spec.setSoundSetId("abyssal_glare_explosion");
        spec.setSoundVolume(0.33f);
        DamagingProjectileAPI explosion = engine.spawnDamagingExplosion(spec, ship, point);
        float baseSize = 7.0f;
        NegativeExplosionVisual.NEParams p = RiftCascadeMineExplosion.createStandardRiftParams(color, baseSize);
        p.noiseMult = 6.0f;
        p.thickness = 25.0f;
        p.fadeOut = 0.5f;
        p.spawnHitGlowAt = 1.0f;
        p.additiveBlend = true;
        p.blackColor = Color.white;
        p.underglow = null;
        p.withNegativeParticles = false;
        p.withHitGlow = false;
        p.fadeIn = 0.0f;
        RiftCascadeMineExplosion.spawnStandardRift(explosion, p);
        float thickness = 30.0f;
        Color coreColor = Color.white;
        coreColor = Misc.zeroColor;
        coreColor = color;
        color = new Color(255, 0, 30, 255);
        coreColor = new Color(255, 10, 255, 255);
        coreColor = color = DwellerShroud.SHROUD_GLOW_COLOR;
        float coreWidthMult = 1.0f;
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 4.0f;
        params.maxZigZagMult = 0.25f;
        params.zigZagReductionFactor = 1.0f;
        params.flickerRateMult = 0.75f + 0.25f * (float)Math.random();
        params.fadeOutDist = 150.0f;
        params.minFadeOutMult = 5.0f;
        params.glowSizeMult = 0.5f;
        Vector2f to = point;
        EmpArcEntityAPI arc = engine.spawnEmpArcVisual(from, ship, to, explosion, thickness, color, coreColor, params);
        arc.setCoreWidthOverride(thickness * coreWidthMult);
        arc.setSingleFlickerMode();
        arc.setRenderGlowAtStart(false);
        if (shroud != null) {
            arc.setFadedOutAtStart(true);
        }
        arc.setWarping(0.2f);
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addPara("The \"lens\" (in the loosest sense of the word) focuses on nearby objects, seemingly at random. Deals %s damage and generates %s flux.", opad, h, (int)ShroudedLensHullmod.getDamage(hullSize) + " Energy", "" + (int)ShroudedLensHullmod.getFluxCost(hullSize));
        tooltip.addPara("The rate of fire depends on the size of the ship the hullmod is installed on. Can not be turned off during combat operations, and continues to function even if the ship is venting flux or overloaded.", opad);
        if (isForModSpec || ship == null && !Global.CODEX_TOOLTIP_MODE) {
            return;
        }
        tooltip.setBgAlpha(0.9f);
        ShipAPI.HullSize[] sizes = new ShipAPI.HullSize[]{ShipAPI.HullSize.FRIGATE, ShipAPI.HullSize.DESTROYER, ShipAPI.HullSize.CRUISER, ShipAPI.HullSize.CAPITAL_SHIP};
        float rofW = 130.0f;
        float fluxW = 130.0f;
        float sizeW = width - rofW - fluxW - 10.0f;
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"Ship size", Float.valueOf(sizeW), "Attacks / sec", Float.valueOf(rofW), "Flux / sec", Float.valueOf(fluxW)});
        ShipAPI.HullSize[] hullSizeArray = sizes;
        int n = sizes.length;
        int n2 = 0;
        while (n2 < n) {
            ShipAPI.HullSize size = hullSizeArray[n2];
            float rof = ShroudedLensHullmod.getRoF(size);
            float flux = ShroudedLensHullmod.getFluxCost(size) * rof;
            Color c = Misc.getGrayColor();
            if (size == hullSize || Global.CODEX_TOOLTIP_MODE) {
                c = Misc.getHighlightColor();
            }
            tooltip.addRow(new Object[]{Alignment.MID, c, Misc.getHullSizeStr(size), Alignment.MID, c, "" + (int)Misc.getRoundedValueFloat(rof), Alignment.MID, c, "" + (int)Misc.getRoundedValueFloat(flux)});
            ++n2;
        }
        tooltip.addTable("", 0, opad);
        tooltip.addSpacer(5.0f);
        this.addCrewCasualties(tooltip, opad);
    }

    public CombatEntityAPI findTarget(ShipAPI ship) {
        float range = MAX_RANGE;
        Vector2f from = ship.getLocation();
        Iterator<Object> iter = Global.getCombatEngine().getAllObjectGrid().getCheckIterator(from, range * 2.0f, range * 2.0f);
        int owner = ship.getOwner();
        CombatEntityAPI best = null;
        float minScore = Float.MAX_VALUE;
        boolean ignoreFlares = false;
        WeightedRandomPicker<CombatEntityAPI> picker = new WeightedRandomPicker<CombatEntityAPI>();
        while (iter.hasNext()) {
            MissileAPI missile;
            ShipAPI otherShip;
            CombatEntityAPI other;
            Object o = iter.next();
            if (!(o instanceof MissileAPI) && !(o instanceof ShipAPI) || (other = (CombatEntityAPI)o).getOwner() == owner || other instanceof ShipAPI && ((otherShip = (ShipAPI)other).isPhased() || !otherShip.isTargetable()) || other.getCollisionClass() == CollisionClass.NONE || ignoreFlares && other instanceof MissileAPI && (missile = (MissileAPI)other).isFlare()) continue;
            float targetRadius = Misc.getTargetingRadius(from, other, false);
            float shipRadius = Misc.getTargetingRadius(other.getLocation(), ship, false);
            float dist = Misc.getDistance(from, other.getLocation()) - targetRadius - shipRadius;
            if (dist > range) continue;
            float score = dist;
            if (score < minScore) {
                minScore = score;
                best = other;
            }
            picker.add(other, 100.0f / Math.max(100.0f, score));
        }
        return (CombatEntityAPI)picker.pick();
    }

    public static class ShroudedLensHullmodData {
        float untilAttack = 0.0f;
        float sinceAttack = 1000.0f;
    }
}

