/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.dweller.BaseDwellerShipCreator;
import com.fs.starfarer.api.impl.combat.dweller.DwellerCombatPlugin;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShipPart;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedTendrilShipCreator
extends BaseDwellerShipCreator {
    public static float FLUX_COST_MULT = 0.33f;

    @Override
    public void initBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.initBeforeShipCreation(hullSize, stats, id);
        stats.getEnergyWeaponFluxCostMod().modifyMult(id, FLUX_COST_MULT);
        stats.getBallisticWeaponFluxCostMod().modifyMult(id, FLUX_COST_MULT);
        stats.getMissileWeaponFluxCostMod().modifyMult(id, FLUX_COST_MULT);
    }

    @Override
    protected DwellerCombatPlugin createPlugin(final ShipAPI ship) {
        DwellerCombatPlugin plugin = super.createPlugin(ship);
        plugin.setPlugin(new DwellerCombatPlugin.DCPPlugin(){
            IntervalUtil interval = new IntervalUtil(0.5f, 1.5f);
            boolean anythingLargerNearby = false;

            @Override
            public void advance(DwellerCombatPlugin plugin, float amount) {
                CombatFleetManagerAPI fleetManager;
                this.interval.advance(amount);
                if (this.interval.intervalElapsed() && (fleetManager = Global.getCombatEngine().getFleetManager(ship.getOriginalOwner())) != null) {
                    this.anythingLargerNearby = false;
                    for (DeployedFleetMemberAPI curr : fleetManager.getDeployedCopyDFM()) {
                        if (curr.getShip() == null || curr.getShip().getHullSize().ordinal() <= ship.getHullSize().ordinal()) continue;
                        float dist = Misc.getDistance(ship.getLocation(), curr.getLocation());
                        if (!((dist -= ship.getCollisionRadius() + curr.getShip().getCollisionRadius()) < 3000.0f)) continue;
                        this.anythingLargerNearby = true;
                        break;
                    }
                }
                if (ship.getSinceLastDamageTaken() < 0.5f && this.anythingLargerNearby) {
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF, 1.0f);
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE, 1.0f, Float.valueOf(2000.0f));
                    ship.getAIFlags().unsetFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF);
                } else {
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF, 1.0f);
                    ship.getAIFlags().unsetFlag(ShipwideAIFlags.AIFlags.BACK_OFF);
                    ship.getAIFlags().unsetFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE);
                }
            }
        });
        List<DwellerShipPart> parts = plugin.getParts();
        parts.clear();
        float scale = 1.0f;
        scale = 0.75f;
        DwellerCombatPlugin.WobblyPart part = new DwellerCombatPlugin.WobblyPart("shrouded_tendril_base", 2.0f * scale, 1.0f, new Vector2f(0.0f, 0.0f), 0.0f);
        parts.add(part);
        Color glow = DwellerCombatPlugin.STANDARD_PART_GLOW_COLOR;
        part = new DwellerCombatPlugin.WobblyPart("clusterB", 1.0f * scale, 3, 3, 2.0f, new Vector2f(30.0f * scale, 0.0f), 0.0f);
        part.color = glow;
        part.additiveBlend = true;
        parts.add(part);
        return plugin;
    }

    @Override
    protected void modifyBaselineShroudParams(ShipAPI ship, DwellerShroud.DwellerShroudParams params) {
        params.maxOffset = 80.0f;
        params.initialMembers = 25;
        params.baseMembersToMaintain = params.initialMembers = 70;
        params.flashFrequency /= 2.0f;
        params.negativeParticleAreaMult = 1.25f;
        params.overloadGlowSizeMult *= 0.75f;
    }
}

