/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.dweller.ShroudedVortexShipCreator;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShroudedVortexAI
implements ShipAIPlugin {
    public static float HULL_FRACTION_LOST_PER_SECOND = 0.05f;
    public static String VORTEX_FLOCKING = "vortex_flocking";
    public static float ATTRACTOR_RANGE_MAX = 2000.0f;
    public static float COHESION_RANGE_MIN = 150.0f;
    public static float COHESION_RANGE_MAX = 300.0f;
    public static float REPEL_RANGE_MIN = 0.0f;
    public static float REPEL_RANGE_MAX = 400.0f;
    protected ShipwideAIFlags flags = new ShipwideAIFlags();
    protected ShipAPI ship;
    protected boolean exploded = false;
    protected Vector2f prevVel = null;
    protected IntervalUtil updateInterval = new IntervalUtil(0.5f, 1.5f);
    protected IntervalUtil headingInterval = new IntervalUtil(0.5f, 1.5f);
    protected ShipAPI target = null;
    protected float timeOnTarget = 0.0f;
    protected float numCollisions = 0.0f;
    protected List<FlockingData> flockingData = new ArrayList<FlockingData>();
    protected float desiredHeading = 0.0f;

    public ShroudedVortexAI(ShipAPI ship) {
        this.ship = ship;
        this.doInitialSetup();
        this.updateInterval.forceIntervalElapsed();
    }

    protected void doInitialSetup() {
        this.ship.addTag(VORTEX_FLOCKING);
    }

    protected void toggleOn(int groupNum) {
        List<WeaponGroupAPI> groups = this.ship.getWeaponGroupsCopy();
        if (groups.size() <= groupNum) {
            return;
        }
        groups.get(groupNum).toggleOn();
    }

    protected void toggleOff(int groupNum) {
        List<WeaponGroupAPI> groups = this.ship.getWeaponGroupsCopy();
        if (groups.size() <= groupNum) {
            return;
        }
        groups.get(groupNum).toggleOff();
    }

    @Override
    public void advance(float amount) {
        ShipAPI sourceShip;
        float delta;
        if (this.target != null) {
            this.timeOnTarget += amount;
        }
        this.updateInterval.advance(amount);
        if (this.updateInterval.intervalElapsed()) {
            ShipAPI prev = this.target;
            this.target = this.findTarget();
            if (prev != this.target) {
                this.timeOnTarget = 0.0f;
            }
            this.updateFlockingData();
        }
        this.headingInterval.advance(amount * 5.0f);
        if (this.headingInterval.intervalElapsed()) {
            this.computeDesiredHeading();
        }
        if (this.prevVel != null && (delta = Vector2f.sub((Vector2f)this.prevVel, (Vector2f)this.ship.getVelocity(), (Vector2f)new Vector2f()).length()) > this.ship.getMaxSpeedWithoutBoost() * 0.25f) {
            this.ship.getVelocity().scale(0.1f);
            this.numCollisions += 1.0f;
        }
        this.prevVel = new Vector2f((ReadableVector2f)this.ship.getVelocity());
        CombatEngineAPI engine = Global.getCombatEngine();
        DwellerShroud shroud = DwellerShroud.getShroudFor(this.ship);
        if (shroud != null && (sourceShip = (ShipAPI)shroud.custom1) != null) {
            float dist = Misc.getDistance(this.ship.getLocation(), sourceShip.getLocation());
            if (dist > this.ship.getCollisionRadius() + sourceShip.getCollisionRadius() * 0.75f) {
                this.ship.setCollisionClass(CollisionClass.SHIP);
            } else {
                this.ship.setCollisionClass(CollisionClass.FIGHTER);
            }
        }
        float damage = this.ship.getMaxHitpoints() * HULL_FRACTION_LOST_PER_SECOND * (1.0f + this.numCollisions) * amount;
        this.ship.setHitpoints(this.ship.getHitpoints() - damage);
        if (this.ship.getHitpoints() <= 0.0f) {
            engine.applyDamage(this.ship, this.ship.getLocation(), 10000.0f, DamageType.ENERGY, 0.0f, true, false, this.ship, false);
        }
        this.giveMovementCommands();
    }

    protected void giveMovementCommands() {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship.hasTag(ShroudedVortexShipCreator.TAG_MIRRORED_VORTEX)) {
            this.ship.giveCommand(ShipCommand.TURN_RIGHT, null, 0);
        } else {
            this.ship.giveCommand(ShipCommand.TURN_LEFT, null, 0);
        }
        float heading = Misc.getAngleInDegrees(this.ship.getVelocity());
        if (this.target != null) {
            float speed = (this.ship.getVelocity().length() + this.ship.getMaxSpeed()) * 0.5f;
            Vector2f point = engine.getAimPointWithLeadForAutofire(this.ship, 1.0f, this.target, speed);
            heading = Misc.getAngleInDegrees(this.ship.getLocation(), point);
        }
        engine.headInDirectionWithoutTurning(this.ship, this.desiredHeading, 10000.0f);
    }

    @Override
    public ShipwideAIFlags getAIFlags() {
        return this.flags;
    }

    public ShipAPI findTarget() {
        float range = 5000.0f;
        float goodRange = this.ship.getHullLevel() / HULL_FRACTION_LOST_PER_SECOND * this.ship.getMaxSpeed() * 0.75f;
        Vector2f from = this.ship.getLocation();
        CombatEngineAPI engine = Global.getCombatEngine();
        Iterator<Object> iter = engine.getShipGrid().getCheckIterator(from, range * 2.0f, range * 2.0f);
        int owner = this.ship.getOwner();
        float currAngle = Misc.getAngleInDegrees(this.ship.getVelocity());
        WeightedRandomPicker<ShipAPI> good = new WeightedRandomPicker<ShipAPI>();
        WeightedRandomPicker<ShipAPI> lessGood = new WeightedRandomPicker<ShipAPI>();
        while (iter.hasNext()) {
            float minus;
            float dist;
            ShipAPI other;
            Object o = iter.next();
            if (!(o instanceof ShipAPI) || (other = (ShipAPI)o) == this.ship || other.getOwner() == owner || other.isHulk() || other.isPhased() || !engine.isAwareOf(owner, other) && other.getCollisionClass() == CollisionClass.NONE || (dist = Misc.getDistance(from, other.getLocation())) > range) continue;
            float score = 1.0f;
            if (other.isFrigate()) {
                score = 11.0f;
            } else if (other.isDestroyer()) {
                score = 15.0f;
            } else if (other.isCruiser() || other.isCapital()) {
                score = 25.0f;
            }
            float angleToOther = Misc.getAngleInDegrees(this.ship.getLocation(), other.getLocation());
            float angleDiff = Misc.getAngleDiff(currAngle, angleToOther);
            float f = angleDiff / 90.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            if ((minus = 5.0f * dist / 5000.0f) > 5.0f) {
                minus = 3.0f;
            }
            score -= minus;
            score -= f * 5.0f;
            if (dist > goodRange) {
                lessGood.add(other, score);
                continue;
            }
            good.add(other, score);
        }
        if (this.target != null) {
            if (good.getItems().contains(this.target)) {
                return this.target;
            }
            if (lessGood.getItems().contains(this.target) && good.isEmpty()) {
                return this.target;
            }
        }
        if (!good.isEmpty()) {
            return (ShipAPI)good.pick();
        }
        return (ShipAPI)lessGood.pick();
    }

    protected void updateFlockingData() {
        this.flockingData.clear();
        CombatEngineAPI engine = Global.getCombatEngine();
        int owner = this.ship.getOriginalOwner();
        Vector2f loc = this.ship.getLocation();
        float radius = this.ship.getCollisionRadius() * 1.0f;
        if (this.target != null) {
            float dist = Misc.getDistance(this.ship.getLocation(), this.target.getLocation());
            FlockingData data = new FlockingData();
            data.facing = this.target.getFacing();
            data.loc = this.target.getLocation();
            data.vel = this.target.getVelocity();
            data.attractWeight = 100.0f;
            if (dist - this.ship.getCollisionRadius() - this.target.getCollisionRadius() < 500.0f) {
                data.attractWeight *= 10.0f;
            }
            data.repelWeight = 0.0f;
            data.minA = 0.0f;
            data.maxA = 1000000.0f;
            data.minR = 0.0f;
            data.maxR = 0.0f;
            data.repelAtAngleDist = 0.0f;
            this.flockingData.add(data);
        }
        for (ShipAPI curr : engine.getShips()) {
            FlockingData data;
            if (curr == this.ship || curr.getOwner() != owner || curr.isHulk() || curr.getOwner() == 100) continue;
            float currRadius = curr.getCollisionRadius();
            if (curr.hasTag(VORTEX_FLOCKING)) {
                data = new FlockingData();
                data.facing = Misc.getAngleInDegrees(curr.getVelocity());
                data.loc = curr.getLocation();
                data.vel = curr.getVelocity();
                data.repelWeight = 100.0f;
                data.cohesionWeight = 1.0f;
                data.attractWeight = 3.0f;
                data.minA = 0.0f + radius + currRadius;
                data.maxA = ATTRACTOR_RANGE_MAX + radius + currRadius;
                data.minR = REPEL_RANGE_MIN + radius + currRadius;
                data.maxR = REPEL_RANGE_MAX + radius + currRadius;
                data.minC = COHESION_RANGE_MIN + radius + currRadius;
                data.maxC = COHESION_RANGE_MAX + radius + currRadius;
                this.flockingData.add(data);
                continue;
            }
            if (curr.isFighter()) continue;
            data = new FlockingData();
            data.facing = Misc.getAngleInDegrees(curr.getVelocity());
            data.loc = curr.getLocation();
            data.vel = curr.getVelocity();
            data.attractWeight = 0.0f;
            data.cohesionWeight = 0.0f;
            data.repelWeight = 100.0f;
            data.minA = 0.0f;
            data.maxA = 0.0f;
            data.minR = REPEL_RANGE_MIN * 0.5f + radius + currRadius;
            data.maxR = REPEL_RANGE_MAX * 0.5f + radius + currRadius;
            data.minC = 0.0f;
            data.maxC = 0.0f;
            this.flockingData.add(data);
        }
    }

    protected void computeDesiredHeading() {
        Vector2f loc = this.ship.getLocation();
        Vector2f vel = this.ship.getVelocity();
        float facing = this.ship.getFacing();
        Vector2f total = new Vector2f();
        for (FlockingData curr : this.flockingData) {
            Vector2f dir;
            float dist = Misc.getDistance(curr.loc, loc);
            if (curr.maxR > 0.0f && dist < curr.maxR) {
                float repelWeight = curr.repelWeight;
                if (dist > curr.minR && curr.maxR > curr.minR) {
                    repelWeight = (dist - curr.minR) / (curr.maxR - curr.minR);
                    if (repelWeight > 1.0f) {
                        repelWeight = 1.0f;
                    }
                    repelWeight = 1.0f - repelWeight;
                    repelWeight *= curr.repelWeight;
                }
                dir = Misc.getUnitVector(curr.loc, loc);
                float distIntoRepel = curr.maxR - dist;
                float repelAdjustmentAngle = 0.0f;
                if (distIntoRepel < curr.repelAtAngleDist && curr.repelAtAngleDist > 0.0f) {
                    float repelMult = 1.0f - distIntoRepel / curr.repelAtAngleDist;
                    repelAdjustmentAngle = 90.0f * repelMult;
                    repelWeight *= 1.0f - repelMult;
                    float repelAngle = Misc.getAngleInDegrees(dir);
                    float turnDir = Misc.getClosestTurnDirection(dir, vel);
                    dir = Misc.getUnitVectorAtDegreeAngle(repelAngle + (repelAdjustmentAngle *= turnDir));
                }
                dir.scale(repelWeight);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (curr.maxA > 0.0f && dist < curr.maxA) {
                float attractWeight = curr.attractWeight;
                if (dist > curr.minA && curr.maxA > curr.minA) {
                    attractWeight = (dist - curr.minA) / (curr.maxA - curr.minA);
                    if (attractWeight > 1.0f) {
                        attractWeight = 1.0f;
                    }
                    attractWeight = 1.0f - attractWeight;
                    attractWeight *= curr.attractWeight;
                }
                dir = Misc.getUnitVector(loc, curr.loc);
                dir.scale(attractWeight);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (!(curr.maxC > 0.0f) || !(dist < curr.maxC)) continue;
            float cohesionWeight = curr.cohesionWeight;
            if (dist > curr.minC && curr.maxC > curr.minC) {
                cohesionWeight = (dist - curr.minC) / (curr.maxC - curr.minC);
                if (cohesionWeight > 1.0f) {
                    cohesionWeight = 1.0f;
                }
                cohesionWeight = 1.0f - cohesionWeight;
                cohesionWeight *= curr.cohesionWeight;
            }
            dir = new Vector2f((ReadableVector2f)curr.vel);
            Misc.normalise(dir);
            dir.scale(cohesionWeight);
            Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
        }
        this.desiredHeading = total.length() <= 0.0f ? this.ship.getFacing() : Misc.getAngleInDegrees(total);
    }

    @Override
    public void setDoNotFireDelay(float amount) {
    }

    @Override
    public void forceCircumstanceEvaluation() {
    }

    @Override
    public boolean needsRefit() {
        return false;
    }

    @Override
    public void cancelCurrentManeuver() {
    }

    @Override
    public ShipAIConfig getConfig() {
        return null;
    }

    public static class FlockingData {
        public Vector2f loc;
        public Vector2f vel;
        public float minA;
        public float maxA;
        public float minR;
        public float maxR;
        public float repelAtAngleDist;
        public float minC;
        public float maxC;
        public float attractWeight;
        public float repelWeight;
        public float cohesionWeight;
        public float facing;
    }
}

