/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.dweller.TenebrousExpulsionSystemScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class TenebrousExpulsionSystemAI
implements ShipSystemAIScript {
    public static float HULL_LOSS_FOR_ACTIVATION = 0.25f;
    protected ShipAPI ship;
    protected CombatEngineAPI engine;
    protected ShipwideAIFlags flags;
    protected ShipSystemAPI system;
    protected TenebrousExpulsionSystemScript script;
    protected IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);
    protected float hullLevelAtPrevSystemUse = 1.0f;
    protected float prevHardFluxLevel = 0.0f;

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
        this.system = system;
        this.script = (TenebrousExpulsionSystemScript)system.getScript();
    }

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.ship == null) {
            return;
        }
        this.tracker.advance(amount);
        boolean forceUse = false;
        if (this.ship.getFluxLevel() > 0.95f && this.ship.getHullLevel() > 0.25f && this.ship.getShield() != null && this.ship.getShield().isOn()) {
            forceUse = true;
        }
        if (this.tracker.intervalElapsed() || forceUse) {
            boolean useSystem;
            if (this.system.getCooldownRemaining() > 0.0f) {
                return;
            }
            if (this.system.isOutOfAmmo()) {
                return;
            }
            if (this.system.isActive()) {
                return;
            }
            if (this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            float hullLevel = this.ship.getHullLevel();
            float hardFluxLevel = this.ship.getHardFluxLevel();
            float fluxLevel = this.ship.getFluxLevel();
            boolean bl = useSystem = hullLevel <= this.hullLevelAtPrevSystemUse - HULL_LOSS_FOR_ACTIVATION;
            if ((hardFluxLevel >= this.prevHardFluxLevel && hardFluxLevel >= 0.33f || fluxLevel > 0.65f) && this.ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) && target != null) {
                float dist = Misc.getDistance(this.ship.getLocation(), target.getLocation());
                if ((dist -= this.ship.getCollisionRadius() + target.getCollisionRadius()) < 1000.0f || hardFluxLevel > this.prevHardFluxLevel + 0.02f) {
                    useSystem = true;
                }
            }
            this.prevHardFluxLevel = hardFluxLevel;
            if (useSystem |= forceUse) {
                float angle = this.ship.getFacing();
                if (target != null) {
                    angle = Misc.getAngleInDegrees(this.ship.getLocation(), target.getLocation());
                }
                if (missileDangerDir != null) {
                    float angle2 = Misc.getAngleInDegrees(missileDangerDir);
                    angle = target != null ? (angle += Misc.getClosestTurnDirection(angle, angle2) * 0.5f * Misc.getAngleDiff(angle, angle2)) : angle2;
                }
                Vector2f point = Misc.getUnitVectorAtDegreeAngle(angle);
                point.scale(2000.0f);
                Vector2f.add((Vector2f)point, (Vector2f)this.ship.getLocation(), (Vector2f)point);
                this.giveCommand(point);
                this.hullLevelAtPrevSystemUse = hullLevel;
                return;
            }
        }
    }

    public void giveCommand(Vector2f target) {
        if (this.ship.getAIFlags() != null) {
            this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.SYSTEM_TARGET_COORDS, 1.0f, target);
        }
        this.ship.giveCommand(ShipCommand.USE_SYSTEM, null, 0);
    }
}

