/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class AttackSwarmPhaseModeScript
extends BaseEveryFrameCombatPlugin {
    public static float DURATION = 20.0f;
    protected float timeLeft = 0.0f;
    protected ShipAPI ship;
    protected Color origColor = Misc.setAlpha(VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR, 60);
    protected float origRadius = 120.0f;
    protected float origFlashFrequency = 1.0f;
    protected float origFlashRateMult = 1.0f;
    protected float glowFadeDelay = 2.0f;

    public AttackSwarmPhaseModeScript(ShipAPI ship) {
        this(ship, DURATION);
    }

    public AttackSwarmPhaseModeScript(ShipAPI ship, float dur) {
        this.ship = ship;
        this.timeLeft = dur;
        this.turnOnPhaseMode();
        Global.getCombatEngine().addPlugin(this);
    }

    public void turnOnPhaseMode() {
        Color color;
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
        if (swarm == null) {
            return;
        }
        this.origColor = swarm.params.flashFringeColor;
        this.origRadius = swarm.params.flashRadius;
        this.origFlashFrequency = swarm.params.flashFrequency;
        this.origFlashRateMult = swarm.params.flashRateMult;
        swarm.params.flashFringeColor = color = Misc.setAlpha(VoltaicDischargeOnFireEffect.PHASE_FRINGE_COLOR, 60);
        swarm.params.flashRadius = 180.0f;
        swarm.params.tags.add(VoltaicDischargeOnFireEffect.SWARM_TAG_PHASE_MODE);
        for (WeaponAPI w : this.ship.getAllWeapons()) {
            if (w.usesAmmo() && w.getSpec().hasTag("fragment_glow")) {
                w.setAmmo(1000);
            }
            if (!w.getSpec().hasTag("overseer_charge") && (!this.ship.isFighter() || !w.getSpec().hasTag("overseer_charge_fighter"))) continue;
            w.setAmmo(w.getMaxAmmo());
        }
    }

    public void turnOffPhaseMode() {
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
        if (swarm == null) {
            return;
        }
        swarm.params.flashFringeColor = this.origColor;
        swarm.params.flashRadius = this.origRadius;
        swarm.params.flashFrequency = this.origFlashFrequency;
        swarm.params.flashRateMult = this.origFlashRateMult;
        swarm.params.tags.remove(VoltaicDischargeOnFireEffect.SWARM_TAG_PHASE_MODE);
        for (WeaponAPI w : this.ship.getAllWeapons()) {
            if (!w.usesAmmo() || !w.getSpec().hasTag("fragment_glow")) continue;
            w.setAmmo(w.getMaxAmmo());
        }
    }

    public void suppressGlow() {
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
        if (swarm != null) {
            swarm.params.flashFrequency = 0.0f;
            swarm.params.flashRateMult = 1.0f;
        }
        for (WeaponAPI w : this.ship.getAllWeapons()) {
            if (!w.usesAmmo() || !w.getSpec().hasTag("fragment_glow")) continue;
            w.setAmmo(0);
        }
    }

    @Override
    public void advance(float amount, List<InputEventAPI> events) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.timeLeft -= amount;
        if (this.timeLeft <= 0.0f) {
            this.glowFadeDelay -= amount;
            this.suppressGlow();
            if (this.glowFadeDelay <= 0.0f) {
                this.turnOffPhaseMode();
                CombatEngineAPI engine = Global.getCombatEngine();
                engine.removePlugin(this);
            }
        }
    }
}

