/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.GuidedMissileAI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.FragmentWeapon;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.LinkedHashSet;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BaseFragmentMissileEffect
implements OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin,
FragmentWeapon {
    protected DamagingProjectileAPI projectile;
    protected WeaponAPI weapon;
    protected CombatEngineAPI engine;
    protected RoilingSwarmEffect sourceSwarm;
    protected MissileAPI missile;
    protected ShipAPI ship;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return;
        }
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        int active = swarm == null ? 0 : swarm.getNumActiveMembers();
        int required = this.getNumFragmentsToFire();
        boolean disable = active < required;
        weapon.setForceDisabled(disable);
        this.showNoFragmentSwarmWarning(weapon, ship);
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, final CombatEngineAPI engine) {
        int transfer;
        this.projectile = projectile;
        this.weapon = weapon;
        this.engine = engine;
        if (!(projectile instanceof MissileAPI)) {
            engine.removeEntity(projectile);
            return;
        }
        this.missile = (MissileAPI)projectile;
        if (this.missile.getSource() == null) {
            engine.removeEntity(projectile);
            return;
        }
        this.ship = this.missile.getSource();
        this.sourceSwarm = RoilingSwarmEffect.getSwarmFor(this.missile.getSource());
        if (this.sourceSwarm == null) {
            engine.removeEntity(projectile);
            return;
        }
        this.missile.setEmpResistance(this.getEMPResistance());
        final RoilingSwarmEffect.SwarmMember fragment = this.pickPrimaryFragment();
        if (fragment == null) {
            engine.removeEntity(projectile);
            return;
        }
        if (this.missile.getWeapon() == null || !this.missile.getWeapon().hasAIHint(WeaponAPI.AIHints.RANGE_FROM_SHIP_RADIUS)) {
            this.missile.setStart(new Vector2f((ReadableVector2f)this.missile.getLocation()));
        }
        this.missile.getLocation().set((ReadableVector2f)fragment.loc);
        if (!this.shouldPickVelocityMatchingPrimaryFragment()) {
            GuidedMissileAI ai;
            this.missile.getVelocity().set((ReadableVector2f)fragment.vel);
            boolean setFacing = false;
            if (this.shouldMakeMissileFaceTargetOnSpawnIfAny() && this.missile.getAI() instanceof GuidedMissileAI && (ai = (GuidedMissileAI)this.missile.getAI()).getTarget() != null) {
                this.missile.setFacing(Misc.getAngleInDegrees(fragment.loc, ai.getTarget().getLocation()));
                setFacing = true;
            }
            if (!setFacing && fragment.vel.length() > 0.1f) {
                this.missile.setFacing(Misc.getAngleInDegrees(fragment.vel));
            }
        }
        RoilingSwarmEffect.RoilingSwarmParams params = new RoilingSwarmEffect.RoilingSwarmParams();
        params.despawnSound = null;
        params.maxSpeed = this.missile.getMaxSpeed() + 100.0f;
        params.baseMembersToMaintain = 0;
        params.removeMembersAboveMaintainLevel = false;
        params.keepProxBasedScaleForAllMembers = true;
        params.initialMembers = 0;
        params.maxOffset = this.missile.getCollisionRadius() * 1.5f;
        this.configureMissileSwarmParams(params);
        final MissileAPI missile2 = this.missile;
        final FragmentBehaviorOnImpact behavior = this.getOtherFragmentBehaviorOnImpact();
        final boolean explodeOnFizzling = this.explodeOnFizzling();
        final String explosionSoundId = this.getExplosionSoundId();
        RoilingSwarmEffect missileSwarm = new RoilingSwarmEffect(missile2, params){
            boolean exploded;
            Set<RoilingSwarmEffect.SwarmMember> stopped;
            int origMembers;
            boolean inited;
            {
                super($anonymous0, $anonymous1);
                this.exploded = false;
                this.stopped = new LinkedHashSet<RoilingSwarmEffect.SwarmMember>();
                this.origMembers = 0;
                this.inited = false;
            }

            @Override
            public void advance(float amount) {
                super.advance(amount);
                if (BaseFragmentMissileEffect.this.removeFragmentsWhenMissileLosesHitpoints() && !missile2.didDamage()) {
                    if (!this.inited) {
                        this.origMembers = this.members.size();
                        this.inited = true;
                    }
                    if (this.origMembers > 0 && this.members.size() > 1 && missile2.getMaxHitpoints() > 0.0f) {
                        float max = missile2.getMaxHitpoints();
                        float hpPerMember = max / (float)this.origMembers;
                        float hpLost = max - missile2.getHitpoints();
                        int loseMembers = (int)(hpLost / hpPerMember);
                        int num = this.members.size();
                        int alreadyLost = this.origMembers - num;
                        for (RoilingSwarmEffect.SwarmMember p : this.members) {
                            if (!p.fader.isFadingOut()) continue;
                            ++alreadyLost;
                        }
                        int lose = loseMembers - alreadyLost;
                        if (lose > 0) {
                            this.despawnMembers(lose, false);
                        }
                    }
                }
                fragment.loc.set((ReadableVector2f)missile2.getLocation());
                fragment.vel.set((ReadableVector2f)missile2.getVelocity());
                if (missile2.isFizzling() && engine.isMissileAlive(missile2)) {
                    fragment.fader.setBrightness(missile2.getCurrentBaseAlpha());
                }
                if (missile2.didDamage() && behavior != FragmentBehaviorOnImpact.KEEP_GOING) {
                    CombatEntityAPI target = null;
                    if (missile2.getDamageTarget() instanceof CombatEntityAPI) {
                        target = missile2.getDamageTarget();
                    }
                    for (RoilingSwarmEffect.SwarmMember p : this.members) {
                        if (p == fragment || this.stopped.contains(p)) continue;
                        boolean hit = false;
                        if (target != null && target.getExactBounds() != null) {
                            boolean inArc;
                            ShipAPI ship;
                            if (target instanceof ShipAPI && (ship = (ShipAPI)target).getShield() != null && (inArc = ship.getShield().isWithinArc(p.loc))) {
                                boolean bl = hit = Misc.getDistance(p.loc, ship.getShieldCenterEvenIfNoShield()) < ship.getShieldRadiusEvenIfNoShield();
                            }
                            if (!hit) {
                                hit = target.isPointInBounds(p.loc);
                            }
                        } else {
                            Vector2f toP = Vector2f.sub((Vector2f)p.loc, (Vector2f)fragment.loc, (Vector2f)new Vector2f());
                            boolean bl = hit = Vector2f.dot((Vector2f)toP, (Vector2f)fragment.vel) > 0.0f;
                        }
                        if (!hit) continue;
                        p.vel.set((ReadableVector2f)new Vector2f());
                        if (behavior == FragmentBehaviorOnImpact.STOP_AND_FLASH) {
                            p.flash();
                        }
                        BaseFragmentMissileEffect.this.reportFragmentHit(missile2, p, this, target);
                        this.stopped.add(p);
                    }
                }
                if (explodeOnFizzling && explosionSoundId != null && (missile2.isFizzling() || missile2.getHitpoints() <= 0.0f && !missile2.didDamage()) && !this.exploded) {
                    this.exploded = true;
                    Global.getSoundPlayer().playSound(explosionSoundId, 1.0f, 1.0f, missile2.getLocation(), missile2.getVelocity());
                    missile2.interruptContrail();
                    engine.removeEntity(missile2);
                    missile2.explode();
                }
                if ((missile2.isFizzling() || missile2.getHitpoints() <= 0.0f) && !missile2.didDamage() && !this.exploded) {
                    this.params.minDespawnTime = 0.5f;
                    this.params.maxDespawnTime = 1.0f;
                    this.params.minFadeoutTime = 0.5f;
                    this.params.maxFadeoutTime = 1.0f;
                    this.setForceDespawn(true);
                }
                BaseFragmentMissileEffect.this.swarmAdvance(amount, missile2, this);
            }
        };
        this.sourceSwarm.removeMember(fragment);
        missileSwarm.addMember(fragment);
        fragment.rollOffset(missileSwarm.params, this.missile);
        if (this.makePrimaryFragmentGlow()) {
            if (fragment.flash != null) {
                fragment.flash = null;
            }
            fragment.flashNext = null;
            fragment.flash();
            fragment.flash.setBounceDown(false);
        }
        if ((transfer = this.getNumOtherMembersToTransfer()) > 0) {
            this.sourceSwarm.transferMembersTo(missileSwarm, transfer, fragment.loc, this.getRangeForNearbyFragments());
        }
        int add = this.getNumOtherMembersToAdd();
        if (this.addNewMembersIfNotEnoughToTransfer() && missileSwarm.members.size() - 1 < transfer) {
            add += transfer - (missileSwarm.members.size() - 1);
        }
        if (add > 0) {
            missileSwarm.addMembers(add);
        }
        this.swarmCreated(this.missile, missileSwarm, this.sourceSwarm);
        float hpLoss = this.getHPLossPerTransferredMember();
        hpLoss *= (float)(1 + transfer);
        if (hpLoss > 0.0f) {
            this.ship.setHitpoints(this.ship.getHitpoints() - hpLoss);
            if (this.ship.getHitpoints() <= 0.0f) {
                this.ship.setSpawnDebris(false);
                engine.applyDamage(this.ship, this.ship.getLocation(), 100.0f, DamageType.ENERGY, 0.0f, true, false, this.missile, false);
            }
        }
        if (this.withEMPArc()) {
            this.spawnEMPArc();
        }
    }

    protected void swarmCreated(MissileAPI missile, RoilingSwarmEffect missileSwarm, RoilingSwarmEffect sourceSwarm) {
    }

    protected void reportFragmentHit(MissileAPI missile, RoilingSwarmEffect.SwarmMember p, RoilingSwarmEffect swarm, CombatEntityAPI target) {
    }

    protected float getHPLossPerTransferredMember() {
        if (!this.ship.isFighter()) {
            return 0.0f;
        }
        float hpLoss = this.ship.getMaxHitpoints() / ((float)this.sourceSwarm.params.baseMembersToMaintain * 0.8f);
        return hpLoss;
    }

    protected void configureMissileSwarmParams(RoilingSwarmEffect.RoilingSwarmParams params) {
        params.flashFringeColor = new Color(255, 50, 50, 255);
        params.flashCoreColor = Color.white;
        params.flashRadius = 60.0f;
        params.flashCoreRadiusMult = 0.75f;
    }

    protected boolean shouldPickVelocityMatchingPrimaryFragment() {
        if (this.missile.getAI() instanceof GuidedMissileAI) {
            GuidedMissileAI ai = (GuidedMissileAI)this.missile.getAI();
            return ai.getTarget() == null;
        }
        return true;
    }

    protected boolean shouldMakeMissileFaceTargetOnSpawnIfAny() {
        return false;
    }

    protected RoilingSwarmEffect.SwarmMember pickPrimaryFragment() {
        if (this.shouldPickVelocityMatchingPrimaryFragment()) {
            return this.pickVelocityMatchingFragmentWithinRange(this.getRangeFromSourceToPickFragments());
        }
        return this.pickOuterFragmentWithinRange(this.getRangeFromSourceToPickFragments());
    }

    protected RoilingSwarmEffect.SwarmMember pickOuterFragmentWithinRange(float range) {
        RoilingSwarmEffect.SwarmMember best = null;
        float maxDist = -3.4028235E38f;
        WeightedRandomPicker<RoilingSwarmEffect.SwarmMember> picker = this.sourceSwarm.getPicker(true, true);
        while (!picker.isEmpty()) {
            RoilingSwarmEffect.SwarmMember p = picker.pickAndRemove();
            float dist = Misc.getDistance(p.loc, this.sourceSwarm.getAttachedTo().getLocation());
            if (this.sourceSwarm.params.generateOffsetAroundAttachedEntityOval) {
                dist -= Misc.getTargetingRadius(p.loc, this.sourceSwarm.attachedTo, false) + this.sourceSwarm.params.maxOffset - range * 0.5f;
            }
            if (!(dist > maxDist) || !(dist < range)) continue;
            best = p;
            maxDist = dist;
        }
        return best;
    }

    protected RoilingSwarmEffect.SwarmMember pickVelocityMatchingFragmentWithinRange(float range) {
        Vector2f vel = this.missile.getVelocity();
        RoilingSwarmEffect.SwarmMember best = null;
        float maxVelDiff = 0.0f;
        WeightedRandomPicker<RoilingSwarmEffect.SwarmMember> picker = this.sourceSwarm.getPicker(true, true);
        while (!picker.isEmpty()) {
            float velDiff;
            RoilingSwarmEffect.SwarmMember p = picker.pickAndRemove();
            float dist = Misc.getDistance(p.loc, this.sourceSwarm.getAttachedTo().getLocation());
            if (this.sourceSwarm.params.generateOffsetAroundAttachedEntityOval) {
                dist -= Misc.getTargetingRadius(p.loc, this.sourceSwarm.attachedTo, false) + this.sourceSwarm.params.maxOffset - range * 0.5f;
            }
            if (!((velDiff = Misc.getDistance(p.vel, vel)) > maxVelDiff) || !(dist < range)) continue;
            best = p;
            maxVelDiff = dist;
        }
        return best;
    }

    protected RoilingSwarmEffect.SwarmMember pickOuterFragmentWithinRangeClosestTo(float range, Vector2f otherLoc) {
        RoilingSwarmEffect.SwarmMember best = null;
        float minDist = Float.MAX_VALUE;
        WeightedRandomPicker<RoilingSwarmEffect.SwarmMember> picker = this.sourceSwarm.getPicker(true, true);
        while (!picker.isEmpty()) {
            RoilingSwarmEffect.SwarmMember p = picker.pickAndRemove();
            float dist = Misc.getDistance(p.loc, this.sourceSwarm.getAttachedTo().getLocation());
            if (this.sourceSwarm.params.generateOffsetAroundAttachedEntityOval) {
                dist -= Misc.getTargetingRadius(p.loc, this.sourceSwarm.attachedTo, false) + this.sourceSwarm.params.maxOffset - range * 0.5f;
            }
            if (dist > range || !((dist = Misc.getDistance(p.loc, otherLoc)) < minDist)) continue;
            best = p;
            minDist = dist;
        }
        return best;
    }

    protected boolean removeFragmentsWhenMissileLosesHitpoints() {
        return true;
    }

    protected boolean makePrimaryFragmentGlow() {
        return true;
    }

    protected float getRangeForNearbyFragments() {
        return 75.0f;
    }

    protected float getRangeFromSourceToPickFragments() {
        return 150.0f;
    }

    protected int getNumOtherMembersToTransfer() {
        return 0;
    }

    protected boolean addNewMembersIfNotEnoughToTransfer() {
        return true;
    }

    protected int getNumOtherMembersToAdd() {
        return 0;
    }

    protected int getEMPResistance() {
        return 0;
    }

    protected FragmentBehaviorOnImpact getOtherFragmentBehaviorOnImpact() {
        return FragmentBehaviorOnImpact.STOP_AND_FLASH;
    }

    @Override
    public int getNumFragmentsToFire() {
        return 1 + this.getNumOtherMembersToTransfer();
    }

    protected boolean explodeOnFizzling() {
        return false;
    }

    protected String getExplosionSoundId() {
        return null;
    }

    protected void swarmAdvance(float amount, MissileAPI missile, RoilingSwarmEffect swarm) {
    }

    protected boolean withEMPArc() {
        return !this.ship.isFighter();
    }

    protected Color getEMPFringeColor() {
        Color c = this.weapon.getSpec().getGlowColor();
        return c;
    }

    protected Color getEMPCoreColor() {
        return Color.white;
    }

    protected void spawnEMPArc() {
        float minBright;
        Vector2f from = this.weapon.getFirePoint(0);
        EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
        params.segmentLengthMult = 4.0f;
        params.glowSizeMult = 0.5f;
        params.brightSpotFadeFraction = 0.33f;
        params.brightSpotFullFraction = 0.5f;
        params.movementDurMax = 0.2f;
        params.flickerRateMult = 0.5f;
        float dist = Misc.getDistance(from, this.missile.getLocation());
        if (dist * params.brightSpotFullFraction < (minBright = 100.0f)) {
            params.brightSpotFullFraction = minBright / Math.max(minBright, dist);
        }
        float thickness = 20.0f;
        EmpArcEntityAPI arc = this.engine.spawnEmpArcVisual(from, this.weapon.getShip(), this.missile.getLocation(), this.missile, thickness, this.getEMPFringeColor(), this.getEMPCoreColor(), params);
        arc.setSingleFlickerMode(true);
        arc.setUpdateFromOffsetEveryFrame(true);
    }

    public static enum FragmentBehaviorOnImpact {
        STOP_AND_FADE,
        STOP_AND_FLASH,
        KEEP_GOING;

    }
}

