/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.threat.BaseEnergyLashActivatedSystem;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class DisplacerGlowScript
extends BaseEnergyLashActivatedSystem {
    @Override
    public void applyImpl(ShipAPI ship, MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (state != ShipSystemStatsScript.State.IDLE && state != ShipSystemStatsScript.State.OUT) {
            return;
        }
        float ammo = ship.getSystem().getAmmo();
        float maxAmmo = ship.getSystem().getMaxAmmo();
        if (ammo <= 0.0f && (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.OUT)) {
            return;
        }
        if (ship.isHulk()) {
            return;
        }
        float jitterLevel = ammo / maxAmmo;
        jitterLevel = 0.5f + 0.5f * jitterLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        Color base = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
        Color underColor = Misc.setAlpha(base, 255);
        Color overColor = Misc.setAlpha(base, 255);
        ship.setJitterUnder(this, underColor, jitterLevel, 7, 4.0f, 4.0f);
        ship.setJitter(this, overColor, jitterLevel, 2, 0.0f, 4.0f);
        ship.setJitterShields(false);
        ship.setCircularJitter(true);
    }

    @Override
    public void hitWithEnergyLash(ShipAPI overseer, ShipAPI ship) {
        if (ship.getSystem() == null) {
            return;
        }
        ship.getSystem().setAmmo(ship.getSystem().getMaxAmmo());
    }

    @Override
    public float getCurrentUsefulnessLevel(ShipAPI overseer, ShipAPI ship) {
        float maxAmmo;
        float ammo = ship.getSystem().getAmmo();
        if (ammo >= (maxAmmo = (float)ship.getSystem().getMaxAmmo())) {
            return 0.0f;
        }
        if (maxAmmo < 1.0f) {
            maxAmmo = 1.0f;
        }
        float f = ammo / maxAmmo;
        float mult = 0.5f;
        if (ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) || ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP)) {
            mult += 0.5f;
        }
        float fluxFactor = Math.min(0.25f, ship.getFluxLevel() * 0.25f);
        return fluxFactor + 0.75f * (1.0f - f) * mult;
    }
}

