/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.listeners.CurrentLocationChangedListener;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalRogueStellarObjectEPEC;
import com.fs.starfarer.api.impl.campaign.fleets.DisposableFleetManager;
import com.fs.starfarer.api.impl.combat.threat.ThreatFIDConfig;
import com.fs.starfarer.api.impl.combat.threat.ThreatFleetBehaviorScript;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class DisposableThreatFleetManager
extends DisposableFleetManager
implements CurrentLocationChangedListener {
    public static float DEPTH_0 = 2.0f;
    public static float DEPTH_1 = 3.0f;
    public static float DEPTH_2 = 4.0f;
    public static String SENSOR_MODS_KEY = "$hasThreatDetectionSensorMods";
    public static String THREAT_DETECTED_RANGE_MULT_ID = "threat_fleet_stealth";
    public static float THREAT_DETECTED_RANGE_MULT = 0.1f;
    public static float ONSLAUGHT_MKI_SENSOR_MODIFICATIONS_RANGE_MULT = 10.0f;
    public static int MIN_FLEETS = 1;
    public static int MAX_FLEETS = 6;

    public DisposableThreatFleetManager() {
        Global.getSector().getListenerManager().addListener(this);
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        return this;
    }

    @Override
    protected String getSpawnId() {
        return "threat";
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.spawnRateMult > 0.0f) {
            this.spawnRateMult = 1000.0f;
        }
    }

    @Override
    public void reportCurrentLocationChanged(LocationAPI prev, LocationAPI curr) {
        if (this.tracker2 != null) {
            this.tracker2.forceIntervalElapsed();
        }
    }

    @Override
    protected float getExpireDaysPerFleet() {
        return 365.0f;
    }

    @Override
    protected int getDesiredNumFleetsForSpawnLocation() {
        String id = this.currSpawnLoc.getOptionalUniqueId();
        if (id == null) {
            id = this.currSpawnLoc.getId();
        }
        Random random = new Random((long)id.hashCode() * 1343890534L);
        float depth = Misc.getAbyssalDepth(this.currSpawnLoc.getLocation(), true);
        if (depth <= 1.0f) {
            return 0;
        }
        float maxDepth = AbyssalRogueStellarObjectEPEC.MAX_THREAT_PROB_DEPTH;
        float f = (depth - 1.0f) / (maxDepth - 1.0f);
        if (f > 1.0f) {
            f = 1.0f;
        }
        int minFleets = 1;
        int maxFleets = MIN_FLEETS + Math.round((float)(MAX_FLEETS - MIN_FLEETS) * f);
        return minFleets + random.nextInt(maxFleets - minFleets + 1);
    }

    @Override
    protected boolean withReturnToSourceAssignments() {
        return false;
    }

    @Override
    protected StarSystemAPI pickCurrentSpawnLocation() {
        float distToPlayerLY;
        if (Global.getSector().isInNewGameAdvance()) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        StarSystemAPI nearest = null;
        float minDist = Float.MAX_VALUE;
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float distToPlayerLY2;
            if (!system.hasTag("system_can_spawn_threat") || (distToPlayerLY2 = Misc.getDistanceLY(player.getLocationInHyperspace(), system.getLocation())) > MAX_RANGE_FROM_PLAYER_LY || !(distToPlayerLY2 < minDist)) continue;
            nearest = system;
            minDist = distToPlayerLY2;
        }
        if (nearest == null && this.currSpawnLoc != null && (distToPlayerLY = Misc.getDistanceLY(player.getLocationInHyperspace(), this.currSpawnLoc.getLocation())) <= DESPAWN_RANGE_LY) {
            nearest = this.currSpawnLoc;
        }
        return nearest;
    }

    @Override
    protected CampaignFleetAPI spawnFleetImpl() {
        StarSystemAPI system = this.currSpawnLoc;
        if (system == null) {
            return null;
        }
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player == null) {
            return null;
        }
        float depth = Misc.getAbyssalDepth(system.getLocation(), true);
        int numFirst = 0;
        int numSecond = 0;
        int numThird = 0;
        for (CampaignFleetAPI fleet : this.currSpawnLoc.getFleets()) {
            String type;
            if (!fleet.getFaction().getId().equals("threat") || (type = Misc.getFleetType(fleet)) == null) continue;
            if (type.equals("patrolSmall")) {
                ++numFirst;
                continue;
            }
            if (type.equals("patrolMedium")) {
                ++numSecond;
                continue;
            }
            if (!type.equals("patrolLarge")) continue;
            ++numThird;
        }
        int maxSecond = 1;
        if (depth >= DEPTH_2 && (float)Math.random() < 0.5f) {
            maxSecond = 2;
        }
        if (numThird > 0) {
            depth = Math.min(depth, DEPTH_2 - 0.1f);
        }
        if (numSecond > maxSecond) {
            depth = (float)Math.random() < 0.5f ? Math.min(depth, DEPTH_0 - 0.1f) : Math.min(depth, DEPTH_1 - 0.1f);
        }
        WeightedRandomPicker<FabricatorEscortStrength> picker = new WeightedRandomPicker<FabricatorEscortStrength>();
        FabricatorEscortStrength strength = FabricatorEscortStrength.NONE;
        int fabricators = 0;
        if (depth < DEPTH_0) {
            fabricators = 0;
            picker.add(FabricatorEscortStrength.LOW, 3.0f);
            picker.add(FabricatorEscortStrength.MEDIUM, 10.0f);
            picker.add(FabricatorEscortStrength.HIGH, 1.0f);
            strength = (FabricatorEscortStrength)((Object)picker.pick());
        } else if (depth < DEPTH_1) {
            fabricators = 1;
            picker.add(FabricatorEscortStrength.NONE, 1.0f);
            picker.add(FabricatorEscortStrength.LOW, 10.0f);
            picker.add(FabricatorEscortStrength.MEDIUM, 5.0f);
            strength = (FabricatorEscortStrength)((Object)picker.pick());
            if (strength == FabricatorEscortStrength.NONE) {
                fabricators = 1;
            }
        } else if (depth < DEPTH_2) {
            fabricators = 2;
            picker.add(FabricatorEscortStrength.LOW, 10.0f);
            picker.add(FabricatorEscortStrength.MEDIUM, 5.0f);
            picker.add(FabricatorEscortStrength.HIGH, 5.0f);
            picker.add(FabricatorEscortStrength.MAXIMUM, 5.0f);
            strength = (FabricatorEscortStrength)((Object)picker.pick());
            if (strength == FabricatorEscortStrength.MAXIMUM) {
                fabricators = 1;
            }
        } else {
            fabricators = 2;
            picker.add(FabricatorEscortStrength.LOW, 10.0f);
            picker.add(FabricatorEscortStrength.MEDIUM, 5.0f);
            picker.add(FabricatorEscortStrength.HIGH, 5.0f);
            picker.add(FabricatorEscortStrength.MAXIMUM, 5.0f);
            strength = (FabricatorEscortStrength)((Object)picker.pick());
            if (strength == FabricatorEscortStrength.LOW || strength == FabricatorEscortStrength.MEDIUM) {
                fabricators = 3;
            }
        }
        CampaignFleetAPI f = DisposableThreatFleetManager.createThreatFleet(fabricators, 0, 0, strength, null);
        system.addEntity(f);
        float radius = 4000.0f + 2000.0f * (float)Math.random();
        Vector2f loc = Misc.getPointAtRadius(new Vector2f(), radius);
        f.setLocation(loc.x, loc.y);
        f.addScript(new ThreatFleetBehaviorScript(f, system));
        return f;
    }

    public static CampaignFleetAPI createThreatFleet(int numFabricators, int minOtherCapitals, int maxOtherCapitals, FabricatorEscortStrength escorts, Random random) {
        if (random == null) {
            random = Misc.random;
        }
        int minHives = 0;
        int maxHives = 0;
        int minOverseers = 0;
        int maxOverseers = 0;
        int minCruisers = 0;
        int maxCruisers = 0;
        int minDestroyers = 0;
        int maxDestroyers = 0;
        int minFrigates = 0;
        int maxFrigates = 0;
        switch (escorts) {
            case NONE: {
                break;
            }
            case LOW: {
                minOverseers = 1;
                maxOverseers = 2;
                minDestroyers = 0;
                maxDestroyers = 1;
                minFrigates = 2;
                maxFrigates = 4;
                if (numFabricators > 0) break;
                minOverseers = 1;
                break;
            }
            case MEDIUM: {
                minHives = 0;
                maxHives = 1;
                minOverseers = 2;
                maxOverseers = 3;
                minCruisers = 0;
                maxCruisers = 1;
                minDestroyers = 1;
                maxDestroyers = 2;
                minFrigates = 2;
                maxFrigates = 4;
                if (numFabricators > 0) break;
                minHives = 1;
                break;
            }
            case HIGH: {
                minHives = 2;
                maxHives = 3;
                minOverseers = 3;
                maxOverseers = 4;
                minCruisers = 2;
                maxCruisers = 3;
                minDestroyers = 3;
                maxDestroyers = 6;
                minFrigates = 7;
                maxFrigates = 11;
                break;
            }
            case MAXIMUM: {
                minHives = 3;
                maxHives = 4;
                minOverseers = 4;
                maxOverseers = 5;
                minCruisers = 4;
                maxCruisers = 5;
                minDestroyers = 5;
                maxDestroyers = 6;
                minFrigates = 5;
                maxFrigates = 6;
            }
        }
        ThreatFleetCreationParams params = new ThreatFleetCreationParams();
        params.numFabricators = numFabricators;
        params.numHives = minHives + random.nextInt(maxHives - minHives + 1);
        params.numOverseers = minOverseers + random.nextInt(maxOverseers - minOverseers + 1);
        params.numCapitals = minOtherCapitals + random.nextInt(maxOtherCapitals - minOtherCapitals + 1);
        params.numCruisers = minCruisers + random.nextInt(maxCruisers - minCruisers + 1);
        params.numDestroyers = minDestroyers + random.nextInt(maxDestroyers - minDestroyers + 1);
        params.numFrigates = minFrigates + random.nextInt(maxFrigates - minFrigates + 1);
        params.fleetType = "patrolSmall";
        if (numFabricators >= 3 || numFabricators >= 2 && escorts.ordinal() >= FabricatorEscortStrength.HIGH.ordinal()) {
            params.fleetType = "patrolLarge";
        } else if (numFabricators >= 2 || numFabricators >= 1 && escorts.ordinal() >= FabricatorEscortStrength.HIGH.ordinal()) {
            params.fleetType = "patrolMedium";
        }
        return DisposableThreatFleetManager.createThreatFleet(params, random);
    }

    public static CampaignFleetAPI createThreatFleet(ThreatFleetCreationParams params, Random random) {
        CampaignFleetAPI f = Global.getFactory().createEmptyFleet("threat", "Host", true);
        f.setInflater(null);
        f.getMemoryWithoutUpdate().set("$fleetType", params.fleetType);
        DisposableThreatFleetManager.addShips(f, params.numFabricators, "threatFabricator", random);
        DisposableThreatFleetManager.addShips(f, params.numHives, "threatHive", random);
        DisposableThreatFleetManager.addShips(f, params.numOverseers, "threatOverseer", random);
        DisposableThreatFleetManager.addShips(f, params.numCapitals, "combatCapital", random);
        DisposableThreatFleetManager.addShips(f, params.numCruisers, "combatLarge", random);
        DisposableThreatFleetManager.addShips(f, params.numDestroyers, "combatMedium", random);
        DisposableThreatFleetManager.addShips(f, params.numFrigates, "combatSmall", random);
        f.getFleetData().setSyncNeeded();
        f.getFleetData().syncIfNeeded();
        f.getFleetData().sort();
        for (FleetMemberAPI curr : f.getFleetData().getMembersListCopy()) {
            curr.getRepairTracker().setCR(curr.getRepairTracker().getMaxCR());
        }
        FactionAPI faction = Global.getSector().getFaction("threat");
        f.setName(faction.getFleetTypeName(params.fleetType));
        f.getMemoryWithoutUpdate().set("$fidConifgGen", new ThreatFIDConfig());
        f.getMemoryWithoutUpdate().set("$cfai_makeAggressive", true);
        f.getMemoryWithoutUpdate().set("$cfai_makeHostile", true);
        f.getMemoryWithoutUpdate().set("$cfai_longPursuit", true);
        f.getMemoryWithoutUpdate().set("$mayGoIntoAbyss", true);
        f.getDetectedRangeMod().modifyMult(THREAT_DETECTED_RANGE_MULT_ID, THREAT_DETECTED_RANGE_MULT, "Low emission drives");
        return f;
    }

    public static void addShips(CampaignFleetAPI fleet, int num, String role, Random random) {
        FactionAPI faction = Global.getSector().getFaction("threat");
        FactionAPI.ShipPickParams p = new FactionAPI.ShipPickParams(FactionAPI.ShipPickMode.ALL);
        p.blockFallback = true;
        p.maxFP = 1000000;
        int i = 0;
        while (i < num) {
            List<ShipRolePick> picks = faction.pickShip(role, p, null, random);
            for (ShipRolePick pick : picks) {
                fleet.getFleetData().addFleetMember(pick.variantId);
            }
            ++i;
        }
    }

    public static enum FabricatorEscortStrength {
        NONE,
        LOW,
        MEDIUM,
        HIGH,
        MAXIMUM;

    }

    public static class ThreatFleetCreationParams {
        public int numFabricators = 0;
        public int numHives = 0;
        public int numOverseers = 0;
        public int numCapitals = 0;
        public int numCruisers = 0;
        public int numDestroyers = 0;
        public int numFrigates = 0;
        public String fleetType = "patrolSmall";
    }
}

