/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashActivatedSystem;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashSystemScript;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.ThreatSwarmAI;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class EnergyLashSystemAI
implements ShipSystemAIScript {
    protected ShipAPI ship;
    protected CombatEngineAPI engine;
    protected ShipwideAIFlags flags;
    protected ShipSystemAPI system;
    protected EnergyLashSystemScript script;
    protected IntervalUtil tracker = new IntervalUtil(0.5f, 1.0f);

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
        this.system = system;
        this.script = (EnergyLashSystemScript)system.getScript();
    }

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.system.getCooldownRemaining() > 0.0f) {
                return;
            }
            if (this.system.isOutOfAmmo()) {
                return;
            }
            if (this.system.isActive()) {
                return;
            }
            if (this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            ShipAPI pick = this.getWeightedTargets(target).getItemWithHighestWeight();
            if (pick != null) {
                this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.CUSTOM1, 1.5f, pick);
                this.ship.giveCommand(ShipCommand.USE_SYSTEM, null, 0);
            }
        }
    }

    public List<ShipAPI> getPossibleTargets() {
        ArrayList<ShipAPI> result = new ArrayList<ShipAPI>();
        CombatEngineAPI engine = Global.getCombatEngine();
        List<ShipAPI> ships = engine.getShips();
        for (ShipAPI other : ships) {
            if (other == this.ship || !this.script.isValidLashTarget(this.ship, other) || !this.script.isInRange(this.ship, other)) continue;
            result.add(other);
        }
        return result;
    }

    public WeightedRandomPicker<ShipAPI> getWeightedTargets(ShipAPI shipTarget) {
        WeightedRandomPicker<ShipAPI> picker = new WeightedRandomPicker<ShipAPI>();
        for (ShipAPI other : this.getPossibleTargets()) {
            float w = 0.0f;
            if (this.ship.getOwner() == other.getOwner()) {
                if (ThreatSwarmAI.isAttackSwarm(other)) {
                    RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(other);
                    if (swarm == null || VoltaicDischargeOnFireEffect.isSwarmPhaseMode(other)) continue;
                    w = 0.5f;
                } else {
                    if (other.getSystem() == null || !(other.getSystem().getScript() instanceof EnergyLashActivatedSystem) || other.getSystem().getCooldownRemaining() > 0.0f || other.getSystem().isActive() || other.getFluxTracker().isOverloadedOrVenting()) continue;
                    EnergyLashActivatedSystem otherSystem = (EnergyLashActivatedSystem)((Object)other.getSystem().getScript());
                    w = otherSystem.getCurrentUsefulnessLevel(this.ship, other);
                }
            } else {
                boolean targetShieldsFacingUs;
                ShieldAPI targetShield = other.getShield();
                boolean bl = targetShieldsFacingUs = targetShield != null && targetShield.isOn() && Misc.isInArc(targetShield.getFacing(), Math.max(30.0f, targetShield.getActiveArc()), other.getLocation(), this.ship.getLocation());
                if (targetShieldsFacingUs && EnergyLashSystemScript.DAMAGE <= 0.0f) continue;
                float dist = Misc.getDistance(this.ship.getLocation(), other.getLocation());
                if ((dist -= this.ship.getCollisionRadius() + other.getCollisionRadius()) < 0.0f) {
                    dist = 0.0f;
                }
                if (other == shipTarget) {
                    w += 0.25f;
                }
                if (dist < 1000.0f) {
                    w += (1.0f - dist / 1000.0f) * 0.5f;
                }
                if (other.isPhased()) {
                    w += 0.5f;
                }
                w += 0.01f;
            }
            picker.add(other, w);
        }
        return picker;
    }
}

