/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.EmpArcEntityAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.impl.combat.threat.EnergyLashActivatedSystem;
import com.fs.starfarer.api.impl.combat.threat.ThreatShipConstructionScript;
import com.fs.starfarer.api.impl.combat.threat.ThreatSwarmAI;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class EnergyLashSystemScript
extends BaseShipSystemScript {
    public static float MAX_LASH_RANGE = 1500.0f;
    public static float DAMAGE = 0.0f;
    public static float EMP_DAMAGE = 1500.0f;
    public static float MIN_COOLDOWN = 2.0f;
    public static float MAX_COOLDOWN = 10.0f;
    public static float COOLDOWN_DP_MULT = 0.33f;
    public static float MIN_HIT_ENEMY_COOLDOWN = 2.0f;
    public static float MAX_HIT_ENEMY_COOLDOWN = 5.0f;
    public static float HIT_PHASE_ENEMY_COOLDOWN_MULT = 2.0f;
    public static float SWARM_TIMEOUT = 10.0f;
    public static float PHASE_OVERLOAD_DUR = 1.0f;
    protected WeaponSlotAPI mainSlot;
    protected List<WeaponSlotAPI> slots;
    protected boolean readyToFire = true;
    protected float sinceSwarmTargeted = SWARM_TIMEOUT;
    protected float cooldownToSet = -1.0f;

    protected void findSlots(ShipAPI ship) {
        if (this.slots != null) {
            return;
        }
        this.slots = new ArrayList<WeaponSlotAPI>();
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (!slot.isSystemSlot()) continue;
            this.slots.add(slot);
            if (slot.getSlotSize() != WeaponAPI.WeaponSize.MEDIUM) continue;
            this.mainSlot = slot;
        }
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        this.sinceSwarmTargeted += Global.getCombatEngine().getElapsedInLastFrame();
        if ((state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) && this.cooldownToSet >= 0.0f) {
            ship.getSystem().setCooldown(this.cooldownToSet);
            ship.getSystem().setCooldownRemaining(this.cooldownToSet);
            this.cooldownToSet = -1.0f;
        }
        if (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN || effectLevel <= 0.0f) {
            this.readyToFire = true;
        }
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.OUT) {
            float jitterLevel = effectLevel;
            float maxRangeBonus = 150.0f;
            float jitterRangeBonus = (1.0f - effectLevel * effectLevel) * maxRangeBonus;
            float brightness = 0.0f;
            float threshold = 0.1f;
            brightness = effectLevel < threshold ? effectLevel / threshold : 1.0f - (effectLevel - threshold) / (1.0f - threshold);
            if (brightness < 0.0f) {
                brightness = 0.0f;
            }
            if (brightness > 1.0f) {
                brightness = 1.0f;
            }
            if (state == ShipSystemStatsScript.State.OUT) {
                jitterRangeBonus = 0.0f;
                brightness = effectLevel * effectLevel;
            }
            Color color = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
            ship.setJitter(this, color, jitterLevel, 5, 0.0f, 3.0f + jitterRangeBonus);
        }
        if (effectLevel == 1.0f && this.readyToFire) {
            final ShipAPI target = this.findTarget(ship);
            this.readyToFire = false;
            if (target != null) {
                final CombatEngineAPI engine = Global.getCombatEngine();
                this.findSlots(ship);
                Vector2f slotLoc = this.mainSlot.computePosition(ship);
                final EmpArcEntityAPI.EmpArcParams params = new EmpArcEntityAPI.EmpArcParams();
                params.segmentLengthMult = 8.0f;
                params.zigZagReductionFactor = 0.15f;
                params.fadeOutDist = 500.0f;
                params.minFadeOutMult = 2.0f;
                params.flickerRateMult = 0.7f;
                if (ship.getOwner() == target.getOwner()) {
                    params.flickerRateMult = 0.3f;
                    Color color = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
                    if (ThreatSwarmAI.isAttackSwarm(target)) {
                        color = VoltaicDischargeOnFireEffect.PHASE_FRINGE_COLOR;
                    }
                    float emp = 0.0f;
                    float dam = 0.0f;
                    EmpArcEntityAPI arc = engine.spawnEmpArcPierceShields(ship, slotLoc, ship, target, DamageType.ENERGY, dam, emp, 100000.0f, "energy_lash_friendly_impact", 100.0f, color, new Color(255, 255, 255, 255), params);
                    arc.setTargetToShipCenter(slotLoc, target);
                    arc.setCoreWidthOverride(50.0f);
                    arc.setSingleFlickerMode(true);
                    Global.getSoundPlayer().playSound("energy_lash_fire", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
                } else {
                    params.flickerRateMult = 0.4f;
                    int numArcs = this.slots.size();
                    final float emp = EMP_DAMAGE;
                    final float dam = DAMAGE;
                    int i = 0;
                    while (i < numArcs) {
                        float delay = 0.03f * (float)i;
                        final int index = i;
                        final ShipAPI ship2 = ship;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                Vector2f slotLoc = EnergyLashSystemScript.this.slots.get(index).computePosition(ship2);
                                Color color = VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR;
                                Color core = new Color(255, 255, 255, 255);
                                if (target.isPhased()) {
                                    color = VoltaicDischargeOnFireEffect.PHASE_FRINGE_COLOR;
                                    core = VoltaicDischargeOnFireEffect.PHASE_CORE_COLOR;
                                }
                                EmpArcEntityAPI arc = engine.spawnEmpArc(ship2, slotLoc, ship2, target, DamageType.ENERGY, dam, emp, 100000.0f, "energy_lash_enemy_impact", 60.0f, color, core, params);
                                arc.setCoreWidthOverride(40.0f);
                                arc.setSingleFlickerMode(true);
                            }
                        };
                        if (delay <= 0.0f) {
                            r.run();
                        } else {
                            Global.getCombatEngine().addPlugin(new DelayedCombatActionPlugin(delay, r));
                        }
                        Global.getSoundPlayer().playSound("energy_lash_fire_at_enemy", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
                        ++i;
                    }
                }
                this.applyEffectToTarget(ship, target);
            }
        }
    }

    protected void applyEffectToTarget(ShipAPI ship, final ShipAPI target) {
        boolean isSwarm = ThreatSwarmAI.isAttackSwarm(target);
        if (!isSwarm && (target == null || target.getSystem() == null || target.isHulk())) {
            return;
        }
        if (ship == null || ship.getSystem() == null || ship.isHulk()) {
            return;
        }
        if (ship.getOwner() == target.getOwner()) {
            if (target.getSystem() != null && target.getSystem().getScript() instanceof EnergyLashActivatedSystem) {
                EnergyLashActivatedSystem script = (EnergyLashActivatedSystem)((Object)target.getSystem().getScript());
                script.hitWithEnergyLash(ship, target);
            } else if (isSwarm) {
                VoltaicDischargeOnFireEffect.setSwarmPhaseMode(target);
                this.sinceSwarmTargeted = 0.0f;
            }
            float cooldown = target.getHullSpec().getSuppliesToRecover();
            cooldown = MIN_COOLDOWN + cooldown * COOLDOWN_DP_MULT;
            if (cooldown > MAX_COOLDOWN) {
                cooldown = MAX_COOLDOWN;
            }
            if (target.isFighter()) {
                cooldown = MIN_COOLDOWN;
            }
            this.cooldownToSet = cooldown;
        } else {
            boolean hitPhase = false;
            if (target.isPhased()) {
                target.setOverloadColor(VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR_BRIGHT);
                target.getFluxTracker().beginOverloadWithTotalBaseDuration(PHASE_OVERLOAD_DUR);
                if (target.getFluxTracker().showFloaty() || ship == Global.getCombatEngine().getPlayerShip() || target == Global.getCombatEngine().getPlayerShip()) {
                    target.getFluxTracker().playOverloadSound();
                    target.getFluxTracker().showOverloadFloatyIfNeeded("Phase Field Disruption!", VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR, 4.0f, true);
                }
                Global.getCombatEngine().addPlugin(new BaseEveryFrameCombatPlugin(){

                    @Override
                    public void advance(float amount, List<InputEventAPI> events) {
                        if (!target.getFluxTracker().isOverloadedOrVenting()) {
                            target.resetOverloadColor();
                            Global.getCombatEngine().removePlugin(this);
                        }
                    }
                });
                hitPhase = true;
            }
            float cooldown = MIN_HIT_ENEMY_COOLDOWN + (MAX_HIT_ENEMY_COOLDOWN - MIN_HIT_ENEMY_COOLDOWN) * (float)Math.random();
            if (hitPhase) {
                cooldown *= HIT_PHASE_ENEMY_COOLDOWN_MULT;
            }
            if (cooldown > MAX_COOLDOWN) {
                cooldown = MAX_COOLDOWN;
            }
            this.cooldownToSet = cooldown;
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    @Override
    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        if (system.isOutOfAmmo()) {
            return null;
        }
        if (system.getState() != ShipSystemAPI.SystemState.IDLE) {
            return null;
        }
        ShipAPI target = this.findTarget(ship);
        if (target != null && target != ship) {
            return "READY";
        }
        if ((target == null || target == ship) && ship.getShipTarget() != null) {
            return "OUT OF RANGE";
        }
        return "NO TARGET";
    }

    public boolean isInRange(ShipAPI ship, ShipAPI target) {
        float radSum;
        float range = EnergyLashSystemScript.getRange(ship);
        float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
        return dist <= range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius());
    }

    public boolean isValidLashTarget(ShipAPI ship, ShipAPI other) {
        if (other == null) {
            return false;
        }
        if (other.isHulk() || other.getOwner() == 100) {
            return false;
        }
        if (other.isShuttlePod()) {
            return false;
        }
        if (other.hasTag(ThreatShipConstructionScript.SHIP_UNDER_CONSTRUCTION)) {
            return false;
        }
        if (other.isFighter() && other.getOwner() == ship.getOwner()) {
            return ThreatSwarmAI.isAttackSwarm(other) && this.sinceSwarmTargeted > SWARM_TIMEOUT;
        }
        if (other.isFighter()) {
            return false;
        }
        if (other.getOwner() == ship.getOwner()) {
            if (other.getSystem() == null) {
                return false;
            }
            if (!(other.getSystem().getScript() instanceof EnergyLashActivatedSystem)) {
                return false;
            }
            if (other.getSystem().getCooldownRemaining() > 0.0f) {
                return false;
            }
            if (other.getSystem().isActive()) {
                return false;
            }
            if (other.getFluxTracker().isOverloadedOrVenting()) {
                return false;
            }
        }
        return true;
    }

    protected ShipAPI findTarget(ShipAPI ship) {
        float range = EnergyLashSystemScript.getRange(ship);
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        ShipAPI target = ship.getShipTarget();
        float extraRange = 0.0f;
        if (ship.getShipAI() != null && ship.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.CUSTOM1)) {
            target = (ShipAPI)ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.CUSTOM1);
            extraRange += 500.0f;
        }
        if (target != null) {
            float radSum;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius()) + extraRange) {
                target = null;
            }
        } else {
            Misc.FindShipFilter filter = s -> this.isValidLashTarget(ship, s);
            if (target == null || target.getOwner() == ship.getOwner()) {
                if (player) {
                    target = Misc.findClosestShipTo(ship, ship.getMouseTarget(), ShipAPI.HullSize.FIGHTER, range, true, false, filter);
                } else {
                    Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
                    if (test instanceof ShipAPI) {
                        float radSum;
                        target = (ShipAPI)test;
                        float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
                        if (dist > range + (radSum = ship.getCollisionRadius() + target.getCollisionRadius())) {
                            target = null;
                        }
                    }
                }
            }
            if (target == null) {
                target = Misc.findClosestShipTo(ship, ship.getLocation(), ShipAPI.HullSize.FIGHTER, range, true, false, filter);
            }
        }
        return target;
    }

    @Override
    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        ShipAPI target = this.findTarget(ship);
        return target != null && target != ship;
    }

    public static float getRange(ShipAPI ship) {
        if (ship == null) {
            return MAX_LASH_RANGE;
        }
        return ship.getMutableStats().getSystemRangeBonus().computeEffective(MAX_LASH_RANGE);
    }

    public static class DelayedCombatActionPlugin
    extends BaseEveryFrameCombatPlugin {
        float elapsed = 0.0f;
        float delay;
        Runnable r;

        public DelayedCombatActionPlugin(float delay, Runnable r) {
            this.delay = delay;
            this.r = r;
        }

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            this.elapsed += amount;
            if (this.elapsed < this.delay) {
                return;
            }
            this.r.run();
            CombatEngineAPI engine = Global.getCombatEngine();
            engine.removePlugin(this);
        }
    }
}

