/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.combat.listeners.WeaponRangeModifier;
import com.fs.starfarer.api.impl.combat.threat.BaseEnergyLashActivatedSystem;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class FragmentVolleySystemScript
extends BaseEnergyLashActivatedSystem
implements WeaponRangeModifier {
    public static float FRAGMENT_RANGE_MULT = 2.0f;
    public static float MAX_VOLLEY_RANGE = 3000.0f;
    public static float FRAGMENT_REGEN_RATE_MULT = 10.0f;

    @Override
    public void applyImpl(ShipAPI ship, MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (effectLevel <= 0.0f) {
            stats.getDynamic().getStat("fragment_swarm_respawn_rate_mult").unmodifyMult(id);
            return;
        }
        stats.getDynamic().getStat("fragment_swarm_respawn_rate_mult").modifyMult(id, 1.0f + (FRAGMENT_REGEN_RATE_MULT - 1.0f) * effectLevel);
        Color glowColor = Misc.setAlpha(VoltaicDischargeOnFireEffect.EMP_FRINGE_COLOR, 50);
        for (WeaponGroupAPI g : ship.getWeaponGroupsCopy()) {
            for (WeaponAPI w : g.getWeaponsCopy()) {
                if (w.hasAIHint(WeaponAPI.AIHints.PD) || w.hasAIHint(WeaponAPI.AIHints.NO_MANUAL_FIRE) || !w.getSpec().hasTag("fragment")) continue;
                w.setGlowAmount(effectLevel, glowColor);
            }
        }
        this.setStandardJitter(ship, state, effectLevel);
        if (state == ShipSystemStatsScript.State.OUT) {
            ship.removeListenerOfClass(FragmentVolleySystemScript.class);
            return;
        }
        if (state != ShipSystemStatsScript.State.ACTIVE) {
            return;
        }
        if (!ship.hasListenerOfClass(FragmentVolleySystemScript.class)) {
            ship.addListener(this);
        }
        for (WeaponGroupAPI g : ship.getWeaponGroupsCopy()) {
            for (WeaponAPI w : g.getWeaponsCopy()) {
                if (w.hasAIHint(WeaponAPI.AIHints.NO_MANUAL_FIRE)) continue;
                if (!w.hasAIHint(WeaponAPI.AIHints.PD) && w.getSpec().hasTag("fragment")) {
                    if (w.getCooldownRemaining() > 1.0f) {
                        w.setRemainingCooldownTo(1.0f);
                    }
                    if (w.usesAmmo()) {
                        w.setAmmo(w.getMaxAmmo());
                    }
                    w.setForceFireOneFrame(true);
                    continue;
                }
                w.setForceNoFireOneFrame(true);
            }
        }
        Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        if (test instanceof ShipAPI) {
            ShipAPI target = (ShipAPI)test;
            ship.setShipTarget(target);
        }
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (effectLevel <= 0.0f) {
            return null;
        }
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("firing fragments", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData((int)FRAGMENT_RANGE_MULT + "x fragment range", false);
        }
        return null;
    }

    @Override
    public float getCurrentUsefulnessLevel(ShipAPI overseer, ShipAPI ship) {
        if (ship.getSystem().isActive() || ship.getSystem().isChargedown() || ship.getSystem().isChargeup() || ship.getSystem().isCoolingDown()) {
            return 0.0f;
        }
        Object test = ship.getAIFlags().getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        if (test instanceof ShipAPI) {
            float range;
            ShipAPI target = (ShipAPI)test;
            float dist = Misc.getDistance(ship.getLocation(), target.getLocation());
            if ((dist -= ship.getCollisionRadius() + target.getCollisionRadius()) < (range = FragmentVolleySystemScript.getMinFragmentWeaponRange(ship) * FRAGMENT_RANGE_MULT) * 0.8f && dist < MAX_VOLLEY_RANGE) {
                float distToOverseer = Misc.getDistance(ship.getLocation(), overseer.getLocation());
                distToOverseer -= ship.getCollisionRadius() + overseer.getCollisionRadius();
                float overseerDistFactor = 0.0f;
                if (distToOverseer < 1000.0f) {
                    float min = 500.0f;
                    overseerDistFactor = (1.0f - Math.max(0.0f, distToOverseer - min) / (1000.0f - min)) * 0.25f;
                }
                return Math.min(1.0f, 0.5f + Math.min(0.5f, ship.getFluxLevel() * 1.0f) + overseerDistFactor);
            }
        }
        return 0.0f;
    }

    public static float getMinFragmentWeaponRange(ShipAPI ship) {
        float min = Float.MAX_VALUE;
        boolean found = false;
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.isDecorative() || w.hasAIHint(WeaponAPI.AIHints.PD) || w.hasAIHint(WeaponAPI.AIHints.NO_MANUAL_FIRE) || !w.getSpec().hasTag("fragment")) continue;
            min = Math.min(min, w.getRange());
            found = true;
        }
        if (!found) {
            min = 0.0f;
        }
        return min;
    }

    @Override
    public float getWeaponRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
        return 0.0f;
    }

    @Override
    public float getWeaponRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
        if (!weapon.hasAIHint(WeaponAPI.AIHints.PD) && !weapon.hasAIHint(WeaponAPI.AIHints.NO_MANUAL_FIRE) && weapon.getSpec().hasTag("fragment")) {
            return FRAGMENT_RANGE_MULT;
        }
        return 1.0f;
    }

    @Override
    public float getWeaponRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
        return 0.0f;
    }
}

