/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.FleetEncounterContextPlugin;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.combat.threat.ConstructionSwarmSystemScript;
import com.fs.starfarer.api.loading.HullModSpecAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Random;

public class ThreatFIDConfig
implements FleetInteractionDialogPluginImpl.FIDConfigGen {
    @Override
    public FleetInteractionDialogPluginImpl.FIDConfig createConfig() {
        FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
        config.alwaysAttackVsAttack = true;
        config.alwaysHarry = true;
        config.showTransponderStatus = false;
        config.lootCredits = false;
        config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

            @Override
            public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                if (!(dialog.getInteractionTarget() instanceof CampaignFleetAPI)) {
                    return;
                }
                float mult = context.computePlayerContribFraction();
                float p = Global.getSettings().getFloat("salvageHullmodProb");
                float pItem = Global.getSettings().getFloat("salvageHullmodRequiredItemProb");
                CampaignFleetAPI fleet = (CampaignFleetAPI)dialog.getInteractionTarget();
                FleetEncounterContextPlugin.DataForEncounterSide data = context.getDataFor(fleet);
                ArrayList<FleetMemberAPI> losses = new ArrayList<FleetMemberAPI>();
                for (FleetEncounterContextPlugin.FleetMemberData fmd : data.getOwnCasualties()) {
                    losses.add(fmd.getMember());
                }
                Random random = Misc.getRandom(Misc.getSalvageSeed(fleet), 7);
                for (FleetMemberAPI member : losses) {
                    if (!member.getHullSpec().hasTag("threat_fabricator")) continue;
                    int rolls = 0;
                    switch (member.getHullSpec().getHullSize()) {
                        case CAPITAL_SHIP: {
                            rolls = 30;
                            break;
                        }
                        case CRUISER: {
                            rolls = 18;
                            break;
                        }
                        case DESTROYER: {
                            rolls = 12;
                            break;
                        }
                        case FRIGATE: {
                            rolls = 6;
                        }
                    }
                    WeightedRandomPicker<ConstructionSwarmSystemScript.SwarmConstructableVariant> picker = new WeightedRandomPicker<ConstructionSwarmSystemScript.SwarmConstructableVariant>(random);
                    for (ConstructionSwarmSystemScript.SwarmConstructableVariant curr : ConstructionSwarmSystemScript.CONSTRUCTABLE) {
                        picker.add(curr, curr.dp);
                    }
                    int i = 0;
                    while (i < rolls) {
                        ConstructionSwarmSystemScript.SwarmConstructableVariant pick = (ConstructionSwarmSystemScript.SwarmConstructableVariant)picker.pick();
                        ShipVariantAPI variant = Global.getSettings().getVariant(pick.variantId);
                        for (String id : variant.getHullMods()) {
                            HullModSpecAPI spec;
                            CargoStackAPI item;
                            if (!variant.getHullSpec().isBuiltInMod(id) && random.nextFloat() < pItem && random.nextFloat() < mult && (item = (spec = Global.getSettings().getHullModSpec(id)).getEffect().getRequiredItem()) != null) {
                                boolean addToLoot = true;
                                if (item.getSpecialItemSpecIfSpecial() != null && item.getSpecialItemSpecIfSpecial().hasTag("no_drop")) {
                                    addToLoot = false;
                                } else if (item.getResourceIfResource() != null && item.getResourceIfResource().hasTag("no_drop")) {
                                    addToLoot = false;
                                } else if (item.getFighterWingSpecIfWing() != null && item.getFighterWingSpecIfWing().hasTag("no_drop")) {
                                    addToLoot = false;
                                } else if (item.getWeaponSpecIfWeapon() != null && item.getWeaponSpecIfWeapon().hasTag("no_drop")) {
                                    addToLoot = false;
                                }
                                if (addToLoot) {
                                    salvage.addItems(item.getType(), item.getData(), 1.0f);
                                }
                            }
                            if (!(random.nextFloat() < p) || !(random.nextFloat() < mult)) continue;
                            spec = Global.getSettings().getHullModSpec(id);
                            boolean known = Global.getSector().getPlayerFaction().knowsHullMod(id);
                            if (DebugFlags.ALLOW_KNOWN_HULLMOD_DROPS) {
                                known = false;
                            }
                            if (known || spec.isHidden() || spec.isHiddenEverywhere() || spec.hasTag("no_drop")) continue;
                            salvage.addHullmods(id, 1);
                        }
                        ++i;
                    }
                }
            }

            @Override
            public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                bcc.aiRetreatAllowed = false;
                bcc.fightToTheLast = true;
                if (bcc.getOtherFleet() != null) {
                    for (FleetMemberAPI curr : bcc.getOtherFleet().getMembersWithFightersCopy()) {
                        if (!curr.getHullSpec().hasTag("threat_fabricator")) continue;
                        bcc.forceObjectivesOnMap = true;
                        break;
                    }
                }
                Global.getSector().getPlayerMemoryWithoutUpdate().set("$encounteredThreat", true);
                Global.getSector().getPlayerMemoryWithoutUpdate().set("$encounteredWeird", true);
            }
        };
        return config;
    }
}

