/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.WeaponBaseRangeModifier;
import com.fs.starfarer.api.loading.WeaponSlotAPI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BallisticRangefinder
extends BaseHullMod {
    public static float BONUS_MAX_1 = 800.0f;
    public static float BONUS_MAX_2 = 800.0f;
    public static float BONUS_MAX_3 = 900.0f;
    public static float BONUS_SMALL_1 = 100.0f;
    public static float BONUS_SMALL_2 = 100.0f;
    public static float BONUS_SMALL_3 = 200.0f;
    public static float BONUS_MEDIUM_3 = 100.0f;
    public static float HYBRID_MULT = 2.0f;
    public static float HYBRID_BONUS_MIN = 100.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
    }

    public static WeaponAPI.WeaponSize getLargestBallisticSlot(ShipAPI ship) {
        if (ship == null) {
            return null;
        }
        Enum largest = null;
        for (WeaponSlotAPI slot : ship.getHullSpec().getAllWeaponSlotsCopy()) {
            if (slot.isDecorative() || slot.getWeaponType() != WeaponAPI.WeaponType.BALLISTIC || largest != null && largest.ordinal() >= slot.getSlotSize().ordinal()) continue;
            largest = slot.getSlotSize();
        }
        return largest;
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (largest == null) {
            return;
        }
        float small = 0.0f;
        float medium = 0.0f;
        float max = 0.0f;
        switch (largest) {
            case LARGE: {
                small = BONUS_SMALL_3;
                medium = BONUS_MEDIUM_3;
                max = BONUS_MAX_3;
                break;
            }
            case MEDIUM: {
                small = BONUS_SMALL_2;
                max = BONUS_MAX_2;
                break;
            }
            case SMALL: {
                small = BONUS_SMALL_1;
                max = BONUS_MAX_1;
            }
        }
        ship.addListener(new RangefinderRangeModifier(small, medium, max));
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    @Override
    public boolean shouldAddDescriptionToTooltip(ShipAPI.HullSize hullSize, ShipAPI ship, boolean isForModSpec) {
        return false;
    }

    @Override
    public void addPostDescriptionSection(TooltipMakerAPI tooltip, ShipAPI.HullSize hullSize, ShipAPI ship, float width, boolean isForModSpec) {
        float colW;
        float pad = 3.0f;
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        Color t = Misc.getTextColor();
        Color g = Misc.getGrayColor();
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        tooltip.addPara("Utilizes targeting data from the ship's largest ballistic slot to benefit certain weapons, extending the base range of typical ballistic weapons to match similar but larger weapons. Greatly benefits hybrid weapons. Point-defense weapons are unaffected.", opad, h, "ship's largest ballistic slot", "base range", "Greatly benefits hybrid weapons");
        tooltip.addPara("The range bonus is based on the size of the largest ballistic slot, and the increased base range is capped, but still subject to other modifiers.", opad);
        tooltip.addSectionHeading("Ballistic weapon range", Alignment.MID, opad);
        tooltip.addPara("Affects small and medium ballistic weapons.", opad);
        float col1W = 120.0f;
        float lastW = colW = (float)((int)((width - col1W - 12.0f) / 3.0f));
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"Largest b. slot", Float.valueOf(col1W), "Small wpn", Float.valueOf(colW), "Medium wpn", Float.valueOf(colW), "Range cap", Float.valueOf(lastW)});
        Color reallyG = g;
        if (Global.CODEX_TOOLTIP_MODE) {
            g = h;
        }
        Color c = null;
        c = largest == WeaponAPI.WeaponSize.SMALL ? h : (largest == WeaponAPI.WeaponSize.MEDIUM ? h : g);
        tooltip.addRow(new Object[]{Alignment.MID, c, "Small / Medium", Alignment.MID, c, "+" + (int)BONUS_SMALL_1, Alignment.MID, reallyG, "---", Alignment.MID, c, "" + (int)BONUS_MAX_1});
        c = largest == WeaponAPI.WeaponSize.LARGE ? h : g;
        tooltip.addRow(new Object[]{Alignment.MID, c, "Large", Alignment.MID, c, "+" + (int)BONUS_SMALL_3, Alignment.MID, c, "+" + (int)BONUS_MEDIUM_3, Alignment.MID, c, "" + (int)BONUS_MAX_3});
        tooltip.addTable("", 0, opad);
        tooltip.addSectionHeading("Hybrid weapon range", Alignment.MID, opad + 7.0f);
        tooltip.addPara("Affects hybrid weapons (those that can fit into both ballistic and energy slots) of all sizes.", opad);
        col1W = 120.0f;
        colW = (int)((width - col1W - lastW - 15.0f) / 3.0f);
        tooltip.beginTable(Misc.getBasePlayerColor(), Misc.getDarkPlayerColor(), Misc.getBrightPlayerColor(), 20.0f, true, true, new Object[]{"Largest b. slot", Float.valueOf(col1W), "Small", Float.valueOf(colW), "Medium", Float.valueOf(colW), "Large", Float.valueOf(colW), "Range cap", Float.valueOf(lastW)});
        c = null;
        c = largest == WeaponAPI.WeaponSize.SMALL ? h : (largest == WeaponAPI.WeaponSize.MEDIUM ? h : g);
        tooltip.addRow(new Object[]{Alignment.MID, c, "Small / Medium", Alignment.MID, c, "+" + (int)(BONUS_SMALL_1 * HYBRID_MULT), Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "" + (int)BONUS_MAX_1});
        c = largest == WeaponAPI.WeaponSize.LARGE ? h : g;
        tooltip.addRow(new Object[]{Alignment.MID, c, "Large", Alignment.MID, c, "+" + (int)(BONUS_SMALL_3 * HYBRID_MULT), Alignment.MID, c, "+" + (int)(BONUS_MEDIUM_3 * HYBRID_MULT), Alignment.MID, c, "+" + (int)HYBRID_BONUS_MIN, Alignment.MID, c, "" + (int)BONUS_MAX_3});
        tooltip.addTable("", 0, opad);
        tooltip.addSectionHeading("Interactions with other modifiers", Alignment.MID, opad + 7.0f);
        tooltip.addPara("Since the base range is increased, this modifier - unlike most other flat modifiers - is increased by percentage modifiers from other hullmods and skills.", opad);
    }

    @Override
    public float getTooltipWidth() {
        return 412.0f;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (ship != null && largest == null) {
            return false;
        }
        return this.getUnapplicableReason(ship) == null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        WeaponAPI.WeaponSize largest = BallisticRangefinder.getLargestBallisticSlot(ship);
        if (ship != null && largest == null) {
            return "Ship has no ballistic weapon slots";
        }
        if (ship != null && ship.getHullSize() != ShipAPI.HullSize.CAPITAL_SHIP && ship.getHullSize() != ShipAPI.HullSize.DESTROYER && ship.getHullSize() != ShipAPI.HullSize.CRUISER) {
            return "Can only be installed on destroyer-class hulls and larger";
        }
        return null;
    }

    public static class RangefinderRangeModifier
    implements WeaponBaseRangeModifier {
        public float small;
        public float medium;
        public float max;

        public RangefinderRangeModifier(float small, float medium, float max) {
            this.small = small;
            this.medium = medium;
            this.max = max;
        }

        @Override
        public float getWeaponBaseRangePercentMod(ShipAPI ship, WeaponAPI weapon) {
            return 0.0f;
        }

        @Override
        public float getWeaponBaseRangeMultMod(ShipAPI ship, WeaponAPI weapon) {
            return 1.0f;
        }

        @Override
        public float getWeaponBaseRangeFlatMod(ShipAPI ship, WeaponAPI weapon) {
            if (weapon.getSpec() == null) {
                return 0.0f;
            }
            if (weapon.getSpec().getMountType() != WeaponAPI.WeaponType.BALLISTIC && weapon.getSpec().getMountType() != WeaponAPI.WeaponType.HYBRID) {
                return 0.0f;
            }
            if (weapon.hasAIHint(WeaponAPI.AIHints.PD)) {
                return 0.0f;
            }
            float bonus = 0.0f;
            if (weapon.getSize() == WeaponAPI.WeaponSize.SMALL) {
                bonus = this.small;
            } else if (weapon.getSize() == WeaponAPI.WeaponSize.MEDIUM) {
                bonus = this.medium;
            }
            if (weapon.getSpec().getMountType() == WeaponAPI.WeaponType.HYBRID && (bonus *= HYBRID_MULT) < HYBRID_BONUS_MIN) {
                bonus = HYBRID_BONUS_MIN;
            }
            if (bonus == 0.0f) {
                return 0.0f;
            }
            float base = weapon.getSpec().getMaxRange();
            if (base + bonus > this.max) {
                bonus = this.max - base;
            }
            if (bonus < 0.0f) {
                bonus = 0.0f;
            }
            return bonus;
        }
    }
}

