/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.CompromisedStructure;

public class CompromisedStorage
extends BaseHullMod {
    public static final float CAPACITY_PENALTY_PERCENT = 25.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float effect = stats.getDynamic().getValue("dmod_effect_mult");
        stats.getMaxCrewMod().modifyMult(id, 1.0f - 25.0f * effect / 100.0f);
        stats.getFuelMod().modifyMult(id, 1.0f - 25.0f * effect / 100.0f);
        stats.getCargoMod().modifyMult(id, 1.0f - 25.0f * effect / 100.0f);
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        if (index == 0) {
            return Math.round(25.0f * effect) + "%";
        }
        if (index >= 1) {
            return CompromisedStructure.getCostDescParam(index, 1);
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return true;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return null;
    }
}

