/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class CompromisedStructure
extends BaseHullMod {
    public static float DEPLOYMENT_COST_MULT = 0.8f;
    public static float ARMOR_PENALTY_MULT = 0.8f;
    public static float HULL_PENALTY_MULT = 0.8f;

    public static void modifyCost(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getSuppliesToRecover().modifyMult(id, DEPLOYMENT_COST_MULT);
        float effect = stats.getDynamic().getValue("dmod_reduce_maintenance", 0.0f);
        if (effect > 0.0f) {
            stats.getSuppliesPerMonth().modifyMult(id, DEPLOYMENT_COST_MULT);
        }
    }

    public static String getCostDescParam(int index, int startIndex) {
        if (index - startIndex == 0) {
            return Math.round((1.0f - DEPLOYMENT_COST_MULT) * 100.0f) + "%";
        }
        return null;
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float effect = stats.getDynamic().getValue("dmod_effect_mult");
        float armorMult = ARMOR_PENALTY_MULT + (1.0f - ARMOR_PENALTY_MULT) * (1.0f - effect);
        float hullMult = HULL_PENALTY_MULT + (1.0f - HULL_PENALTY_MULT) * (1.0f - effect);
        stats.getArmorBonus().modifyMult(id, armorMult);
        stats.getHullBonus().modifyMult(id, hullMult);
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        float armorMult = ARMOR_PENALTY_MULT + (1.0f - ARMOR_PENALTY_MULT) * (1.0f - effect);
        float hullMult = HULL_PENALTY_MULT + (1.0f - HULL_PENALTY_MULT) * (1.0f - effect);
        if (index == 0) {
            return Math.round((1.0f - armorMult) * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round((1.0f - hullMult) * 100.0f) + "%";
        }
        if (index >= 2) {
            return CompromisedStructure.getCostDescParam(index, 2);
        }
        return null;
    }
}

