/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class DesignCompromises
extends BaseHullMod {
    public static float RANGE_MULT = 0.8f;
    public static float FLUX_MULT = 0.6f;
    public static float ENERGY_WEAPON_FLUX_INCREASE = 100.0f;
    public static float MISSILE_ROF_MULT = 0.5f;
    public static float BALLISTIC_RANGE_MULT = 0.85f;
    public static boolean AlLOW_CONVERTED_HANGAR = true;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getBallisticWeaponRangeBonus().modifyMult(id, BALLISTIC_RANGE_MULT);
        stats.getMissileRoFMult().modifyMult(id, MISSILE_ROF_MULT);
        stats.getEnergyWeaponFluxCostMod().modifyPercent(id, ENERGY_WEAPON_FLUX_INCREASE);
        stats.getFluxDissipation().modifyMult(id, FLUX_MULT);
        stats.getFluxCapacity().modifyMult(id, FLUX_MULT);
        stats.getSystemFluxCostBonus().modifyMult(id, FLUX_MULT);
        if (AlLOW_CONVERTED_HANGAR) {
            stats.getDynamic().getMod("force_allow_converted_hangar").modifyFlat(id, 1.0f);
            stats.getDynamic().getMod("converted_hangar_no_crew_increase").modifyFlat(id, 1.0f);
            stats.getDynamic().getMod("converted_hangar_no_rearm_increase").modifyFlat(id, 1.0f);
            stats.getDynamic().getMod("converted_hangar_no_refit_penalty").modifyFlat(id, 1.0f);
        }
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return Math.round((1.0f - FLUX_MULT) * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round((1.0f - BALLISTIC_RANGE_MULT) * 100.0f) + "%";
        }
        if (index == 2) {
            return Math.round((1.0f - MISSILE_ROF_MULT) * 100.0f) + "%";
        }
        if (index == 3) {
            return Math.round(ENERGY_WEAPON_FLUX_INCREASE) + "%";
        }
        if (index == 4) {
            return "Converted Hangar";
        }
        if (index == 5) {
            return "" + Math.round(2.0f);
        }
        return null;
    }
}

