/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.CompromisedStructure;

public class FragileSubsystems
extends BaseHullMod {
    public static final float PEAK_PENALTY_PERCENT = 30.0f;
    public static final float DEGRADE_INCREASE_PERCENT = 30.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float effect = stats.getDynamic().getValue("dmod_effect_mult");
        stats.getPeakCRDuration().modifyMult(id, 1.0f - 30.0f * effect / 100.0f);
        stats.getCRLossPerSecondPercent().modifyPercent(id, 30.0f * effect);
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        if (index == 0) {
            return Math.round(30.0f * effect) + "%";
        }
        if (index == 1) {
            return Math.round(30.0f * effect) + "%";
        }
        if (index >= 2) {
            return CompromisedStructure.getCostDescParam(index, 2);
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && (ship.getHullSpec().getNoCRLossTime() < 10000.0f || ship.getHullSpec().getCRLossPerSecond(ship.getMutableStats()) > 0.0f);
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return "Ship does not suffer from CR degradation";
    }
}

