/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.hullmods.CompromisedStructure;

public class GlitchedSensorArray
extends BaseHullMod {
    public static final float RANGE_MULT = 0.9f;
    public static final float SENSOR_MULT = 0.5f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        float effect = stats.getDynamic().getValue("dmod_effect_mult");
        float rangeMult = 0.9f + 0.100000024f * (1.0f - effect);
        float sensorMult = 0.5f + 0.5f * (1.0f - effect);
        stats.getBallisticWeaponRangeBonus().modifyMult(id, rangeMult);
        stats.getEnergyWeaponRangeBonus().modifyMult(id, rangeMult);
        stats.getSensorStrength().modifyMult(id, sensorMult);
        CompromisedStructure.modifyCost(hullSize, stats, id);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        float effect = 1.0f;
        if (ship != null) {
            effect = ship.getMutableStats().getDynamic().getValue("dmod_effect_mult");
        }
        float rangeMult = 0.9f + 0.100000024f * (1.0f - effect);
        float sensorMult = 0.5f + 0.5f * (1.0f - effect);
        if (index == 0) {
            return Math.round((1.0f - rangeMult) * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round((1.0f - sensorMult) * 100.0f) + "%";
        }
        if (index >= 2) {
            return CompromisedStructure.getCostDescParam(index, 2);
        }
        return null;
    }
}

