/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipHullSpecAPI;
import com.fs.starfarer.api.impl.hullmods.NeuralInterface;
import com.fs.starfarer.api.util.Misc;

public class NeuralIntegrator
extends NeuralInterface {
    public static float DP_INCREASE_PERCENT = 10.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        super.applyEffectsBeforeShipCreation(hullSize, stats, id);
        stats.getSuppliesToRecover().modifyPercent(id, DP_INCREASE_PERCENT);
        stats.getDynamic().getMod("deployment_points_mod").modifyPercent(id, DP_INCREASE_PERCENT);
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        if (!Misc.isAutomated(ship)) {
            return false;
        }
        return !ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK);
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (!Misc.isAutomated(ship)) {
            return "Can only be installed on automated ships, install Neural Interface instead";
        }
        if (ship.getHullSpec().getHints().contains((Object)ShipHullSpecAPI.ShipTypeHints.NO_NEURAL_LINK)) {
            return "Can not be installed on this ship";
        }
        return null;
    }
}

