/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.impl.combat.RiftCascadeEffect;
import com.fs.starfarer.api.impl.combat.RiftLanceEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.loading.FighterWingSpecAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ShardSpawner
extends BaseHullMod {
    public static Color JITTER_COLOR = new Color(100, 100, 255, 50);
    public static String DATA_KEY = "core_shard_spawner_data_key";
    public static float SPAWN_TIME = 4.0f;
    public static Map<ShipAPI.HullSize, ShardTypeVariants> variantData = new HashMap<ShipAPI.HullSize, ShardTypeVariants>();

    static {
        ShardTypeVariants fighters = new ShardTypeVariants();
        variantData.put(ShipAPI.HullSize.FIGHTER, fighters);
        fighters.get(ShardType.GENERAL).add("aspect_attack_wing", 10.0f);
        fighters.get(ShardType.GENERAL).add("aspect_missile_wing", 1.0f);
        fighters.get(ShardType.MISSILE).add("aspect_missile_wing", 10.0f);
        fighters.get(ShardType.ANTI_ARMOR).add("aspect_attack_wing", 10.0f);
        fighters.get(ShardType.ANTI_SHIELD).add("aspect_shieldbreaker_wing", 10.0f);
        fighters.get(ShardType.POINT_DEFENSE).add("aspect_shock_wing", 10.0f);
        ShardTypeVariants small = new ShardTypeVariants();
        variantData.put(ShipAPI.HullSize.FRIGATE, small);
        small.get(ShardType.GENERAL).add("shard_left_Attack", 10.0f);
        small.get(ShardType.GENERAL).add("shard_left_Attack2", 10.0f);
        small.get(ShardType.GENERAL).add("shard_right_Attack", 10.0f);
        small.get(ShardType.GENERAL).add("aspect_attack_wing", 10.0f);
        small.get(ShardType.GENERAL).add("aspect_missile_wing", 1.0f);
        small.get(ShardType.ANTI_ARMOR).add("shard_left_Armorbreaker", 10.0f);
        small.get(ShardType.ANTI_SHIELD).add("shard_left_Shieldbreaker", 10.0f);
        small.get(ShardType.ANTI_SHIELD).add("shard_right_Shieldbreaker", 10.0f);
        small.get(ShardType.POINT_DEFENSE).add("shard_left_Defense", 10.0f);
        small.get(ShardType.POINT_DEFENSE).add("shard_right_Shock", 10.0f);
        small.get(ShardType.MISSILE).add("shard_left_Missile", 10.0f);
        small.get(ShardType.MISSILE).add("shard_right_Missile", 10.0f);
        ShardTypeVariants medium = new ShardTypeVariants();
        variantData.put(ShipAPI.HullSize.DESTROYER, medium);
        medium.get(ShardType.GENERAL).add("facet_Attack");
        medium.get(ShardType.GENERAL).add("facet_Attack2");
        medium.get(ShardType.ANTI_ARMOR).add("facet_Armorbreaker");
        medium.get(ShardType.ANTI_SHIELD).add("facet_Shieldbreaker");
        medium.get(ShardType.POINT_DEFENSE).add("facet_Defense");
        medium.get(ShardType.MISSILE).add("facet_Missile");
        ShardTypeVariants large = new ShardTypeVariants();
        variantData.put(ShipAPI.HullSize.CRUISER, large);
        large.get(ShardType.GENERAL).add("tesseract_Attack");
        large.get(ShardType.GENERAL).add("tesseract_Attack2");
        large.get(ShardType.GENERAL).add("tesseract_Strike");
        large.get(ShardType.GENERAL).add("tesseract_Disruptor");
        large.get(ShardType.ANTI_ARMOR).add("tesseract_Disruptor");
        large.get(ShardType.ANTI_ARMOR).add("tesseract_Strike");
        large.get(ShardType.ANTI_SHIELD).add("tesseract_Shieldbreaker");
        large.get(ShardType.POINT_DEFENSE).add("tesseract_Defense");
        large.get(ShardType.MISSILE).add("tesseract_Strike");
    }

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getBreakProb().modifyMult(id, 0.0f);
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (ship.getOriginalOwner() != 0) {
            engine.setCombatNotOverForAtLeast(SPAWN_TIME + 1.0f);
        }
        if (!ship.isHulk() || !engine.isEntityInPlay(ship)) {
            return;
        }
        String key = String.valueOf(DATA_KEY) + "_" + ship.getId();
        ShardSpawnerData data = (ShardSpawnerData)engine.getCustomData().get(key);
        if (data == null) {
            data = new ShardSpawnerData();
            engine.getCustomData().put(key, data);
        }
        if (data.done) {
            return;
        }
        ship.setHitpoints(ship.getMaxHitpoints());
        ship.getMutableStats().getHullDamageTakenMult().modifyMult("ShardSpawnerInvuln", 0.0f);
        data.delay -= amount;
        if (data.delay > 0.0f) {
            return;
        }
        float dur = SPAWN_TIME;
        float extraDur = 0.0f;
        float splitWeight = 0.0f;
        float probNothingAtAll = 0.0f;
        float cruiserProb = 0.0f;
        float cruiserProbMult = 0.0f;
        float maxCruisers = 0.0f;
        float destroyerProb = 0.0f;
        float destroyerProbMult = 0.0f;
        float maxDestroyers = 0.0f;
        float frigateProb = 0.0f;
        float frigateProbMult = 0.0f;
        float maxFrigates = 0.0f;
        if (ship.isCapital()) {
            splitWeight = 12.0f;
            cruiserProb = 1.0f;
            cruiserProbMult = 0.5f;
            maxCruisers = 1.0f;
            destroyerProb = 1.0f;
            destroyerProbMult = 1.0f;
            maxDestroyers = 2.0f;
            frigateProb = 1.0f;
            frigateProbMult = 1.0f;
            maxFrigates = 3.0f;
        } else if (ship.isCruiser()) {
            splitWeight = 7.0f;
            destroyerProb = 1.0f;
            destroyerProbMult = 0.5f;
            maxDestroyers = 1.0f;
            frigateProb = 1.0f;
            frigateProbMult = 1.0f;
            maxFrigates = 2.0f;
        } else if (ship.isDestroyer()) {
            splitWeight = 4.0f;
            frigateProb = 1.0f;
            frigateProbMult = 1.0f;
            maxFrigates = 2.0f;
        } else if (ship.isFrigate()) {
            splitWeight = 2.0f;
        }
        WeightedRandomPicker<ShardType> typePicker = this.getTypePickerBasedOnLocalConditions(ship);
        if ((float)Math.random() < probNothingAtAll) {
            splitWeight = 0.0f;
        }
        WeightedRandomPicker<Object> spawnAngles = new WeightedRandomPicker();
        int spawnAnglesIter = 0;
        float angleOffset = (float)Math.random() * 360.0f;
        float addedWeight = 0.0f;
        float fighters = 0.0f;
        float frigates = 0.0f;
        float destroyers = 0.0f;
        float cruisers = 0.0f;
        ArrayList<ShardFadeInPlugin> shards = new ArrayList<ShardFadeInPlugin>();
        while (addedWeight < splitWeight) {
            ShardTypeVariants variants;
            WeightedRandomPicker<String> variantPicker;
            ShardType type = typePicker.pick();
            float rem = splitWeight - addedWeight;
            boolean cruiser = (float)Math.random() < cruiserProb && cruisers < maxCruisers && rem >= 3.5f;
            boolean destroyer = (float)Math.random() < destroyerProb && destroyers < maxDestroyers && rem >= 1.5f;
            boolean frigate = (float)Math.random() < frigateProb && frigates < maxFrigates;
            String variant = null;
            float weight = 1.0f;
            if (cruiser && (variant = (variantPicker = (variants = variantData.get((Object)ShipAPI.HullSize.CRUISER)).get(type)).pick()) != null) {
                weight = 4.0f;
                cruisers += 1.0f;
                cruiserProb *= cruiserProbMult;
            }
            if (destroyer && variant == null && (variant = (variantPicker = (variants = variantData.get((Object)ShipAPI.HullSize.DESTROYER)).get(type)).pick()) != null) {
                weight = 2.0f;
                destroyers += 1.0f;
                destroyerProb *= destroyerProbMult;
            }
            if (frigate && variant == null && (variant = (variantPicker = (variants = variantData.get((Object)ShipAPI.HullSize.FRIGATE)).get(type)).pick()) != null) {
                weight = 1.0f;
                frigates += 1.0f;
                frigateProb *= frigateProbMult;
            }
            if (variant == null && (variant = (variantPicker = (variants = variantData.get((Object)ShipAPI.HullSize.FIGHTER)).get(type)).pick()) != null) {
                fighters += 1.0f;
            }
            if (variant != null) {
                if (spawnAngles == null || spawnAngles.isEmpty()) {
                    spawnAngles = this.getSpawnAngles(spawnAnglesIter++);
                }
                float angle = ((Float)spawnAngles.pickAndRemove()).floatValue() + angleOffset;
                ShardFadeInPlugin shard = this.createShipFadeInPlugin(variant, ship, extraDur, dur, angle);
                shards.add(shard);
                Global.getCombatEngine().addPlugin(shard);
                addedWeight += weight;
                continue;
            }
            addedWeight += 0.1f;
        }
        Global.getCombatEngine().addPlugin(this.createShipFadeOutPlugin(ship, dur + extraDur * 0.5f, shards));
        data.done = true;
    }

    public WeightedRandomPicker<Float> getSpawnAngles(int iter) {
        WeightedRandomPicker<Float> picker = new WeightedRandomPicker<Float>();
        float start = 0.0f;
        float incr = 60.0f;
        if (iter == 1) {
            start = 30.0f;
        } else if (iter == 2) {
            start = 15.0f;
            incr = 30.0f;
        } else {
            incr = 10.0f;
        }
        float i = start;
        while (i < 360.0f + start) {
            picker.add(Float.valueOf(i));
            i += incr;
        }
        return picker;
    }

    public WeightedRandomPicker<ShardType> getTypePickerBasedOnLocalConditions(ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        float checkRadius = 5000.0f;
        Iterator<Object> iter = engine.getAiGridShips().getCheckIterator(ship.getLocation(), checkRadius * 2.0f, checkRadius * 2.0f);
        float weightFighters = 0.0f;
        float weightGoodShields = 0.0f;
        float weightGoodArmor = 0.0f;
        float weightVulnerable = 0.0f;
        float weightCarriers = 0.0f;
        float weightEnemies = 0.0f;
        float weightFriends = 0.0f;
        while (iter.hasNext()) {
            float w;
            boolean enemy;
            ShipAPI other;
            Object o = iter.next();
            if (!(o instanceof ShipAPI) || (other = (ShipAPI)o).getOwner() == 100) continue;
            boolean bl = enemy = ship.getOwner() != other.getOwner();
            if (enemy) {
                if (other.isFighter() || other.isDrone()) {
                    weightFighters += 0.25f;
                    weightEnemies += 0.25f;
                    continue;
                }
                w = Misc.getShipWeight(other);
                weightEnemies += w;
                if (this.hasGoodShields(other)) {
                    weightGoodShields += w;
                }
                if (this.hasGoodArmor(other)) {
                    weightGoodArmor += w;
                }
                if (this.isVulnerableToMissileBarrage(ship, other)) {
                    weightVulnerable += w;
                }
                if (!other.getVariant().isCarrier()) continue;
                weightCarriers += w;
                continue;
            }
            if (other.isFighter() || other.isDrone()) {
                weightFriends += 0.25f;
                continue;
            }
            w = Misc.getShipWeight(other);
            weightFriends += w;
        }
        WeightedRandomPicker<ShardType> picker = new WeightedRandomPicker<ShardType>();
        float total = weightFighters + weightGoodShields + weightGoodArmor + weightVulnerable + weightCarriers;
        if (total <= 1.0f) {
            total = 1.0f;
        }
        float antiFighter = (weightFighters + weightCarriers) / total;
        float antiShield = weightGoodShields / total;
        float antiArmor = weightGoodArmor / total;
        float missile = weightVulnerable / total;
        float friends = weightFriends / Math.max(1.0f, weightEnemies + weightFriends);
        picker.add(ShardType.GENERAL, 0.0f + (1.0f - friends) * 0.4f);
        float unlikelyWeight = 0.0f;
        float unlikelyThreshold = 0.2f;
        if (antiFighter < unlikelyThreshold) {
            antiFighter = unlikelyWeight;
        }
        picker.add(ShardType.POINT_DEFENSE, antiFighter);
        if (antiShield < unlikelyThreshold) {
            antiShield = unlikelyWeight;
        }
        picker.add(ShardType.ANTI_SHIELD, antiShield);
        if (antiArmor < unlikelyThreshold) {
            antiArmor = unlikelyWeight;
        }
        picker.add(ShardType.ANTI_ARMOR, antiArmor);
        if (missile < unlikelyThreshold) {
            missile = unlikelyWeight;
        }
        picker.add(ShardType.MISSILE, missile);
        return picker;
    }

    public boolean isVulnerableToMissileBarrage(ShipAPI from, ShipAPI other) {
        float incap = Misc.getIncapacitatedTime(other);
        float dist = Misc.getDistance(from.getLocation(), other.getLocation());
        if (dist > 2000.0f) {
            return false;
        }
        float assumedMissileSpeed = 500.0f;
        float eta = dist / assumedMissileSpeed;
        eta += SPAWN_TIME;
        return incap >= (eta += 2.0f) || other.getFluxLevel() >= 0.95f && other.getFluxTracker().getTimeToVent() >= eta;
    }

    public boolean hasGoodArmor(ShipAPI other) {
        float requiredArmor = 1240.0f;
        if (other.getArmorGrid().getArmorRating() < requiredArmor) {
            return false;
        }
        float armor = other.getAverageArmorInSlice(other.getFacing(), 120.0f);
        return armor >= requiredArmor * 0.8f;
    }

    public boolean hasGoodShields(ShipAPI other) {
        ShieldAPI shield = other.getShield();
        if (shield == null) {
            return false;
        }
        if (shield.getType() == ShieldAPI.ShieldType.NONE) {
            return false;
        }
        if (shield.getType() == ShieldAPI.ShieldType.PHASE) {
            return false;
        }
        float requiredCapacity = 1.0E7f;
        switch (other.getHullSize()) {
            case CAPITAL_SHIP: {
                requiredCapacity = 25000.0f;
                if (shield.getType() != ShieldAPI.ShieldType.FRONT || !(shield.getArc() < 250.0f)) break;
                requiredCapacity = 1000000.0f;
                break;
            }
            case CRUISER: {
                requiredCapacity = 12500.0f;
                if (shield.getType() != ShieldAPI.ShieldType.FRONT || !(shield.getArc() < 250.0f)) break;
                requiredCapacity = 1000000.0f;
                break;
            }
            case DESTROYER: {
                requiredCapacity = 8000.0f;
                break;
            }
            case FRIGATE: {
                requiredCapacity = 4000.0f;
            }
        }
        float e = other.getShield().getFluxPerPointOfDamage() * other.getMutableStats().getShieldDamageTakenMult().getModifiedValue();
        float capacity = other.getMaxFlux();
        return (capacity /= Math.max(0.1f, e)) >= requiredCapacity && e <= 1.0f;
    }

    protected EveryFrameCombatPlugin createShipFadeOutPlugin(final ShipAPI ship, final float fadeOutTime, final List<ShardFadeInPlugin> shards) {
        return new BaseEveryFrameCombatPlugin(){
            float elapsed = 0.0f;
            IntervalUtil interval = new IntervalUtil(0.075f, 0.125f);

            protected void pushShipsAway(float amount) {
                Vector2f com = new Vector2f();
                float count = 0.0f;
                for (ShardFadeInPlugin shard : shards) {
                    ShipAPI ship2 = shard.ships[0];
                    if (ship2.isFighter()) continue;
                    Vector2f.add((Vector2f)com, (Vector2f)ship2.getLocation(), (Vector2f)com);
                    count += 1.0f;
                }
                com.scale(1.0f / Math.max(1.0f, count));
                Vector2f comForFighters = new Vector2f();
                count = 0.0f;
                for (ShardFadeInPlugin shard : shards) {
                    ShipAPI ship3 = shard.ships[0];
                    if (!ship3.isFighter()) continue;
                    Vector2f.add((Vector2f)comForFighters, (Vector2f)ship3.getLocation(), (Vector2f)comForFighters);
                    count += 1.0f;
                }
                comForFighters.scale(1.0f / Math.max(1.0f, count));
                float progress = this.elapsed / fadeOutTime;
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                for (ShardFadeInPlugin shard : shards) {
                    ShipAPI ship4 = shard.ships[0];
                    Vector2f currCom = com;
                    if (ship4.isFighter()) {
                        currCom = comForFighters;
                    }
                    Vector2f dir = Misc.getUnitVectorAtDegreeAngle(Misc.getAngleInDegrees(currCom, ship4.getLocation()));
                    float speed = ship4.getCollisionRadius() * 0.5f;
                    dir.scale(amount * speed * progress);
                    Vector2f.add((Vector2f)ship4.getLocation(), (Vector2f)dir, (Vector2f)ship4.getLocation());
                }
            }

            @Override
            public void advance(float amount, List<InputEventAPI> events) {
                float jitterLevel;
                if (Global.getCombatEngine().isPaused()) {
                    return;
                }
                this.elapsed += amount;
                float progress = this.elapsed / fadeOutTime;
                if (progress > 1.0f) {
                    progress = 1.0f;
                }
                ship.setAlphaMult(1.0f - progress);
                this.pushShipsAway(amount);
                if (progress > 0.5f) {
                    ship.setCollisionClass(CollisionClass.NONE);
                }
                jitterLevel = (jitterLevel = progress) < 0.5f ? (jitterLevel *= 2.0f) : (1.0f - jitterLevel) * 2.0f;
                float jitterRange = progress;
                float maxRangeBonus = 100.0f;
                float jitterRangeBonus = jitterRange * maxRangeBonus;
                Color c = JITTER_COLOR;
                int alpha = c.getAlpha();
                alpha = (int)((float)alpha + 100.0f * progress);
                if (alpha > 255) {
                    alpha = 255;
                }
                c = Misc.setAlpha(c, alpha);
                ship.setJitter(this, c, jitterLevel, 35, 0.0f, jitterRangeBonus);
                this.interval.advance(amount);
                if (this.interval.intervalElapsed() && this.elapsed < fadeOutTime * 0.75f) {
                    CombatEngineAPI engine = Global.getCombatEngine();
                    c = RiftLanceEffect.getColorForDarkening(RiftCascadeEffect.STANDARD_RIFT_COLOR);
                    float baseDuration = 2.0f;
                    Vector2f vel = new Vector2f((ReadableVector2f)ship.getVelocity());
                    float size = ship.getCollisionRadius() * 0.35f;
                    int i = 0;
                    while (i < 3) {
                        Vector2f point = new Vector2f((ReadableVector2f)ship.getLocation());
                        point = Misc.getPointWithinRadiusUniform(point, ship.getCollisionRadius() * 0.5f, Misc.random);
                        float dur = baseDuration + baseDuration * (float)Math.random();
                        float nSize = size;
                        Vector2f pt = Misc.getPointWithinRadius(point, nSize * 0.5f);
                        Vector2f v = Misc.getUnitVectorAtDegreeAngle((float)Math.random() * 360.0f);
                        v.scale(nSize + nSize * (float)Math.random() * 0.5f);
                        v.scale(0.2f);
                        Vector2f.add((Vector2f)vel, (Vector2f)v, (Vector2f)v);
                        float maxSpeed = nSize * 1.5f * 0.2f;
                        float minSpeed = nSize * 1.0f * 0.2f;
                        float overMin = v.length() - minSpeed;
                        if (overMin > 0.0f) {
                            float durMult = 1.0f - overMin / (maxSpeed - minSpeed);
                            if (durMult < 0.1f) {
                                durMult = 0.1f;
                            }
                            dur *= 0.5f + 0.5f * durMult;
                        }
                        engine.addNegativeNebulaParticle(pt, v, nSize * 1.0f, 2.0f, 0.5f / dur, 0.0f, dur, c);
                        ++i;
                    }
                }
                if (this.elapsed > fadeOutTime) {
                    ship.setHitpoints(0.0f);
                    Global.getCombatEngine().removeEntity(ship);
                    ship.setAlphaMult(0.0f);
                    Global.getCombatEngine().removePlugin(this);
                }
            }
        };
    }

    protected ShardFadeInPlugin createShipFadeInPlugin(String variantId, ShipAPI source, float delay, float fadeInTime, float angle) {
        return new ShardFadeInPlugin(variantId, source, delay, fadeInTime, angle);
    }

    public static class ShardFadeInPlugin
    extends BaseEveryFrameCombatPlugin {
        float elapsed = 0.0f;
        ShipAPI[] ships = null;
        CollisionClass collisionClass;
        String variantId;
        ShipAPI source;
        float delay;
        float fadeInTime;
        float angle;

        public ShardFadeInPlugin(String variantId, ShipAPI source, float delay, float fadeInTime, float angle) {
            this.variantId = variantId;
            this.source = source;
            this.delay = delay;
            this.fadeInTime = fadeInTime;
            this.angle = angle;
        }

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            ShipAPI ship;
            float progress;
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            this.elapsed += amount;
            if (this.elapsed < this.delay) {
                return;
            }
            CombatEngineAPI engine = Global.getCombatEngine();
            if (this.ships == null) {
                float facing = this.source.getFacing() + 15.0f * ((float)Math.random() - 0.5f);
                Vector2f loc = Misc.getUnitVectorAtDegreeAngle(this.angle);
                loc.scale(this.source.getCollisionRadius() * 0.1f);
                Vector2f.add((Vector2f)loc, (Vector2f)this.source.getLocation(), (Vector2f)loc);
                CombatFleetManagerAPI fleetManager = engine.getFleetManager(this.source.getOriginalOwner());
                boolean wasSuppressed = fleetManager.isSuppressDeploymentMessages();
                fleetManager.setSuppressDeploymentMessages(true);
                if (this.variantId.endsWith("_wing")) {
                    FighterWingSpecAPI spec = Global.getSettings().getFighterWingSpec(this.variantId);
                    this.ships = new ShipAPI[spec.getNumFighters()];
                    PersonAPI captain = Global.getSettings().createPerson();
                    captain.setPersonality("reckless");
                    captain.getStats().setSkillLevel("point_defense", 2.0f);
                    captain.getStats().setSkillLevel("gunnery_implants", 2.0f);
                    captain.getStats().setSkillLevel("impact_mitigation", 2.0f);
                    ShipAPI leader = engine.getFleetManager(this.source.getOriginalOwner()).spawnShipOrWing(this.variantId, loc, facing, 0.0f, captain);
                    int i = 0;
                    while (i < this.ships.length) {
                        this.ships[i] = leader.getWing().getWingMembers().get(i);
                        this.ships[i].getLocation().set((ReadableVector2f)loc);
                        ++i;
                    }
                    this.collisionClass = this.ships[0].getCollisionClass();
                } else {
                    this.ships = new ShipAPI[1];
                    this.ships[0] = engine.getFleetManager(this.source.getOriginalOwner()).spawnShipOrWing(this.variantId, loc, facing, 0.0f, this.source.getOriginalCaptain());
                }
                int i = 0;
                while (i < this.ships.length) {
                    FactionAPI faction;
                    this.ships[i].cloneVariant();
                    this.ships[i].getVariant().addTag("ship_limited_tooltip");
                    if ((Global.getCombatEngine().isInCampaign() || Global.getCombatEngine().isInCampaignSim()) && (faction = Global.getSector().getFaction("omega")) != null) {
                        String name = faction.pickRandomShipName();
                        this.ships[i].setName(name);
                    }
                    ++i;
                }
                fleetManager.setSuppressDeploymentMessages(wasSuppressed);
                this.collisionClass = this.ships[0].getCollisionClass();
                DeployedFleetMemberAPI sourceMember = fleetManager.getDeployedFleetMemberFromAllEverDeployed(this.source);
                DeployedFleetMemberAPI deployed = fleetManager.getDeployedFleetMemberFromAllEverDeployed(this.ships[0]);
                if (sourceMember != null && deployed != null) {
                    Map<DeployedFleetMemberAPI, DeployedFleetMemberAPI> map = fleetManager.getShardToOriginalShipMap();
                    while (map.containsKey(sourceMember)) {
                        sourceMember = map.get(sourceMember);
                    }
                    if (sourceMember != null) {
                        map.put(deployed, sourceMember);
                    }
                }
            }
            if ((progress = (this.elapsed - this.delay) / this.fadeInTime) > 1.0f) {
                progress = 1.0f;
            }
            int i = 0;
            while (i < this.ships.length) {
                ship = this.ships[i];
                ship.setAlphaMult(progress);
                if (progress < 0.5f) {
                    ship.blockCommandForOneFrame(ShipCommand.ACCELERATE);
                    ship.blockCommandForOneFrame(ShipCommand.TURN_LEFT);
                    ship.blockCommandForOneFrame(ShipCommand.TURN_RIGHT);
                    ship.blockCommandForOneFrame(ShipCommand.STRAFE_LEFT);
                    ship.blockCommandForOneFrame(ShipCommand.STRAFE_RIGHT);
                }
                ship.blockCommandForOneFrame(ShipCommand.USE_SYSTEM);
                ship.blockCommandForOneFrame(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK);
                ship.blockCommandForOneFrame(ShipCommand.FIRE);
                ship.blockCommandForOneFrame(ShipCommand.PULL_BACK_FIGHTERS);
                ship.blockCommandForOneFrame(ShipCommand.VENT_FLUX);
                ship.setHoldFireOneFrame(true);
                ship.setHoldFire(true);
                ship.setCollisionClass(CollisionClass.NONE);
                ship.getMutableStats().getHullDamageTakenMult().modifyMult("ShardSpawnerInvuln", 0.0f);
                if (progress < 0.5f) {
                    ship.getVelocity().set((ReadableVector2f)this.source.getVelocity());
                } else if (progress > 0.75f) {
                    ship.setCollisionClass(this.collisionClass);
                    ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("ShardSpawnerInvuln");
                }
                float jitterLevel = progress;
                jitterLevel = jitterLevel < 0.5f ? (jitterLevel *= 2.0f) : (1.0f - jitterLevel) * 2.0f;
                float jitterRange = 1.0f - progress;
                float maxRangeBonus = 50.0f;
                float jitterRangeBonus = jitterRange * maxRangeBonus;
                Color c = JITTER_COLOR;
                ship.setJitter(this, c, jitterLevel, 25, 0.0f, jitterRangeBonus);
                ++i;
            }
            if (this.elapsed > this.fadeInTime) {
                i = 0;
                while (i < this.ships.length) {
                    ship = this.ships[i];
                    ship.setAlphaMult(1.0f);
                    ship.setHoldFire(false);
                    ship.setCollisionClass(this.collisionClass);
                    ship.getMutableStats().getHullDamageTakenMult().unmodifyMult("ShardSpawnerInvuln");
                    ++i;
                }
                engine.removePlugin(this);
            }
        }
    }

    public static class ShardSpawnerData {
        boolean done = false;
        float delay = 2.0f + (float)Math.random() * 1.0f;
    }

    public static enum ShardType {
        GENERAL,
        ANTI_ARMOR,
        ANTI_SHIELD,
        POINT_DEFENSE,
        MISSILE;

    }

    public static class ShardTypeVariants {
        public Map<ShardType, WeightedRandomPicker<String>> variants = new HashMap<ShardType, WeightedRandomPicker<String>>();

        public WeightedRandomPicker<String> get(ShardType type) {
            WeightedRandomPicker<String> result = this.variants.get((Object)type);
            if (result == null) {
                result = new WeightedRandomPicker();
                this.variants.put(type, result);
            }
            return result;
        }
    }
}

