/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class StealthMinefield
extends BaseHullMod {
    public static String MINEFIELD_DATA_KEY = "minefield_data_key";

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        super.advanceInCombat(ship, amount);
        CombatEngineAPI engine = Global.getCombatEngine();
        MinefieldData data = (MinefieldData)engine.getCustomData().get(MINEFIELD_DATA_KEY);
        if (data == null) {
            data = new MinefieldData();
            data.source = ship;
            engine.getCustomData().put(MINEFIELD_DATA_KEY, data);
        }
        if (data.source != ship) {
            return;
        }
        if (!ship.isAlive()) {
            return;
        }
        for (IncomingMine inc : new ArrayList<IncomingMine>(data.incoming)) {
            inc.delay -= amount;
            if (!(inc.delay <= 0.0f)) continue;
            this.spawnMine(ship, inc.mineLoc, inc.target);
            data.incoming.remove(inc);
        }
        data.tracker.advance(amount);
        if (!data.tracker.intervalElapsed()) {
            return;
        }
        WeightedRandomPicker<IncomingMine> picker = new WeightedRandomPicker<IncomingMine>();
        for (ShipAPI enemy : engine.getShips()) {
            float minOk;
            Vector2f mineLoc;
            if (enemy == ship || enemy.isHulk() || enemy.getOwner() == ship.getOwner() || enemy.isFighter() || enemy.isDrone() || enemy.isStation() || enemy.isStationModule() || enemy.getTravelDrive() != null && enemy.getTravelDrive().isActive() || (float)Math.random() > 0.25f || !this.isAreaClear(mineLoc = Misc.getPointAtRadius(enemy.getLocation(), enemy.getCollisionRadius() + 400.0f + 200.0f * (float)Math.random()), minOk = 400.0f + enemy.getCollisionRadius())) continue;
            IncomingMine inc = new IncomingMine();
            inc.delay = (float)Math.random() * 1.5f;
            inc.target = enemy;
            inc.mineLoc = mineLoc;
            picker.add(inc);
        }
        int numToSpawn = Math.max(1, Math.min(new Random().nextInt(6) + 5, picker.getItems().size()));
        int i = 0;
        while (i < numToSpawn && !picker.isEmpty()) {
            IncomingMine inc = (IncomingMine)picker.pickAndRemove();
            data.incoming.add(inc);
            ++i;
        }
    }

    public void spawnMine(ShipAPI source, Vector2f mineLoc, ShipAPI target) {
        float mineDir = Misc.getAngleInDegrees(mineLoc, target.getLocation());
        CombatEngineAPI engine = Global.getCombatEngine();
        Vector2f currLoc = Misc.getPointAtRadius(mineLoc, 50.0f + (float)Math.random() * 50.0f);
        MissileAPI mine = (MissileAPI)engine.spawnProjectile(source, null, this.getWeaponId(), currLoc, mineDir, null);
        if (source != null) {
            Global.getCombatEngine().applyDamageModifiersToSpawnedProjectileWithNullWeapon(source, WeaponAPI.WeaponType.MISSILE, false, mine.getDamage());
        }
        mine.setFlightTime((float)Math.random());
        mine.fadeOutThenIn(1.0f);
        Global.getSoundPlayer().playSound("mine_spawn", 1.0f, 1.0f, mine.getLocation(), mine.getVelocity());
    }

    protected String getWeaponId() {
        return "minelayer2";
    }

    public boolean isAreaClear(Vector2f loc, float range) {
        float dist;
        CombatEngineAPI engine = Global.getCombatEngine();
        for (ShipAPI shipAPI : engine.getShips()) {
            if (shipAPI.isFighter() || shipAPI.isDrone() || !((dist = Misc.getDistance(loc, shipAPI.getLocation())) < range)) continue;
            return false;
        }
        for (CombatEntityAPI combatEntityAPI : Global.getCombatEngine().getAsteroids()) {
            dist = Misc.getDistance(loc, combatEntityAPI.getLocation());
            if (!(dist < combatEntityAPI.getCollisionRadius() + 100.0f)) continue;
            return false;
        }
        return true;
    }

    public static class IncomingMine {
        Vector2f mineLoc;
        float delay;
        ShipAPI target;
    }

    public static class MinefieldData {
        ShipAPI source;
        IntervalUtil tracker = new IntervalUtil(0.5f, 1.5f);
        List<IncomingMine> incoming = new ArrayList<IncomingMine>();
    }
}

