/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.loading;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CampaignPingSpec {
    private String id;
    private List<String> sounds = new ArrayList<String>();
    private Color color;
    private float minRange;
    private float range;
    private float duration;
    private float delay = 1.0f;
    private float width;
    private float alphaMult = 1.0f;
    private float inFraction = 0.1f;
    private boolean invert;
    private boolean useFactionColor;
    private int num = 1;

    public CampaignPingSpec() {
    }

    public CampaignPingSpec(String id, Color color, JSONObject json) throws JSONException {
        this.id = id;
        this.color = color;
        this.sounds = new ArrayList<String>();
        JSONArray arr = json.optJSONArray("sounds");
        if (arr != null) {
            int i = 0;
            while (i < arr.length()) {
                this.sounds.add(arr.getString(i));
                ++i;
            }
        }
        this.inFraction = (float)json.optDouble("inFraction", (double)0.1f);
        this.minRange = (float)json.optDouble("minRange", 0.0);
        this.range = (float)json.getDouble("range");
        this.width = (float)json.getDouble("width");
        this.duration = (float)json.getDouble("duration");
        this.delay = (float)json.optDouble("delay", 1.0);
        this.alphaMult = (float)json.optDouble("alphaMult", 1.0);
        this.num = json.optInt("num", 1);
        this.invert = json.optBoolean("invert", false);
        this.useFactionColor = json.optBoolean("useFactionColor", false);
    }

    public float getAlphaMult() {
        return this.alphaMult;
    }

    public float getInFraction() {
        return this.inFraction;
    }

    public boolean isUseFactionColor() {
        return this.useFactionColor;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getSounds() {
        return this.sounds;
    }

    public Color getColor() {
        return this.color;
    }

    public float getRange() {
        return this.range;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getDelay() {
        return this.delay;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public int getNum() {
        return this.num;
    }

    public float getWidth() {
        return this.width;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSounds(List<String> sounds) {
        this.sounds = sounds;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setMinRange(float minRange) {
        this.minRange = minRange;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setDelay(float delay) {
        this.delay = delay;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setAlphaMult(float alphaMult) {
        this.alphaMult = alphaMult;
    }

    public void setInFraction(float inFraction) {
        this.inFraction = inFraction;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public void setUseFactionColor(boolean useFactionColor) {
        this.useFactionColor = useFactionColor;
    }

    public void setNum(int num) {
        this.num = num;
    }
}

